/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBRecord;
import db.LongKeyNode;
import db.LongKeyRecordNode;
import db.NodeMgr;
import db.Schema;
import db.buffers.DataBuffer;
import ghidra.util.exception.AssertException;
import java.io.IOException;

class FixedRecNode
extends LongKeyRecordNode {
    private static final int HEADER_SIZE = 13;
    private static final int ENTRY_BASE_OFFSET = 13;
    private static final int KEY_SIZE = 8;
    private static final int[] EMPTY_ID_LIST = new int[0];
    private int entrySize;
    private int recordLength;

    FixedRecNode(NodeMgr nodeMgr, DataBuffer buf, int recordLength) {
        super(nodeMgr, buf);
        this.recordLength = recordLength;
        this.entrySize = 8 + recordLength;
    }

    FixedRecNode(NodeMgr nodeMgr, int recordLength, int prevLeafId, int nextLeafId) throws IOException {
        super(nodeMgr, (byte)2, prevLeafId, nextLeafId);
        this.recordLength = recordLength;
        this.entrySize = 8 + recordLength;
    }

    @Override
    LongKeyRecordNode createNewLeaf(int prevLeafId, int nextLeafId) throws IOException {
        return new FixedRecNode(this.nodeMgr, this.recordLength, prevLeafId, nextLeafId);
    }

    @Override
    long getKey(int index) {
        return this.buffer.getLong(this.getKeyOffset(index));
    }

    @Override
    public int getKeyOffset(int index) {
        return 13 + index * this.entrySize;
    }

    @Override
    public int getRecordOffset(int index) {
        return 13 + index * this.entrySize;
    }

    private void shiftRecords(int index, boolean rightShift) {
        if (index == this.keyCount) {
            return;
        }
        int start = this.getRecordOffset(index);
        int end = this.getRecordOffset(this.keyCount);
        int len = end - start;
        int offset = start + (rightShift ? this.entrySize : -this.entrySize);
        this.buffer.move(start, offset, len);
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.keyCount) {
            throw new AssertException();
        }
        this.shiftRecords(index + 1, false);
        this.setKeyCount(this.keyCount - 1);
    }

    @Override
    boolean insertRecord(int index, DBRecord record) throws IOException {
        if (this.keyCount == (this.buffer.length() - 13) / this.entrySize) {
            return false;
        }
        this.shiftRecords(index, true);
        int offset = this.getRecordOffset(index);
        this.buffer.putLong(offset, record.getKey());
        record.write(this.buffer, offset + 8);
        this.setKeyCount(this.keyCount + 1);
        return true;
    }

    @Override
    LongKeyNode updateRecord(int index, DBRecord record) throws IOException {
        int offset = this.getRecordOffset(index) + 8;
        record.write(this.buffer, offset);
        return this.getRoot();
    }

    @Override
    DBRecord getRecord(long key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return null;
        }
        DBRecord record = schema.createRecord(key);
        record.read(this.buffer, this.getRecordOffset(index) + 8);
        return record;
    }

    @Override
    public DBRecord getRecord(Schema schema, int index) throws IOException {
        long key = this.getKey(index);
        DBRecord record = schema.createRecord(key);
        record.read(this.buffer, this.getRecordOffset(index) + 8);
        return record;
    }

    @Override
    void splitData(LongKeyRecordNode newRightLeaf) {
        FixedRecNode rightNode = (FixedRecNode)newRightLeaf;
        int splitIndex = this.keyCount / 2;
        int count = this.keyCount - splitIndex;
        int start = this.getRecordOffset(splitIndex);
        int end = this.getRecordOffset(this.keyCount);
        int splitLen = end - start;
        rightNode.buffer.copy(13, this.buffer, start, splitLen);
        this.setKeyCount(this.keyCount - count);
        rightNode.setKeyCount(count);
    }

    @Override
    public void delete() throws IOException {
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        return EMPTY_ID_LIST;
    }
}

