/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.tar;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.tar.TarFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.lang3.ArrayUtils;

public class TarFileSystemFactory
implements GFileSystemFactoryByteProvider<TarFileSystem>,
GFileSystemProbeBytesOnly,
GFileSystemProbeByteProvider {
    public static final int TAR_MAGIC_BYTES_REQUIRED = 265;
    private static final String[] TAR_EXTS = new String[]{".tar", ".tgz", ".tar.gz", ".tbz2", ".tar.bz2"};

    public TarFileSystem create(FSRLRoot targetFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        FSRL containerFSRL = provider.getFSRL();
        ByteProvider uncompressedBP = provider;
        if (TarFileSystemFactory.isCompressedMagicBytes(provider)) {
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, provider.length());
            uncompressedBP = fsService.getDerivedByteProvider(containerFSRL, null, "uncompressed tar", -1L, () -> {
                Msg.info(TarFileSystem.class, (Object)("Uncompressing tar file " + containerFSRL));
                return TarFileSystemFactory.newFileInputStreamAutoDetectCompressed(provider);
            }, (TaskMonitor)upwtm);
            provider.close();
        }
        TarFileSystem fs = new TarFileSystem(targetFSRL, uncompressedBP, fsService);
        fs.mount(monitor);
        return fs;
    }

    public int getBytesRequired() {
        return 265;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return TarArchiveInputStream.matches((byte[])startBytes, (int)startBytes.length);
    }

    public boolean probe(ByteProvider provider, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        String filename = provider.getFSRL().getName();
        String ext = FSUtilities.getExtension((String)filename, (int)1);
        if (ext == null) {
            return false;
        }
        String string = ext = ".gz".equals(ext = ext.toLowerCase()) || ".bz2".equals(ext) ? FSUtilities.getExtension((String)filename, (int)2) : ext;
        if (!ArrayUtils.contains((Object[])TAR_EXTS, (Object)ext)) {
            return false;
        }
        if (!TarFileSystemFactory.isCompressedMagicBytes(provider)) {
            return false;
        }
        try (InputStream is = TarFileSystemFactory.newFileInputStreamAutoDetectCompressed(provider);){
            byte[] startBytes = new byte[265];
            if (is.read(startBytes) != 265) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.probeStartBytes(provider.getFSRL(), startBytes);
            return bl;
        }
    }

    private static InputStream newFileInputStreamAutoDetectCompressed(ByteProvider bp) throws IOException {
        int magicBytes = TarFileSystemFactory.readMagicBytes(bp);
        InputStream is = bp.getInputStream(0L);
        switch (magicBytes) {
            case 35615: {
                return new GZIPInputStream(is);
            }
            case 23106: {
                return new BZip2CompressorInputStream(is);
            }
        }
        return is;
    }

    private static boolean isCompressedMagicBytes(ByteProvider bp) throws IOException {
        int magicBytes = TarFileSystemFactory.readMagicBytes(bp);
        switch (magicBytes) {
            case 23106: 
            case 35615: {
                return true;
            }
        }
        return false;
    }

    private static int readMagicBytes(ByteProvider bp) throws IOException {
        BinaryReader br = new BinaryReader(bp, true);
        int magicBytes = br.readUnsignedShort(0L);
        return magicBytes;
    }
}

