/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4XattrHeader
implements StructConverter {
    private int h_magic;
    private int h_refcount;
    private int h_blocks;
    private int h_hash;
    private int h_checksum;
    private int[] h_reserved;

    public Ext4XattrHeader(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4XattrHeader(BinaryReader reader) throws IOException {
        this.h_magic = reader.readNextInt();
        this.h_refcount = reader.readNextInt();
        this.h_blocks = reader.readNextInt();
        this.h_hash = reader.readNextInt();
        this.h_checksum = reader.readNextInt();
        this.h_reserved = reader.readNextIntArray(2);
    }

    public int getH_magic() {
        return this.h_magic;
    }

    public int getH_refcount() {
        return this.h_refcount;
    }

    public int getH_blocks() {
        return this.h_blocks;
    }

    public int getH_hash() {
        return this.h_hash;
    }

    public int getH_checksum() {
        return this.h_checksum;
    }

    public int[] getH_reserved() {
        return this.h_reserved;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_xattr_header", 0);
        structure.add(DWORD, "h_magic", null);
        structure.add(DWORD, "h_refcount", null);
        structure.add(DWORD, "h_blocks", null);
        structure.add(DWORD, "h_hash", null);
        structure.add(DWORD, "h_checksum", null);
        structure.add((DataType)new ArrayDataType(DWORD, 2, DWORD.getLength()), "h_reserved", null);
        return structure;
    }
}

