/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MmPfn
implements StructConverter {
    public static final String NAME = "PAGEDUMP_PHYS_MEM_RUN";
    private long pteAddress;
    private long origPte;
    private long blink;
    private long flags;
    private int parent;
    private DumpFileReader reader;
    private long index;
    private int psz;

    MmPfn(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.reader.readNextPointer();
        this.setPteAddress(this.reader.readNextPointer());
        this.setOrigPte(this.reader.readNextPointer());
        this.setBlink(this.reader.readNextPointer());
        this.setFlags(this.reader.readNextPointer());
        this.setParent(this.reader.readNextInt());
        this.reader.readNextInt();
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, this.psz, "ListEntry", null);
        struct.add(QWORD, this.psz, "PteAddress", null);
        struct.add(QWORD, this.psz, "OriginalPte", null);
        struct.add(QWORD, this.psz, "", null);
        struct.add(QWORD, this.psz, "", null);
        struct.add(DWORD, 4, "Parent", null);
        struct.add(DWORD, 4, "", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public long getPteAddress() {
        return this.pteAddress;
    }

    public void setPteAddress(long pteAddress) {
        this.pteAddress = pteAddress;
    }

    public int getParent() {
        return this.parent;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public long getOrigPte() {
        return this.origPte;
    }

    public void setOrigPte(long origPte) {
        this.origPte = origPte;
    }

    public long getBlink() {
        return this.blink;
    }

    public void setBlink(long blink) {
        this.blink = blink;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }
}

