/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.file.formats.bplist.NSObject;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class NSData
extends NSObject {
    private byte[] bytes;

    public NSData(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public String getType() {
        return "NSData";
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("NSData_" + this.bytes.length, 0);
        this.addHeader((Structure)structure, this.bytes.length);
        if (this.bytes.length > 0) {
            structure.add((DataType)new ArrayDataType(BYTE, this.bytes.length, BYTE.getLength()), "data", null);
        }
        return structure;
    }

    @Override
    public String toString() {
        return StringUtilities.toQuotedString((byte[])this.bytes);
    }

    public byte[] getData() {
        return this.bytes;
    }
}

