/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.lz4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;

@FileSystemInfo(type="lz4", description="LZ4 Archive Format", factory=GFileSystemBaseFactory.class)
public class LZ4ArchiveFileSystem
extends GFileSystemBase {
    public static final int ARCHIVE_MAGIC = 407642370;
    public static final byte[] ARCHIVE_MAGIC_BYTES = new byte[]{2, 33, 76, 24};
    public static final int LZ4_DEFAULT_UNCOMPRESSED_CHUNK_SIZE = 0x800000;
    public static final String NAME = "lz4_decompressed";
    private GFile decompressedLZ4File = null;

    public LZ4ArchiveFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)ARCHIVE_MAGIC_BYTES.length);
        return Arrays.equals(bytes, ARCHIVE_MAGIC_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException, CancelledException {
        try (ByteProvider payloadBP = this.getPayload(monitor, this.root.getFSRL().appendPath(NAME));){
            this.decompressedLZ4File = GFileImpl.fromFSRL((GFileSystem)this, (GFile)this.root, (FSRL)payloadBP.getFSRL(), (boolean)false, (long)payloadBP.length());
        }
    }

    private ByteProvider getPayload(TaskMonitor monitor, FSRL payloadFSRL) throws CancelledException, IOException {
        return this.fsService.getDerivedByteProviderPush(this.provider.getFSRL(), payloadFSRL, NAME, -1L, os -> {
            BinaryReader reader = new BinaryReader(this.provider, true);
            int magic = reader.readNextInt();
            if (magic != 407642370) {
                throw new IOException("LZ4 archive: invalid magic");
            }
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, this.provider.length());
            upwtm.setMessage("Decompressing LZ4 archive...");
            upwtm.setProgress(0L);
            while (reader.hasNext()) {
                monitor.checkCanceled();
                int compressedChunkSize = reader.readNextInt();
                byte[] compressedChunk = reader.readNextByteArray(compressedChunkSize);
                try (BlockLZ4CompressorInputStream compressedStream = new BlockLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(compressedChunk));){
                    long bytesCopied = FSUtilities.streamCopy((InputStream)compressedStream, (OutputStream)os, (TaskMonitor)TaskMonitor.DUMMY);
                    upwtm.incrementProgress(bytesCopied);
                }
            }
        }, monitor);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (file == this.decompressedLZ4File || file.equals(this.decompressedLZ4File)) {
            return this.getPayload(monitor, file.getFSRL());
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return (directory == null || directory.equals(this.root)) && this.decompressedLZ4File != null ? Arrays.asList(this.decompressedLZ4File) : Collections.emptyList();
    }
}

