/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.cdex.CDexConstants;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.file.formats.android.dex.format.PackedSwitchPayload;
import ghidra.file.formats.android.dex.format.SparseSwitchPayload;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;

public class DexMarkupSwitchTableAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMaximum(set == null ? program.getMemory().getSize() : set.getNumAddresses());
        monitor.setProgress(0L);
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        Listing listing = program.getListing();
        InstructionIterator instructionIterator = listing.getInstructions(set, true);
        while (instructionIterator.hasNext()) {
            Instruction instruction = instructionIterator.next();
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            monitor.setMessage("DEX: Instruction markup ... " + instruction.getMinAddress());
            try {
                DataType dataType;
                Object payload;
                Address address;
                Scalar scalar;
                if (instruction.getMnemonicString().startsWith("packed_switch")) {
                    if (instruction.getMnemonicReferences().length > 0) continue;
                    scalar = instruction.getScalar(1);
                    address = instruction.getMinAddress().add(scalar.getUnsignedValue() * 2L);
                    if (program.getMemory().getShort(address) != 256) {
                        log.appendMsg("invalid packed switch at " + address);
                        continue;
                    }
                    program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), address, RefType.DATA, SourceType.ANALYSIS, 1);
                    reader.setPointerIndex(address.getOffset());
                    payload = new PackedSwitchPayload(reader);
                    dataType = ((PackedSwitchPayload)payload).toDataType();
                    this.createData(program, address, dataType);
                    this.processPacked(program, instruction, (PackedSwitchPayload)payload, monitor);
                    continue;
                }
                if (!instruction.getMnemonicString().startsWith("sparse_switch") || instruction.getMnemonicReferences().length > 0) continue;
                scalar = instruction.getScalar(1);
                address = instruction.getMinAddress().add(scalar.getUnsignedValue() * 2L);
                if (program.getMemory().getShort(address) != 512) {
                    log.appendMsg("invalid sparse switch at " + address);
                    continue;
                }
                program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), address, RefType.DATA, SourceType.ANALYSIS, 1);
                reader.setPointerIndex(address.getOffset());
                payload = new SparseSwitchPayload(reader);
                dataType = ((SparseSwitchPayload)payload).toDataType();
                this.createData(program, address, dataType);
                this.processSparse(program, instruction, (SparseSwitchPayload)payload, monitor);
            }
            catch (MemoryAccessException e) {
                log.appendMsg("unable to process switch at " + instruction.getMinAddress());
            }
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        return DexConstants.isDexFile((ByteProvider)provider) || CDexConstants.isCDEX(program);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.INSTRUCTION_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Android DEX/CDEX Switch Table Markup";
    }

    public String getName() {
        return "Android DEX/CDEX Switch Table Markup";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(3);
    }

    public boolean isPrototype() {
        return false;
    }

    private void processPacked(Program program, Instruction instruction, PackedSwitchPayload payload, TaskMonitor monitor) throws Exception {
        String namespaceName = "pswitch_" + instruction.getMinAddress();
        Namespace nameSpace = DexUtil.getOrCreateNameSpace(program, namespaceName);
        int key = payload.getFirstKey();
        for (int target : payload.getTargets()) {
            monitor.checkCanceled();
            String caseName = "case_0x" + Integer.toHexString(key);
            Address caseAddress = instruction.getMinAddress().add((long)(target * 2));
            program.getSymbolTable().createLabel(caseAddress, caseName, nameSpace, SourceType.ANALYSIS);
            program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), caseAddress, (RefType)RefType.COMPUTED_JUMP, SourceType.ANALYSIS, -1);
            DisassembleCommand dCommand = new DisassembleCommand(caseAddress, null, true);
            dCommand.applyTo((DomainObject)program);
            ++key;
        }
    }

    private void processSparse(Program program, Instruction instruction, SparseSwitchPayload payload, TaskMonitor monitor) throws Exception {
        String namespaceName = "sswitch_" + instruction.getMinAddress();
        Namespace nameSpace = DexUtil.getOrCreateNameSpace(program, namespaceName);
        for (int i = 0; i < payload.getSize(); ++i) {
            monitor.checkCanceled();
            String caseName = "case_0x" + Integer.toHexString(payload.getKeys()[i]);
            Address caseAddress = instruction.getMinAddress().add((long)(payload.getTargets()[i] * 2));
            program.getSymbolTable().createLabel(caseAddress, caseName, nameSpace, SourceType.ANALYSIS);
            program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), caseAddress, (RefType)RefType.COMPUTED_JUMP, SourceType.ANALYSIS, -1);
            DisassembleCommand dCommand = new DisassembleCommand(caseAddress, null, true);
            dCommand.applyTo((DomainObject)program);
        }
    }
}

