/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Undefined2DataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class Motorola68KAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String SWITCH_OPTION_NAME = "Switch Table Recovery";
    private static final String SWITCH_OPTION_DESCRIPTION = "Turn on to recover switch tables";
    private static final boolean SWITCH_OPTION_DEFAULT_VALUE = false;
    private boolean recoverSwitchTables = false;
    private static final String PROCESSOR_NAME = "68000";
    int tableSizeMax;

    public Motorola68KAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        return canAnalyze;
    }

    public AddressSetView flowConstants(final Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                Varnode value;
                String mnemonic = instr.getMnemonicString();
                if (mnemonic.equals("pea")) {
                    try {
                        Varnode stackValue = context.getValue(context.getStackVarnode(), (ContextEvaluator)this);
                        value = context.getValue(stackValue, (ContextEvaluator)this);
                        if (value != null && value.isConstant()) {
                            long lval = value.getOffset();
                            Address refAddr = instr.getMinAddress().getNewAddress(lval);
                            if (lval <= 4096L || lval % 1024L == 0L || lval < 0L || lval == 65535L || lval == 65280L || lval == 0xFFFFFFL || lval == 0xFF0000L || lval == 0xFF00FFL || lval == -1L || lval == -256L || lval == -65536L || lval == -16777216L) {
                                return false;
                            }
                            if (program.getMemory().contains(refAddr) && instr.getOperandReferences(0).length == 0) {
                                instr.addOperandReference(0, refAddr, RefType.DATA, SourceType.ANALYSIS);
                            }
                        }
                    }
                    catch (NotFoundException stackValue) {
                        // empty catch block
                    }
                }
                if (mnemonic.equals("lea")) {
                    Register destReg = instr.getRegister(1);
                    if (destReg == null) {
                        return false;
                    }
                    value = context.getRegisterValue(destReg);
                    if (value != null) {
                        BigInteger rval = value.getUnsignedValue();
                        long lval = rval.longValue();
                        Address refAddr = instr.getMinAddress().getNewAddress(lval);
                        if (((lval > 4096L || lval < 0L) && program.getMemory().contains(refAddr) || Arrays.asList(instr.getOpObjects(0)).contains(program.getRegister("PC"))) && instr.getOperandReferences(0).length == 0) {
                            instr.addOperandReference(0, refAddr, RefType.DATA, SourceType.ANALYSIS);
                        }
                    }
                }
                return false;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                if (instr.getFlowType().isJump()) {
                    return false;
                }
                if (instr.getNumOperands() > 2) {
                    return false;
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, refType);
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                int numRefs;
                String mnemonic = instruction.getMnemonicString();
                if (!instruction.getFlowType().isJump()) {
                    return false;
                }
                if (mnemonic.equals("jmp") && (numRefs = instruction.getReferencesFrom().length) >= 4) {
                    this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
                }
                return false;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        if (this.recoverSwitchTables) {
            this.recoverSwitches(program, symEval, eval.getDestinationSet(), monitor);
        }
        return resultSet;
    }

    private void recoverSwitches(final Program program, SymbolicPropogator symEval, AddressSet destSet, TaskMonitor monitor) throws CancelledException {
        final ArrayList<CreateDataCmd> dataCmdList = new ArrayList<CreateDataCmd>();
        final ArrayList targetList = new ArrayList();
        class SwitchEvaluator
        implements ContextEvaluator {
            Long assumeValue;
            boolean hitTheGuard;
            Address targetSwitchAddr;

            SwitchEvaluator() {
            }

            public void setGuard(boolean hitGuard) {
                this.hitTheGuard = hitGuard;
            }

            public void setAssume(Long assume) {
                this.assumeValue = assume;
            }

            public void setTargetSwitchAddr(Address addr) {
                this.targetSwitchAddr = addr;
            }

            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                return false;
            }

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                Scalar scalar;
                Register reg;
                int numOps;
                String mnemonic = instr.getMnemonicString();
                if (mnemonic.startsWith("cmpi") && (numOps = instr.getNumOperands()) > 1 && (reg = instr.getRegister(numOps - 1)) != null && (scalar = instr.getScalar(numOps - 2)) != null) {
                    RegisterValue rval;
                    int svalue = (int)scalar.getSignedValue() + 1;
                    if (svalue > 0 && svalue < 128) {
                        Motorola68KAnalyzer.this.tableSizeMax = svalue;
                    }
                    if ((rval = context.getRegisterValue(reg)) != null) {
                        long l = rval.getSignedValue().longValue();
                    }
                }
                if (instr.getFlowType().isConditional()) {
                    this.hitTheGuard = true;
                }
                return false;
            }

            public Address evaluateConstant(VarnodeContext context, Instruction instr, int pcodeop, Address constant, int size, RefType refType) {
                return null;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                if (targetList.contains(address)) {
                    return false;
                }
                if (!instr.getFlowType().isComputed() || !program.getMemory().contains(address)) {
                    Program program2 = instr.getProgram();
                    if (!program2.getListing().isUndefined(address, address)) {
                        return false;
                    }
                    String mnemonic = instr.getMnemonicString();
                    if (mnemonic.startsWith("move")) {
                        CreateDataCmd cdata = null;
                        char endCh = mnemonic.charAt(mnemonic.length() - 1);
                        switch (endCh) {
                            case 'w': {
                                cdata = new CreateDataCmd(address, false, false, (DataType)Undefined2DataType.dataType);
                                break;
                            }
                            case 'l': {
                                cdata = new CreateDataCmd(address, false, false, (DataType)Undefined4DataType.dataType);
                                break;
                            }
                            case 'b': {
                                cdata = new CreateDataCmd(address, false, false, (DataType)Undefined1DataType.dataType);
                            }
                        }
                        Instruction u = instr.getProgram().getListing().getInstructionContaining(address);
                        if (u != null) {
                            return false;
                        }
                        u = instr.getProgram().getListing().getCodeUnitAt(address);
                        if (!targetList.isEmpty() && instr.getProgram().getReferenceManager().hasReferencesTo(u.getMinAddress())) {
                            int newTableSizeMax = this.assumeValue.intValue();
                            if (newTableSizeMax > 0 && newTableSizeMax < 128) {
                                Motorola68KAnalyzer.this.tableSizeMax = newTableSizeMax;
                            }
                            return false;
                        }
                        dataCmdList.add(cdata);
                    }
                    return false;
                }
                long diff = address.subtract(instr.getMinAddress());
                if (diff > 0L && diff < 8192L && !context.readExecutableCode()) {
                    targetList.add(address);
                    return false;
                }
                if (context.readExecutableCode() && targetList.isEmpty()) {
                    context.clearReadExecutableCode();
                    return false;
                }
                return false;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                return instruction.getMinAddress().equals((Object)this.targetSwitchAddr);
            }

            public boolean evaluateReturn(Varnode retVN, VarnodeContext context, Instruction instruction) {
                return false;
            }

            public Long unknownValue(VarnodeContext context, Instruction instruction, Varnode node) {
                Register reg;
                if (!node.isRegister() || (reg = program.getRegister(node.getAddress())) != null) {
                    // empty if block
                }
                return this.assumeValue;
            }

            public boolean followFalseConditionalBranches() {
                return false;
            }

            public boolean evaluateSymbolicReference(VarnodeContext context, Instruction instr, Address address) {
                return false;
            }

            public boolean allowAccess(VarnodeContext context, Address addr) {
                return false;
            }
        }
        SwitchEvaluator switchEvaluator = new SwitchEvaluator();
        symEval = new SymbolicPropogator(program);
        AddressIterator iter = destSet.getAddresses(true);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Address loc = iter.next();
            Instruction instr = program.getListing().getInstructionAt(loc);
            Address maxAddress = instr.getMaxAddress();
            Address prev = instr.getFallFrom();
            if (prev == null) continue;
            instr = program.getListing().getInstructionAt(prev);
            Address minAddress = instr.getMinAddress();
            prev = instr.getFallFrom();
            if (prev == null) continue;
            instr = program.getListing().getInstructionAt(prev);
            if (instr.getMnemonicString().startsWith("add") && instr.getRegister(0).equals((Object)instr.getRegister(1))) {
                minAddress = instr.getMinAddress();
            }
            AddressSet branchSet = new AddressSet(minAddress, maxAddress);
            this.tableSizeMax = 64;
            for (long assume = 0L; assume < (long)this.tableSizeMax; ++assume) {
                switchEvaluator.setAssume(new Long(assume));
                switchEvaluator.setGuard(false);
                switchEvaluator.setTargetSwitchAddr(loc);
                symEval.flowConstants(minAddress, (AddressSetView)branchSet, (ContextEvaluator)switchEvaluator, false, monitor);
                if (symEval.readExecutable() || assume > 0L && targetList.size() < 1) break;
            }
            if (targetList.size() <= 1) continue;
            this.createData(program, dataCmdList);
        }
    }

    private void createData(Program program, ArrayList<CreateDataCmd> dataCommands) {
        for (CreateDataCmd createDataCmd : dataCommands) {
            createDataCmd.applyTo((DomainObject)program);
        }
    }

    private void labelTable(Program program, Address loc, ArrayList<Address> targets) {
        Namespace space = null;
        Instruction start_inst = program.getListing().getInstructionAt(loc);
        String spaceName = "switch_" + start_inst.getMinAddress();
        try {
            space = program.getSymbolTable().createNameSpace(space, spaceName, SourceType.ANALYSIS);
        }
        catch (DuplicateNameException e) {
            space = program.getSymbolTable().getNamespace(spaceName, program.getGlobalNamespace());
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        int tableNumber = 0;
        for (Address addr : targets) {
            AddLabelCmd lcmd = new AddLabelCmd(addr, "case_" + Long.toHexString(tableNumber), space, SourceType.ANALYSIS);
            ++tableNumber;
            lcmd.setNamespace(space);
            lcmd.applyTo((DomainObject)program);
        }
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        options.registerOption(SWITCH_OPTION_NAME, (Object)this.recoverSwitchTables, null, SWITCH_OPTION_DESCRIPTION);
        this.recoverSwitchTables = options.getBoolean(SWITCH_OPTION_NAME, this.recoverSwitchTables);
    }
}

