/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFileReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public interface Msf
extends AutoCloseable {
    public String getFilename();

    public TaskMonitor getMonitor();

    public void checkCanceled() throws CancelledException;

    public int getPageSize();

    public int getNumStreams();

    public MsfFileReader getFileReader();

    @Override
    public void close() throws IOException;

    public MsfStream getStream(int var1);

    public static int floorDivisionWithLog2Divisor(int dividend, int log2Divisor) {
        return dividend + (1 << log2Divisor) - 1 >> log2Divisor;
    }

    public byte[] getIdentification();

    public int getPageSizeOffset();

    public void parseFreePageMapPageNumber(PdbByteReader var1) throws PdbException;

    public void parseCurrentNumPages(PdbByteReader var1) throws PdbException;

    public void create();

    public void configureParameters() throws PdbException;

    public int getPageNumberSize();

    public int getLog2PageSize();

    public int getPageSizeModMask();

    public int getNumSequentialFreePageMapPages();

    public int getHeaderPageNumber();

    public int getDirectoryStreamNumber();

    public int getNumPages();

    public int getCurrentFreePageMapFirstPageNumber();

    public void deserialize() throws IOException, PdbException, CancelledException;
}

