/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetStack;
import agent.dbgeng.model.iface2.DbgModelTargetStackFrame;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetStackFrameImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="Stack", elements={@TargetElementType(type=DbgModelTargetStackFrameImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetStackImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetStack {
    protected final DbgModelTargetThread thread;
    public static final String NAME = "Stack";
    protected final Map<Integer, DbgModelTargetStackFrameImpl> framesByLevel = new WeakValueHashMap();

    public DbgModelTargetStackImpl(DbgModelTargetThread thread, DbgModelTargetProcess process) {
        super(thread.getModel(), (TargetObject)thread, NAME, NAME);
        this.thread = thread;
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.thread.getThread().listStackFrames().thenAccept(f -> {
            List frames;
            DbgModelTargetStackImpl dbgModelTargetStackImpl = this;
            synchronized (dbgModelTargetStackImpl) {
                frames = f.stream().map(this::getTargetFrame).collect(Collectors.toList());
            }
            this.setElements(frames, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized DbgModelTargetStackFrame getTargetFrame(DbgStackFrame frame) {
        return this.framesByLevel.compute(frame.getLevel(), (l, f) -> {
            if (f == null) {
                return new DbgModelTargetStackFrameImpl(this, this.thread, frame);
            }
            f.setFrame(frame);
            return f;
        });
    }

    public void threadStateChangedSpecific(DbgState state, DbgReason reason) {
        if (!state.equals((Object)DbgState.RUNNING)) {
            this.requestElements(true).exceptionally(e -> {
                Msg.error((Object)this, (Object)("Could not update stack " + this + " on STOPPED"));
                return null;
            });
        }
    }
}

