/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgModuleMemory;
import agent.dbgeng.manager.cmd.DbgListKernelMemoryRegionsCommand;
import agent.dbgeng.manager.cmd.DbgListMemoryRegionsCommand;
import agent.dbgeng.manager.cmd.DbgListMemoryRegionsCommandAlt;
import agent.dbgeng.manager.cmd.DbgReadBusDataCommand;
import agent.dbgeng.manager.cmd.DbgReadControlCommand;
import agent.dbgeng.manager.cmd.DbgReadDebuggerDataCommand;
import agent.dbgeng.manager.cmd.DbgReadIoCommand;
import agent.dbgeng.manager.cmd.DbgReadMemoryCommand;
import agent.dbgeng.manager.cmd.DbgReadPhysicalMemoryCommand;
import agent.dbgeng.manager.cmd.DbgWriteBusDataCommand;
import agent.dbgeng.manager.cmd.DbgWriteControlCommand;
import agent.dbgeng.manager.cmd.DbgWriteIoCommand;
import agent.dbgeng.manager.cmd.DbgWriteMemoryCommand;
import agent.dbgeng.manager.cmd.DbgWritePhysicalMemoryCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryRegion;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.impl.DbgModelTargetMemoryRegionImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.util.datastruct.WeakValueHashMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="Memory", elements={@TargetElementType(type=DbgModelTargetMemoryRegionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetMemoryContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetMemoryContainer {
    protected final DbgModelTargetProcess process;
    protected final Map<String, DbgModelTargetMemoryRegionImpl> memoryRegions = new WeakValueHashMap();

    public DbgModelTargetMemoryContainerImpl(DbgModelTargetProcess process) {
        super(process.getModel(), (TargetObject)process, "Memory", "MemoryContainer");
        this.process = process;
        if (!this.getModel().isSuppressDescent()) {
            this.requestElements(true);
        }
    }

    @Override
    public CompletableFuture<Void> requestElements(boolean refresh) {
        DbgModelTargetProcess targetProcess = this.getParentProcess();
        DbgProcessImpl currentProcess = this.getManager().getCurrentProcess();
        if (!refresh || currentProcess != null && !currentProcess.equals(targetProcess.getProcess())) {
            return AsyncUtils.NIL;
        }
        return this.listMemory().thenAccept(byName -> {
            List sections;
            DbgModelTargetMemoryContainerImpl dbgModelTargetMemoryContainerImpl = this;
            synchronized (dbgModelTargetMemoryContainerImpl) {
                sections = byName.stream().map(this::getTargetMemory).collect(Collectors.toList());
            }
            this.setElements(sections, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized DbgModelTargetMemoryRegion getTargetMemory(DbgModuleMemory section) {
        DbgModelTargetMemoryRegionImpl region = this.memoryRegions.get(section.getName());
        if (region != null && region.isSame(section)) {
            return region;
        }
        region = new DbgModelTargetMemoryRegionImpl(this, section);
        this.memoryRegions.put(section.getName(), region);
        return region;
    }

    public CompletableFuture<List<DbgModuleMemory>> listMemory() {
        DbgManagerImpl manager = this.getManager();
        if (manager.isKernelMode()) {
            return manager.execute(new DbgListKernelMemoryRegionsCommand(manager));
        }
        if (manager.useAltMemoryQuery()) {
            return manager.execute(new DbgListMemoryRegionsCommandAlt(manager));
        }
        return manager.execute(new DbgListMemoryRegionsCommand(manager));
    }

    public CompletableFuture<byte[]> readVirtualMemory(Address address, int length) {
        DbgManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command readMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.allocate(length);
        long offset = address.getOffset();
        return this.process.getProcess().readMemory(offset, buf).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
    }

    private byte[] readAssist(Address address, ByteBuffer buf, long offset, RangeSet<Long> set) {
        if (set == null) {
            return new byte[0];
        }
        Range range = set.rangeContaining((Comparable)Long.valueOf(offset));
        if (range == null) {
            throw new DebuggerMemoryAccessException("Cannot read at " + address);
        }
        ((DebuggerModelListener)this.listeners.fire).memoryUpdated((TargetObject)this.getProxy(), address, buf.array());
        return Arrays.copyOf(buf.array(), (int)((Long)range.upperEndpoint() - (Long)range.lowerEndpoint()));
    }

    public CompletableFuture<Void> writeVirtualMemory(Address address, byte[] data) {
        DbgManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command writeMemory while engine is waiting for events");
        }
        long offset = address.getOffset();
        return this.process.getProcess().writeMemory(offset, ByteBuffer.wrap(data)).thenAccept(___ -> this.writeAssist(address, data));
    }

    private void writeAssist(Address address, byte[] data) {
        ((DebuggerModelListener)this.listeners.fire).memoryUpdated((TargetObject)this.getProxy(), address, data);
    }

    @Override
    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        return this.model.gateFuture(this.doReadMemory(address, length));
    }

    protected CompletableFuture<byte[]> doReadMemory(Address address, int length) {
        DbgManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command readMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.allocate(length);
        long offset = address.getOffset();
        if (!manager.isKernelMode() || address.getAddressSpace().getName().equals("ram")) {
            return manager.execute(new DbgReadMemoryCommand(manager, offset, buf, buf.remaining())).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        if (address.getAddressSpace().getName().equals("phys")) {
            return manager.execute(new DbgReadPhysicalMemoryCommand(manager, offset, buf, buf.remaining())).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        if (address.getAddressSpace().getName().equals("ctrl")) {
            int processor = 0;
            return manager.execute(new DbgReadControlCommand(manager, offset, buf, buf.remaining(), processor)).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        if (address.getAddressSpace().getName().equals("bus")) {
            int busDataType = 0;
            int busNumber = 0;
            int slotNumber = 0;
            return manager.execute(new DbgReadBusDataCommand(manager, offset, buf, buf.remaining(), busDataType, busNumber, slotNumber)).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        if (address.getAddressSpace().getName().equals("io")) {
            int interfaceType = 0;
            int busNumber = 0;
            int addresSpace = 0;
            return manager.execute(new DbgReadIoCommand(manager, offset, buf, buf.remaining(), interfaceType, busNumber, addresSpace)).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        if (address.getAddressSpace().getName().equals("debug")) {
            return manager.execute(new DbgReadDebuggerDataCommand(manager, offset, buf, buf.remaining())).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        return CompletableFuture.completedFuture(new byte[length]);
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        return this.model.gateFuture(this.doWriteMemory(address, data));
    }

    protected CompletableFuture<Void> doWriteMemory(Address address, byte[] data) {
        DbgManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command writeMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        long offset = address.getOffset();
        if (!manager.isKernelMode() || address.getAddressSpace().getName().equals("ram")) {
            return manager.execute(new DbgWriteMemoryCommand(manager, offset, buf, buf.remaining())).thenAccept(___ -> this.writeAssist(address, data));
        }
        if (address.getAddressSpace().getName().equals("phys")) {
            return manager.execute(new DbgWritePhysicalMemoryCommand(manager, offset, buf, buf.remaining())).thenAccept(___ -> this.writeAssist(address, data));
        }
        if (address.getAddressSpace().getName().equals("ctrl")) {
            int processor = 0;
            return manager.execute(new DbgWriteControlCommand(manager, offset, buf, buf.remaining(), processor)).thenAccept(___ -> this.writeAssist(address, data));
        }
        if (address.getAddressSpace().getName().equals("bus")) {
            int busDataType = 0;
            int busNumber = 0;
            int slotNumber = 0;
            return manager.execute(new DbgWriteBusDataCommand(manager, offset, buf, buf.remaining(), busDataType, busNumber, slotNumber)).thenAccept(___ -> this.writeAssist(address, data));
        }
        if (address.getAddressSpace().getName().equals("io")) {
            int interfaceType = 0;
            int busNumber = 0;
            int addresSpace = 0;
            return manager.execute(new DbgWriteIoCommand(manager, offset, buf, buf.remaining(), interfaceType, busNumber, addresSpace)).thenAccept(___ -> this.writeAssist(address, data));
        }
        return CompletableFuture.completedFuture(null);
    }
}

