/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import java.util.ArrayList;

public class DbgDetachCommand
extends AbstractDbgCommand<Void> {
    private final DbgProcessImpl process;

    public DbgDetachCommand(DbgManagerImpl manager, DbgProcessImpl process) {
        super(manager);
        this.process = process;
    }

    @Override
    public Void complete(DbgPendingCommand<?> pending) {
        ArrayList<DbgThreadImpl> threads = new ArrayList<DbgThreadImpl>(this.process.getKnownThreadsImpl().values());
        for (DbgThreadImpl t : threads) {
            this.manager.fireThreadExited(t.getId(), this.process, pending);
            t.remove();
        }
        ((DbgEventsListener)this.manager.getEventListeners().fire).processRemoved(this.process.getId(), DbgCause.Causes.UNCLAIMED);
        return null;
    }

    @Override
    public void invoke() {
        DebugClient dbgeng = this.manager.getClient();
        dbgeng.detachCurrentProcess();
    }
}

