/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatree.CheckoutsPanel;
import ghidra.framework.main.projectdata.actions.CheckoutsActionContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.remote.User;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;

public class CheckoutsDialog
extends DialogComponentProvider
implements ProjectListener {
    private CheckoutsPanel panel;

    public CheckoutsDialog(PluginTool tool, User user, DomainFile domainFile, ItemCheckoutStatus[] checkouts) {
        super("View Checkouts for " + domainFile.getName(), false);
        this.setHelpLocation(new HelpLocation("Repository", "View_Check_Outs"));
        this.panel = new CheckoutsPanel(this.rootPanel, tool, user, domainFile, checkouts);
        this.addWorkPanel(this.panel);
        this.addDismissButton();
        AppInfo.getFrontEndTool().addProjectListener(this);
        this.createActions();
    }

    protected void dismissCallback() {
        AppInfo.getFrontEndTool().removeProjectListener(this);
        this.close();
        this.panel.dispose();
    }

    @Override
    public void projectClosed(Project project) {
        this.dismissCallback();
    }

    @Override
    public void projectOpened(Project project) {
    }

    private void createActions() {
        this.panel.createActions(this);
    }

    public ActionContext getActionContext(MouseEvent event) {
        int[] selectedRows = this.panel.getSelectedRows();
        return new CheckoutsActionContext(selectedRows);
    }
}

