/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import com.google.common.collect.Range;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public interface TraceTimeViewport {
    public void setSnap(long var1);

    public void addChangeListener(Runnable var1);

    public void removeChangeListener(Runnable var1);

    public boolean isForked();

    public boolean containsAnyUpper(Range<Long> var1);

    public <T> boolean isCompletelyVisible(AddressRange var1, Range<Long> var2, T var3, Occlusion<T> var4);

    public <T> AddressSet computeVisibleParts(AddressSetView var1, Range<Long> var2, T var3, Occlusion<T> var4);

    public List<Range<Long>> getOrderedSpans();

    public List<Long> getOrderedSnaps();

    public List<Long> getReversedSnaps();

    public <T> T getTop(Function<Long, T> var1);

    public <T> Iterator<T> mergedIterator(Function<Long, Iterator<T>> var1, Comparator<? super T> var2);

    public AddressSetView unionedAddresses(Function<Long, AddressSetView> var1);

    public static interface SetQueryOcclusion<T>
    extends QueryOcclusion<T> {
        @Override
        default public boolean itemOccludes(AddressRange range, T t) {
            return this.set(t).intersects(range.getMinAddress(), range.getMaxAddress());
        }

        @Override
        default public void removeItem(AddressSet remains, T t) {
            for (AddressRange range : this.set(t)) {
                remains.delete(range);
                if (!remains.isEmpty()) continue;
                return;
            }
        }

        public AddressSetView set(T var1);
    }

    public static interface RangeQueryOcclusion<T>
    extends QueryOcclusion<T> {
        @Override
        default public boolean itemOccludes(AddressRange range, T t) {
            return this.range(t).intersects(range);
        }

        @Override
        default public void removeItem(AddressSet remains, T t) {
            remains.delete(this.range(t));
        }

        public AddressRange range(T var1);
    }

    public static interface QueryOcclusion<T>
    extends Occlusion<T> {
        @Override
        default public boolean occluded(T object, AddressRange range, Range<Long> span) {
            for (T found : this.query(range, span)) {
                if (found == object || !this.itemOccludes(range, found)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public void remove(T object, AddressSet remains, Range<Long> span) {
            for (T found : this.query((AddressRange)new AddressRangeImpl(remains.getMinAddress(), remains.getMaxAddress()), span)) {
                if (found == object) continue;
                this.removeItem(remains, found);
                if (!remains.isEmpty()) continue;
                return;
            }
        }

        public Iterable<? extends T> query(AddressRange var1, Range<Long> var2);

        public boolean itemOccludes(AddressRange var1, T var2);

        public void removeItem(AddressSet var1, T var2);
    }

    public static interface Occlusion<T> {
        public boolean occluded(T var1, AddressRange var2, Range<Long> var3);

        public void remove(T var1, AddressSet var2, Range<Long> var3);
    }
}

