/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import com.google.common.collect.Range;
import db.BinaryField;
import db.DBRecord;
import db.LongField;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceObjectValue
extends DBAnnotatedObject
implements InternalTraceObjectValue {
    protected static final String TABLE_NAME = "ObjectValue";
    static final String TRIPLE_COLUMN_NAME = "Triple";
    static final String MAX_SNAP_COLUMN_NAME = "MaxSnap";
    static final String CHILD_COLUMN_NAME = "Child";
    static final String PRIMITIVE_COLUMN_NAME = "Primitive";
    @DBAnnotatedColumn(value="Triple")
    static DBObjectColumn TRIPLE_COLUMN;
    @DBAnnotatedColumn(value="MaxSnap")
    static DBObjectColumn MAX_SNAP_COLUMN;
    @DBAnnotatedColumn(value="Child")
    static DBObjectColumn CHILD_COLUMN;
    @DBAnnotatedColumn(value="Primitive")
    static DBObjectColumn PRIMITIVE_COLUMN;
    @DBAnnotatedField(column="Triple", indexed=true, codec=PrimaryTripleDBFieldCodec.class)
    private PrimaryTriple triple;
    @DBAnnotatedField(column="MaxSnap")
    private long maxSnap;
    @DBAnnotatedField(column="Child", indexed=true, codec=DBTraceObjectDBFieldCodec.class)
    private DBTraceObject child;
    @DBAnnotatedField(column="Primitive", codec=DBCachedObjectStoreFactory.VariantDBFieldCodec.class)
    private Object primitive;
    protected final DBTraceObjectManager manager;
    private Range<Long> lifespan;

    public DBTraceObjectValue(DBTraceObjectManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            return;
        }
        this.lifespan = DBTraceUtils.toRange(this.triple.minSnap, this.maxSnap);
    }

    protected void set(Range<Long> lifespan, DBTraceObject parent, String key, Object value) {
        this.triple = new PrimaryTriple(parent, key, DBTraceUtils.lowerEndpoint(lifespan));
        this.maxSnap = DBTraceUtils.upperEndpoint(lifespan);
        this.lifespan = DBTraceUtils.toRange(this.triple.minSnap, this.maxSnap);
        if (value instanceof TraceObject) {
            DBTraceObject child;
            this.child = child = this.manager.assertIsMine((TraceObject)value);
            this.primitive = null;
        } else {
            this.primitive = this.manager.validatePrimitive(value);
            this.child = null;
        }
        this.update(new DBObjectColumn[]{TRIPLE_COLUMN, MAX_SNAP_COLUMN, CHILD_COLUMN, PRIMITIVE_COLUMN});
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": parent=" + this.triple.parent + ", key=" + this.triple.key + ", lifespan=" + this.getLifespan() + ", value=" + this.getValue();
    }

    @Override
    public void doSetLifespan(Range<Long> lifespan) {
        long minSnap = DBTraceUtils.lowerEndpoint(lifespan);
        if (this.triple.minSnap != minSnap) {
            this.triple = this.triple.withMinSnap(minSnap);
            this.update(TRIPLE_COLUMN);
        }
        this.maxSnap = DBTraceUtils.upperEndpoint(lifespan);
        this.update(MAX_SNAP_COLUMN);
        this.lifespan = DBTraceUtils.toRange(minSnap, this.maxSnap);
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getParent() {
        return this.triple == null ? null : this.triple.parent;
    }

    @Override
    public String getEntryKey() {
        return this.triple == null ? null : this.triple.key;
    }

    @Override
    public Object getValue() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Object object = this.child != null ? this.child : this.primitive;
            return object;
        }
    }

    @Override
    public DBTraceObject getChild() {
        return (DBTraceObject)this.getValue();
    }

    @Override
    public boolean isObject() {
        return this.child != null;
    }

    @Override
    public DBTraceObject getChildOrNull() {
        return this.child;
    }

    @Override
    public Range<Long> getLifespan() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Range<Long> range = this.lifespan;
            return range;
        }
    }

    @Override
    public void setMinSnap(long minSnap) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.setLifespan(DBTraceUtils.toRange(minSnap, this.maxSnap));
        }
    }

    @Override
    public long getMinSnap() {
        try (LockHold hold = this.manager.trace.lockRead();){
            long l = this.triple.minSnap;
            return l;
        }
    }

    @Override
    public void setMaxSnap(long maxSnap) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.setLifespan(DBTraceUtils.toRange(this.triple.minSnap, maxSnap));
        }
    }

    @Override
    public long getMaxSnap() {
        try (LockHold hold = this.manager.trace.lockRead();){
            long l = this.maxSnap;
            return l;
        }
    }

    protected Stream<? extends TraceObjectValPath> doStreamVisitor(Range<Long> span, TreeTraversal.Visitor visitor) {
        return TreeTraversal.INSTANCE.walkValue(visitor, this, span, null);
    }

    protected TraceObjectKeyPath doGetCanonicalPath() {
        if (this.triple == null || this.triple.parent == null) {
            return TraceObjectKeyPath.of(new String[0]);
        }
        return this.triple.parent.getCanonicalPath().extend(this.triple.key);
    }

    protected boolean doIsCanonical() {
        if (this.child == null) {
            return false;
        }
        if (this.triple.parent == null) {
            return true;
        }
        return this.doGetCanonicalPath().equals(this.child.getCanonicalPath());
    }

    @Override
    public TraceObjectKeyPath getCanonicalPath() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            TraceObjectKeyPath traceObjectKeyPath = this.doGetCanonicalPath();
            return traceObjectKeyPath;
        }
    }

    @Override
    public boolean isCanonical() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.doIsCanonical();
            return bl;
        }
    }

    @Override
    public void doDelete() {
        this.manager.doDeleteEdge(this);
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.triple.parent == null) {
                throw new IllegalArgumentException("Cannot delete root value");
            }
            this.doDeleteAndEmit();
        }
    }

    @Override
    public InternalTraceObjectValue truncateOrDelete(Range<Long> span) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.triple.parent == null) {
                throw new IllegalArgumentException("Cannot truncate or delete root value");
            }
            InternalTraceObjectValue internalTraceObjectValue = this.doTruncateOrDeleteAndEmitLifeChange(span);
            return internalTraceObjectValue;
        }
    }

    protected static class PrimaryTriple {
        private final DBTraceObject parent;
        private final String key;
        private final long minSnap;

        protected PrimaryTriple(DBTraceObject parent, String key, long minSnap) {
            this.parent = parent;
            this.key = Objects.requireNonNull(key);
            this.minSnap = minSnap;
        }

        public String toString() {
            return "<parent=" + this.parent + ",key=" + this.key + ",minSnap=" + this.minSnap + ">";
        }

        public PrimaryTriple withMinSnap(long minSnap) {
            return new PrimaryTriple(this.parent, this.key, minSnap);
        }
    }

    public static class DBTraceObjectDBFieldCodec<OV extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<DBTraceObject, OV, LongField> {
        public DBTraceObjectDBFieldCodec(Class<OV> objectType, Field field, int column) {
            super(DBTraceObject.class, objectType, LongField.class, field, column);
        }

        protected static long encode(DBTraceObject value) {
            return value == null ? -1L : value.getKey();
        }

        protected static DBTraceObject decode(InternalTraceObjectValue ent, long enc) {
            return enc == -1L ? null : ent.getManager().getObjectById(enc);
        }

        public void store(DBTraceObject value, LongField f) {
            f.setLongValue(DBTraceObjectDBFieldCodec.encode(value));
        }

        protected void doStore(OV obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setLongValue(this.column, DBTraceObjectDBFieldCodec.encode((DBTraceObject)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OV obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue((DBAnnotatedObject)obj, DBTraceObjectDBFieldCodec.decode((InternalTraceObjectValue)obj, record.getLongValue(this.column)));
        }
    }

    public static class PrimaryTripleDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<PrimaryTriple, DBTraceObjectValue, BinaryField> {
        static final Charset cs = Charset.forName("UTF-8");

        public PrimaryTripleDBFieldCodec(Class<DBTraceObjectValue> objectType, Field field, int column) {
            super(PrimaryTriple.class, objectType, BinaryField.class, field, column);
        }

        protected static byte[] encode(PrimaryTriple value) {
            if (value == null) {
                return null;
            }
            byte[] keyBytes = value.key.getBytes(cs);
            ByteBuffer buf = ByteBuffer.allocate(keyBytes.length + 1 + 16);
            buf.putLong(DBTraceObjectDBFieldCodec.encode(value.parent) ^ Long.MIN_VALUE);
            buf.put(keyBytes);
            buf.put((byte)0);
            buf.putLong(value.minSnap ^ Long.MIN_VALUE);
            return buf.array();
        }

        protected static PrimaryTriple decode(DBTraceObjectValue ent, byte[] enc) {
            if (enc == null) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(enc);
            DBTraceObject parent = DBTraceObjectDBFieldCodec.decode(ent, buf.getLong() ^ Long.MIN_VALUE);
            int nullPos = ArrayUtils.indexOf((byte[])enc, (byte)0, (int)buf.position());
            assert (nullPos != -1);
            String key = new String(enc, buf.position(), nullPos - buf.position(), cs);
            buf.position(nullPos + 1);
            long minSnap = buf.getLong() ^ Long.MIN_VALUE;
            return new PrimaryTriple(parent, key, minSnap);
        }

        public void store(PrimaryTriple value, BinaryField f) {
            f.setBinaryData(PrimaryTripleDBFieldCodec.encode(value));
        }

        protected void doStore(DBTraceObjectValue obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, PrimaryTripleDBFieldCodec.encode((PrimaryTriple)this.getValue(obj)));
        }

        protected void doLoad(DBTraceObjectValue obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, PrimaryTripleDBFieldCodec.decode(obj, record.getBinaryData(this.column)));
        }
    }
}

