/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.bookmark;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.bookmark.DBTraceBookmark;
import ghidra.trace.database.bookmark.DBTraceBookmarkManager;
import ghidra.trace.database.bookmark.DBTraceBookmarkType;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmarkSpace;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceBookmarkSpace
implements TraceBookmarkSpace,
DBTraceSpaceBased {
    protected final DBTraceBookmarkManager manager;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final AddressSpace space;
    protected final TraceThread thread;
    protected final int frameLevel;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceBookmark, DBTraceBookmark> bookmarkMapSpace;
    protected final DBCachedObjectIndex<String, DBTraceBookmark> bookmarksByTypeName;
    protected final Collection<DBTraceBookmark> bookmarkView;

    public DBTraceBookmarkSpace(DBTraceBookmarkManager manager, AddressSpace space, TraceThread thread, int frameLevel) throws VersionException, IOException {
        this.manager = manager;
        this.lock = manager.getLock();
        this.trace = manager.getTrace();
        this.space = space;
        this.thread = thread;
        this.frameLevel = frameLevel;
        this.bookmarkMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceBookmark.tableName(space, -1L, 0), this.trace.getStoreFactory(), this.lock, space, null, 0, DBTraceBookmark.class, (t, s, r) -> new DBTraceBookmark(this, t, s, r));
        this.bookmarksByTypeName = this.bookmarkMapSpace.getUserIndex(String.class, DBTraceBookmark.TYPE_COLUMN);
        this.bookmarkView = Collections.unmodifiableCollection(this.bookmarkMapSpace.values());
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    protected DBTraceBookmarkType assertInTrace(TraceBookmarkType type) {
        if (!(type instanceof DBTraceBookmarkType)) {
            throw new IllegalArgumentException("Given type is not part of this trace");
        }
        DBTraceBookmarkType dbType = (DBTraceBookmarkType)type;
        if (dbType.manager != this.manager) {
            throw new IllegalArgumentException("Given type is not part of this trace");
        }
        return dbType;
    }

    @Override
    public Set<String> getCategoriesForType(TraceBookmarkType type) {
        this.assertInTrace(type);
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            HashSet<String> result = new HashSet<String>();
            for (DBTraceBookmark bookmark : this.bookmarksByTypeName.get((Object)type.getTypeString())) {
                result.add(bookmark.getCategory());
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    @Override
    public DBTraceBookmark addBookmark(Range<Long> lifespan, Address address, TraceBookmarkType type, String category, String comment) {
        this.assertInTrace(type);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceBookmark bookmark = (DBTraceBookmark)this.bookmarkMapSpace.put(address, lifespan, null);
            bookmark.set(type.getTypeString(), category, comment);
            this.trace.setChanged(new TraceChangeRecord<DBTraceBookmark, Void>(Trace.TraceBookmarkChangeType.ADDED, this, bookmark));
            DBTraceBookmark dBTraceBookmark = bookmark;
            return dBTraceBookmark;
        }
    }

    public Collection<DBTraceBookmark> getAllBookmarks() {
        return this.bookmarkView;
    }

    public Iterable<DBTraceBookmark> getBookmarksAt(long snap, Address address) {
        return this.bookmarkMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values();
    }

    public Iterable<DBTraceBookmark> getBookmarksEnclosed(Range<Long> lifespan, AddressRange range) {
        return this.bookmarkMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.enclosed(range, lifespan)).values();
    }

    public Iterable<DBTraceBookmark> getBookmarksIntersecting(Range<Long> lifespan, AddressRange range) {
        return this.bookmarkMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, lifespan)).values();
    }

    public Collection<DBTraceBookmark> getBookmarksByType(String typeName) {
        return this.bookmarksByTypeName.getLazily((Object)typeName);
    }

    @Override
    public void invalidateCache() {
        this.bookmarkMapSpace.invalidateCache();
    }
}

