/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public abstract class DBTraceCacheForSequenceQueries<T> {
    protected final int maxRegions;
    protected final int addressBreadth;
    protected final List<CachedRegion> cache = new ArrayList<CachedRegion>();

    public DBTraceCacheForSequenceQueries(int maxRegions, int addressBreadth) {
        this.maxRegions = maxRegions;
        this.addressBreadth = addressBreadth;
    }

    protected abstract void loadCachedRegion(CachedRegion var1);

    protected abstract Map.Entry<TraceAddressSnapRange, T> doFloorEntry(long var1, Address var3);

    protected abstract Map.Entry<TraceAddressSnapRange, T> doCeilingEntry(long var1, Address var3);

    protected CachedRegion ensureInCache(long snap, Address address) {
        CachedRegion region;
        for (int i = 0; i < this.cache.size(); ++i) {
            CachedRegion region2 = this.cache.get(i);
            if (region2.snap != snap || !region2.contains(address)) continue;
            this.cache.remove(i);
            this.cache.add(0, region2);
            return region2;
        }
        if (this.cache.size() >= this.maxRegions) {
            region = this.cache.remove(0);
            region.reInit(snap, this.computeNewCachedRange(address));
        } else {
            region = new CachedRegion(snap, this.computeNewCachedRange(address));
        }
        this.loadCachedRegion(region);
        this.cache.add(region);
        return region;
    }

    protected AddressRange computeNewCachedRange(Address address) {
        return ImmutableTraceAddressSnapRange.rangeCentered(address, this.addressBreadth);
    }

    public T getFloor(long snap, Address address) {
        Object result = this.ensureInCache(snap, address).getFloor(address);
        return result;
    }

    public T getCeiling(long snap, Address address) {
        Object result = this.ensureInCache(snap, address).getCeiling(address);
        return result;
    }

    public void notifyNewEntry(Range<Long> lifespan, AddressRangeImpl range, T item) {
        this.invalidate();
    }

    public void notifyEntryRemoved(Range<Long> lifespan, AddressRange range, T item) {
        this.invalidate();
    }

    public void notifyEntryShapeChanged(Range<Long> lifespan, AddressRange range, T item) {
        this.invalidate();
    }

    public void invalidate() {
        this.cache.clear();
    }

    protected class CachedRegion {
        public long snap;
        private final NavigableMap<Address, T> nav = new TreeMap();
        public Address min;
        public Address max;

        public CachedRegion(long snap, AddressRange range) {
            this.snap = snap;
            this.min = range.getMinAddress();
            this.max = range.getMaxAddress();
        }

        public T getFloor(Address address) {
            Map.Entry floor = this.nav.floorEntry(address);
            if (floor != null) {
                return floor.getValue();
            }
            if (this.min == this.min.getAddressSpace().getMinAddress()) {
                return null;
            }
            Map.Entry ent = DBTraceCacheForSequenceQueries.this.doFloorEntry(this.snap, address);
            if (ent == null) {
                this.min = this.min.getAddressSpace().getMinAddress();
                return null;
            }
            Address x1 = ent.getKey().getX1();
            this.nav.put(x1, ent.getValue());
            this.min = x1;
            return ent.getValue();
        }

        public T getCeiling(Address address) {
            Map.Entry ceiling = this.nav.ceilingEntry(address);
            if (ceiling != null) {
                return ceiling.getValue();
            }
            if (this.max == this.max.getAddressSpace().getMaxAddress()) {
                return null;
            }
            Map.Entry ent = DBTraceCacheForSequenceQueries.this.doCeilingEntry(this.snap, address);
            if (ent == null) {
                this.max = this.max.getAddressSpace().getMaxAddress();
                return null;
            }
            Address x1 = ent.getKey().getX1();
            this.nav.put(x1, ent.getValue());
            this.max = x1;
            return ent.getValue();
        }

        public void load(ArrayList<? extends Map.Entry<? extends TraceAddressSnapRange, ? extends T>> entries) {
            for (Map.Entry ent : entries) {
                this.nav.put(ent.getKey().getX1(), ent.getValue());
            }
        }

        protected boolean contains(Address address) {
            return this.min.hasSameAddressSpace(address) && this.min.compareTo((Object)address) <= 0 && this.max.compareTo((Object)address) >= 0;
        }

        protected void reInit(long snap, AddressRange range) {
            this.snap = snap;
            this.min = range.getMinAddress();
            this.max = range.getMaxAddress();
        }
    }
}

