/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import com.google.common.collect.RangeSet;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

public abstract class AbstractCheckedTraceCachedWriteBytesPcodeExecutorStatePiece
extends BytesTracePcodeExecutorStatePiece {
    public AbstractCheckedTraceCachedWriteBytesPcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        super(data);
    }

    @Override
    protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<BytesTracePcodeExecutorStatePiece.CachedSpace> newSpaceMap() {
        return new BytesTracePcodeExecutorStatePiece.TraceBackedSpaceMap(){

            @Override
            protected BytesTracePcodeExecutorStatePiece.CachedSpace newSpace(AddressSpace space, PcodeTraceDataAccess backing) {
                return new CheckedCachedSpace(AbstractCheckedTraceCachedWriteBytesPcodeExecutorStatePiece.this.language, space, backing);
            }
        };
    }

    protected abstract int checkUninitialized(PcodeTraceDataAccess var1, Address var2, int var3, AddressSet var4);

    protected class CheckedCachedSpace
    extends BytesTracePcodeExecutorStatePiece.CachedSpace {
        public CheckedCachedSpace(Language language, AddressSpace space, PcodeTraceDataAccess backing) {
            super(language, space, backing);
        }

        public byte[] read(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
            RangeSet uninitialized = this.bytes.getUninitialized(offset, offset + (long)size - 1L);
            if (!uninitialized.isEmpty()) {
                size = AbstractCheckedTraceCachedWriteBytesPcodeExecutorStatePiece.this.checkUninitialized((PcodeTraceDataAccess)this.backing, this.space.getAddress(offset), size, this.addrSet(uninitialized));
            }
            return super.read(offset, size, reason);
        }
    }
}

