/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import db.buffers.BufferFile;
import db.buffers.LocalManagedBufferFile;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FileSystemEventManager;
import ghidra.framework.store.FileSystemListener;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.local.IndexedLocalFileSystem;
import ghidra.framework.store.local.IndexedV1LocalFileSystem;
import ghidra.framework.store.local.ItemDeserializer;
import ghidra.framework.store.local.LocalDataFile;
import ghidra.framework.store.local.LocalDatabaseItem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.framework.store.local.MangledLocalFileSystem;
import ghidra.framework.store.local.RepositoryLogger;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.PropertyFile;
import ghidra.util.ReadOnlyException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LocalFileSystem
implements FileSystem {
    static final Logger log = LogManager.getLogger(LocalFileSystem.class);
    public static final char HIDDEN_DIR_PREFIX_CHAR = '~';
    public static final String HIDDEN_DIR_PREFIX = Character.toString('~');
    public static final String HIDDEN_ITEM_PREFIX = ".ghidra.";
    private static final String INVALID_FILENAME_CHARS = "/\\'`\"*:<>?|";
    static final String PROPERTY_EXT = ".prp";
    private static boolean refreshRequired = false;
    protected final File root;
    protected final boolean isVersioned;
    protected final boolean readOnly;
    protected final FileSystemEventManager eventManager;
    private RepositoryLogger repositoryLogger;
    private boolean isShared;

    public static LocalFileSystem getLocalFileSystem(String rootPath, boolean create, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws IOException {
        File root = new File(rootPath);
        if (!root.isDirectory()) {
            throw new IOException("filesystem directory not found: " + rootPath);
        }
        if (create && root.list().length != 0) {
            throw new IOException("new filesystem directory is not empty: " + rootPath);
        }
        if (create) {
            return new IndexedV1LocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching, true);
        }
        if (!readOnly && !root.canWrite()) {
            throw new IOException("filesystem directory is not writable: " + rootPath);
        }
        int indexVersion = -1;
        if (IndexedLocalFileSystem.isIndexed(rootPath)) {
            indexVersion = IndexedLocalFileSystem.readIndexVersion(rootPath);
        } else if (IndexedLocalFileSystem.hasIndexedStructure(rootPath)) {
            indexVersion = 1;
        }
        switch (indexVersion) {
            case -1: {
                if (LocalFileSystem.hasAnyHiddenFiles(root)) {
                    throw new IOException("Unsupported file system schema: " + rootPath);
                }
                Msg.warn(LocalFileSystem.class, (Object)("Using deprecated Mangled filesystem: " + rootPath));
                return new MangledLocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching);
            }
            case 0: {
                Msg.warn(LocalFileSystem.class, (Object)("Using deprecated Indexed filesystem (V0): " + rootPath));
                return IndexedLocalFileSystem.getFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching);
            }
            case 1: {
                return IndexedV1LocalFileSystem.getFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching);
            }
        }
        throw new IOException("Unsupported file system version (" + indexVersion + "): " + rootPath);
    }

    @Override
    public String getUserName() {
        return SystemUtilities.getUserName();
    }

    private static boolean hasAnyHiddenFiles(File dir) {
        for (File f : dir.listFiles()) {
            if (!f.getName().startsWith("~") || !f.isFile()) continue;
            return true;
        }
        return false;
    }

    protected LocalFileSystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws FileNotFoundException {
        this.root = new File(rootPath);
        if (!this.root.isDirectory()) {
            throw new FileNotFoundException("data directory not found: " + rootPath);
        }
        this.isVersioned = isVersioned;
        this.readOnly = readOnly;
        this.eventManager = new FileSystemEventManager(enableAsyncronousDispatching);
    }

    protected void cleanupAfterConstruction() {
        if (!this.readOnly) {
            LocalDatabaseItem.cleanupOldPresaveFiles(this.root);
            this.cleanupTemporaryFiles(SEPARATOR);
        }
    }

    protected LocalFileSystem() {
        this.root = null;
        this.isVersioned = false;
        this.readOnly = true;
        this.eventManager = null;
    }

    private void cleanupTemporaryFiles(String folderPath) {
        try {
            for (String itemName : this.getItemNames(folderPath, true)) {
                if (!itemName.startsWith(HIDDEN_ITEM_PREFIX)) continue;
                LocalFolderItem item = this.getItem(folderPath, itemName);
                if (item != null) {
                    item.deleteContent(null);
                }
                this.deallocateItemStorage(folderPath, itemName);
            }
            String parentPath = folderPath + (folderPath.endsWith(SEPARATOR) ? "" : SEPARATOR);
            for (String subfolder : this.getFolderNames(folderPath)) {
                this.cleanupTemporaryFiles(parentPath + subfolder);
            }
        }
        catch (FileNotFoundException parentPath) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setAssociatedRepositoryLogger(RepositoryLogger repositoryLogger) {
        this.repositoryLogger = repositoryLogger;
    }

    protected void log(LocalFolderItem item, String msg, String user) {
        String path;
        String string = path = item != null ? item.getPathName() : null;
        if (this.repositoryLogger != null) {
            this.repositoryLogger.log(path, msg, user);
        } else {
            StringBuffer buf = new StringBuffer();
            if (item != null) {
                buf.append(item.getPathName());
            }
            buf.append(": ");
            buf.append(msg);
            if (user != null) {
                buf.append(" (");
                buf.append(user);
                buf.append(")");
            }
            log.info(buf.toString());
        }
    }

    public static void setValidationRequired() {
        refreshRequired = true;
    }

    public static boolean isRefreshRequired() {
        return refreshRequired;
    }

    @Override
    public boolean isVersioned() {
        return this.isVersioned;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected abstract ItemStorage findItemStorage(String var1, String var2) throws FileNotFoundException;

    protected abstract ItemStorage allocateItemStorage(String var1, String var2) throws IOException, InvalidNameException;

    protected abstract void deallocateItemStorage(String var1, String var2) throws IOException;

    protected abstract String[] getItemNames(String var1, boolean var2) throws IOException;

    @Override
    public synchronized String[] getItemNames(String folderPath) throws IOException {
        return this.getItemNames(folderPath, false);
    }

    @Override
    public synchronized LocalFolderItem getItem(String folderPath, String name) throws IOException {
        try {
            ItemStorage itemStorage = this.findItemStorage(folderPath, name);
            if (itemStorage == null) {
                return null;
            }
            PropertyFile propertyFile = itemStorage.getPropertyFile();
            if (propertyFile.exists()) {
                return LocalFolderItem.getFolderItem(this, propertyFile);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected void fileIdChanged(PropertyFile propertyFile, String oldFileId) throws IOException {
    }

    @Override
    public FolderItem getItem(String fileID) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getItem by File-ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LocalDatabaseItem createDatabase(String parentPath, String name, String fileID, BufferFile bufferFile, String comment, String contentType, boolean resetDatabaseId, TaskMonitor monitor, String user) throws InvalidNameException, IOException, CancelledException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(parentPath, true);
        this.testValidName(name, false);
        ItemStorage itemStorage = this.allocateItemStorage(parentPath, name);
        LocalDatabaseItem item = null;
        try {
            PropertyFile propertyFile = itemStorage.getPropertyFile();
            item = new LocalDatabaseItem(this, propertyFile, bufferFile, contentType, fileID, comment, resetDatabaseId, monitor, user);
        }
        finally {
            if (item == null) {
                this.deallocateItemStorage(parentPath, name);
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LocalDatabaseItem createTemporaryDatabase(String parentPath, String name, String fileID, BufferFile bufferFile, String contentType, boolean resetDatabaseId, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(parentPath, true);
        this.testValidName(name, false);
        String hiddenName = HIDDEN_ITEM_PREFIX + name;
        ItemStorage itemStorage = this.allocateItemStorage(parentPath, hiddenName);
        LocalDatabaseItem item = null;
        try {
            PropertyFile propertyFile = itemStorage.getPropertyFile();
            item = new LocalDatabaseItem(this, propertyFile, bufferFile, contentType, fileID, null, resetDatabaseId, monitor, null);
        }
        finally {
            if (item == null) {
                this.deallocateItemStorage(parentPath, name);
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile createDatabase(String parentPath, String name, String fileID, String contentType, int bufferSize, String user, String projectPath) throws InvalidNameException, IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(parentPath, true);
        this.testValidName(name, false);
        ItemStorage itemStorage = this.allocateItemStorage(parentPath, name);
        LocalManagedBufferFile bufferFile = null;
        try {
            PropertyFile propertyFile = itemStorage.getPropertyFile();
            bufferFile = LocalDatabaseItem.create(this, propertyFile, bufferSize, contentType, fileID, user, projectPath);
        }
        finally {
            if (bufferFile == null) {
                this.deallocateItemStorage(parentPath, name);
            }
        }
        return bufferFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LocalDataFile createDataFile(String parentPath, String name, InputStream istream, String comment, String contentType, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(parentPath, true);
        this.testValidName(name, false);
        ItemStorage itemStorage = this.allocateItemStorage(parentPath, name);
        LocalDataFile dataFile = null;
        try {
            PropertyFile propertyFile = itemStorage.getPropertyFile();
            dataFile = new LocalDataFile(this, propertyFile, istream, contentType, monitor);
        }
        finally {
            if (dataFile == null) {
                this.deallocateItemStorage(parentPath, name);
            }
        }
        this.eventManager.itemCreated(parentPath, name);
        return dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalDatabaseItem createFile(String parentPath, String name, File packedFile, TaskMonitor monitor, String user) throws InvalidNameException, IOException, CancelledException {
        String contentType;
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(parentPath, true);
        this.testValidName(name, false);
        ItemDeserializer itemDeserializer = new ItemDeserializer(packedFile);
        try {
            int fileType = itemDeserializer.getFileType();
            if (fileType != 0) {
                throw new UnsupportedOperationException("Only packed database files are supported");
            }
            if (name == null) {
                name = itemDeserializer.getItemName();
            }
            contentType = itemDeserializer.getContentType();
        }
        finally {
            itemDeserializer.dispose();
        }
        ItemStorage itemStorage = this.allocateItemStorage(parentPath, name);
        LocalDatabaseItem item = null;
        try {
            PropertyFile propertyFile = itemStorage.getPropertyFile();
            item = new LocalDatabaseItem(this, propertyFile, packedFile, contentType, monitor, user);
        }
        finally {
            if (item == null) {
                this.deallocateItemStorage(parentPath, name);
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void moveItem(String folderPath, String name, String newFolderPath, String newName) throws IOException, InvalidNameException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        ItemStorage itemStorage = this.findItemStorage(folderPath, name);
        LocalFolderItem item = this.getItem(folderPath, name);
        if (itemStorage == null || item == null) {
            throw new FileNotFoundException("Item " + name + " in folder " + folderPath + " not found");
        }
        if (folderPath.equals(newFolderPath) && name.equals(newName)) {
            return;
        }
        this.testValidName(newFolderPath, true);
        this.testValidName(newName, false);
        item.checkInUse();
        ItemStorage newStorage = null;
        boolean success = false;
        try {
            newStorage = this.allocateItemStorage(newFolderPath, newName);
            item.moveTo(newStorage.dir, newStorage.storageName, newFolderPath, newName);
            this.deallocateItemStorage(folderPath, name);
            success = true;
            if (folderPath.equals(newFolderPath)) {
                this.eventManager.itemRenamed(folderPath, name, newName);
            } else {
                this.eventManager.itemMoved(folderPath, name, newFolderPath, newName);
            }
            this.deleteEmptyVersionedFolders(folderPath);
            this.deallocateItemStorage(folderPath, name);
        }
        finally {
            if (!success) {
                if (newStorage != null) {
                    this.deallocateItemStorage(newFolderPath, newName);
                }
                this.deleteEmptyVersionedFolders(newFolderPath);
            }
        }
    }

    @Override
    public abstract boolean folderExists(String var1);

    @Override
    public boolean fileExists(String folderPath, String name) {
        try {
            ItemStorage itemStorage = this.findItemStorage(folderPath, name);
            if (itemStorage == null) {
                return false;
            }
            return itemStorage.exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void addFileSystemListener(FileSystemListener listener) {
        if (this.eventManager != null) {
            this.eventManager.add(listener);
        }
    }

    @Override
    public void removeFileSystemListener(FileSystemListener listener) {
        if (this.eventManager != null) {
            this.eventManager.remove(listener);
        }
    }

    FileSystemListener getListener() {
        return this.eventManager;
    }

    public abstract int getMaxNameLength();

    public void testValidName(String name, boolean isPath) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("path or name is empty or null");
        }
        if (isPath) {
            String[] splitName;
            if (name.equals(SEPARATOR)) {
                return;
            }
            if (name.startsWith(SEPARATOR)) {
                name = name.substring(1);
            }
            for (String element : splitName = name.split(SEPARATOR)) {
                this.testValidName(element, false);
            }
            return;
        }
        if (!isPath && name.length() > this.getMaxNameLength()) {
            throw new InvalidNameException("Project file names within Ghidra must be less than " + this.getMaxNameLength() + " characters in length.");
        }
        if (name.startsWith(HIDDEN_ITEM_PREFIX)) {
            throw new InvalidNameException(name + " starts with a reserved prefix '.ghidra.'");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (LocalFileSystem.isValidNameCharacter(c)) continue;
            throw new InvalidNameException(name + " contains an invalid character: '" + c + "'");
        }
    }

    public static boolean isValidNameCharacter(char c) {
        return c >= ' ' && INVALID_FILENAME_CHARS.indexOf(c) < 0 && c <= '\u00ff';
    }

    protected synchronized void deleteEmptyVersionedFolders(String folderPath) {
        try {
            if (this.isVersioned) {
                if (folderPath.length() == 1) {
                    return;
                }
                String[] items = this.getItemNames(folderPath);
                if (items.length > 0) {
                    return;
                }
                String[] folders = this.getFolderNames(folderPath);
                if (folders.length > 0) {
                    return;
                }
                this.deleteFolder(folderPath);
                this.deleteEmptyVersionedFolders(LocalFileSystem.getParentPath(folderPath));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected synchronized void itemDeleted(String folderPath, String itemName) throws IOException {
    }

    protected static final String getPath(String parentPath, String name) {
        if (parentPath.length() == 1) {
            return parentPath + name;
        }
        return parentPath + "/" + name;
    }

    protected static final String getParentPath(String path) {
        if (path.length() == 1) {
            return null;
        }
        int index = path.lastIndexOf(47);
        if (index == 0) {
            return SEPARATOR;
        }
        return path.substring(0, index);
    }

    protected static final String getName(String path) {
        if (path.length() == 1) {
            return path;
        }
        if (path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public void dispose() {
        if (this.eventManager != null) {
            this.eventManager.dispose();
        }
    }

    public boolean migrationInProgress() {
        return false;
    }

    public static final boolean isHiddenDirName(String name) {
        if (name.startsWith(".")) {
            return true;
        }
        return (LocalFileSystem.countHiddenDirPrefixChars(name) & 1) == 1;
    }

    public static final String escapeHiddenDirPrefixChars(String name) {
        int prefixCount = LocalFileSystem.countHiddenDirPrefixChars(name);
        if (prefixCount == 0) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < prefixCount; ++i) {
            buf.append('~');
        }
        buf.append(name);
        return buf.toString();
    }

    public static final String unescapeHiddenDirPrefixChars(String name) {
        int prefixCount = LocalFileSystem.countHiddenDirPrefixChars(name);
        if ((prefixCount & 1) == 1) {
            return null;
        }
        return name.substring(prefixCount >>= 1);
    }

    private static int countHiddenDirPrefixChars(String name) {
        int count = 0;
        int length = name.length();
        for (int index = 0; index < length && name.charAt(index) == '~'; ++index) {
            ++count;
        }
        return count;
    }

    protected static class ItemStorage {
        File dir;
        String storageName;
        String folderPath;
        String itemName;

        ItemStorage(File dir, String storageName, String folderPath, String itemName) {
            this.dir = dir;
            this.storageName = storageName;
            this.folderPath = folderPath;
            this.itemName = itemName;
        }

        boolean exists() {
            File pfile = new File(this.dir, this.storageName + LocalFileSystem.PROPERTY_EXT);
            return pfile.exists();
        }

        PropertyFile getPropertyFile() throws IOException {
            return new PropertyFile(this.dir, this.storageName, this.folderPath, this.itemName);
        }

        public String toString() {
            Object path;
            try {
                path = this.getPropertyFile().getPath();
            }
            catch (IOException e) {
                path = "<ERROR: " + e.getMessage() + ">";
            }
            return this.itemName + " (" + this.storageName + ", " + (String)path + ")";
        }
    }
}

