/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote.security;

import ghidra.security.KeyStorePasswordProvider;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

public class SSHKeyManager {
    private static KeyStorePasswordProvider passwordProvider;

    private SSHKeyManager() {
    }

    public static synchronized void setProtectedKeyStorePasswordProvider(KeyStorePasswordProvider provider) {
        passwordProvider = provider;
    }

    public static CipherParameters getSSHPrivateKey(File sshPrivateKeyFile) throws InvalidKeyException, IOException {
        if (!sshPrivateKeyFile.isFile()) {
            throw new FileNotFoundException("SSH private key file not found: " + sshPrivateKeyFile);
        }
        try (FileInputStream keyIn = new FileInputStream(sshPrivateKeyFile);){
            CipherParameters cipherParameters = SSHKeyManager.getSSHPrivateKey(keyIn, sshPrivateKeyFile.getAbsolutePath());
            return cipherParameters;
        }
    }

    public static CipherParameters getSSHPrivateKey(InputStream sshPrivateKeyIn) throws InvalidKeyException, IOException {
        return SSHKeyManager.getSSHPrivateKey(sshPrivateKeyIn, "Protected SSH Key");
    }

    /*
     * Loose catch block
     */
    private static CipherParameters getSSHPrivateKey(InputStream sshPrivateKeyIn, String srcName) throws InvalidKeyException, IOException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        StringReader r;
        char[] password;
        block22: {
            PrivateKeyInfo privateKeyInfo;
            StringBuffer keyBuf = new StringBuffer();
            try (BufferedReader r2 = new BufferedReader(new InputStreamReader(sshPrivateKeyIn));){
                String line;
                boolean checkKeyFormat = true;
                while ((line = r2.readLine()) != null) {
                    if (checkKeyFormat) {
                        if (!line.startsWith("-----BEGIN ") || line.indexOf(" KEY-----") < 0) {
                            throw new InvalidKeyException("Invalid SSH Private Key");
                        }
                        if (!line.startsWith("-----BEGIN RSA PRIVATE KEY-----") && !line.startsWith("-----BEGIN DSA PRIVATE KEY-----")) {
                            Msg.error(SSHKeyManager.class, (Object)"Unsupported SSH Key Format (see svrREADME.html)");
                            throw new IOException("Unsupported SSH Private Key");
                        }
                        checkKeyFormat = false;
                    }
                    if (keyBuf.length() != 0) {
                        keyBuf.append('\n');
                    }
                    keyBuf.append(line);
                }
            }
            password = null;
            r = new StringReader(keyBuf.toString());
            PEMParser pemParser = new PEMParser((Reader)r);
            Object object = pemParser.readObject();
            if (object instanceof PEMEncryptedKeyPair) {
                password = passwordProvider.getKeyStorePassword(srcName, false);
                if (password == null) {
                    throw new IOException("Password required to open SSH private keystore");
                }
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password);
                privateKeyInfo = ckp.decryptKeyPair(decProv).getPrivateKeyInfo();
            } else {
                PEMKeyPair ukp = (PEMKeyPair)object;
                privateKeyInfo = ukp.getPrivateKeyInfo();
            }
            asymmetricKeyParameter = PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
            ((Reader)r).close();
            if (password == null) break block22;
            Arrays.fill(password, '\u0000');
        }
        return asymmetricKeyParameter;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)r).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (password != null) {
                        Arrays.fill(password, '\u0000');
                    }
                    throw throwable3;
                }
            }
        }
    }

    public static CipherParameters getSSHPublicKey(File sshPublicKeyFile) throws IOException {
        String[] part;
        String keyLine = null;
        try (BufferedReader r = new BufferedReader(new FileReader(sshPublicKeyFile));){
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("ssh-")) continue;
                keyLine = line;
                break;
            }
        }
        if (keyLine != null && (part = keyLine.split("\\s+")).length >= 2 && part[0].startsWith("ssh-")) {
            byte[] pubkeyBytes = Base64.decode((String)part[1]);
            return OpenSSHPublicKeyUtil.parsePublicKey((byte[])pubkeyBytes);
        }
        throw new IOException("Invalid SSH public key file, supported SSH public key not found: " + sshPublicKeyFile);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

