/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.methods;

import agent.frida.manager.FridaExport;
import agent.frida.manager.FridaImport;
import agent.frida.manager.FridaSymbol;
import agent.frida.model.iface1.FridaModelTargetMethod;
import agent.frida.model.iface2.FridaModelTargetObject;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="FunctionIntercept", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetFunctionInterceptorImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMethod {
    protected final TargetMethod.TargetParameterMap paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());

    public FridaModelTargetFunctionInterceptorImpl(FridaModelTargetObject parent) {
        super(parent.getModel(), (TargetObject)parent, "intercept", "FunctionIntercept");
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", this.paramDescs), "Initialized");
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription onEnter = TargetMethod.ParameterDescription.create(String.class, (String)"OnEnter", (boolean)false, (Object)"", (String)"onEnter file", (String)"JS file with onEnter implemenation");
        TargetMethod.ParameterDescription onLeave = TargetMethod.ParameterDescription.create(String.class, (String)"OnLeave", (boolean)false, (Object)"", (String)"onLeave file", (String)"JS file with onLeave implemenation");
        TargetMethod.ParameterDescription name = TargetMethod.ParameterDescription.create(String.class, (String)"Name", (boolean)false, (Object)"intercept", (String)"name", (String)"name for future unload");
        TargetMethod.ParameterDescription script = TargetMethod.ParameterDescription.create(String.class, (String)"Script", (boolean)false, (Object)"", (String)"script", (String)"script to execute on result");
        map.put("OnEnter", onEnter);
        map.put("OnLeave", onLeave);
        map.put("Name", name);
        map.put("Script", script);
        return map;
    }

    public CompletableFuture<Object> invoke(Map<String, ?> arguments) {
        Object modelObject = this.getModelObject();
        String address = null;
        if (modelObject instanceof FridaImport) {
            address = ((FridaImport)modelObject).getAddress();
        }
        if (modelObject instanceof FridaExport) {
            address = ((FridaExport)modelObject).getAddress();
        }
        if (modelObject instanceof FridaSymbol) {
            address = ((FridaSymbol)modelObject).getAddress();
        }
        if (address != null) {
            this.getManager().interceptFunction(address, arguments);
        }
        return CompletableFuture.completedFuture(null);
    }
}

