/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaRegionInfo;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.cmd.FridaReadMemoryCommand;
import agent.frida.manager.cmd.FridaWriteMemoryCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import agent.frida.model.iface2.FridaModelTargetMemoryContainer;
import agent.frida.model.iface2.FridaModelTargetMemoryRegion;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.impl.FridaModelImpl;
import agent.frida.model.impl.FridaModelTargetMemoryRegionImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.methods.FridaModelTargetMemoryPatchImpl;
import agent.frida.model.methods.FridaModelTargetMemoryProtectImpl;
import agent.frida.model.methods.FridaModelTargetMemoryScanImpl;
import agent.frida.model.methods.FridaModelTargetMemoryWatchImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Memory", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=FridaModelTargetMemoryRegionImpl.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetMemoryContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMemoryContainer {
    protected final FridaModelTargetProcess process;
    protected final FridaModelTargetMemoryScanImpl scan;
    protected final FridaModelTargetMemoryPatchImpl patch;
    protected final FridaModelTargetMemoryProtectImpl prot;
    protected final FridaModelTargetMemoryWatchImpl watch;
    protected final FridaModelTargetUnloadScriptImpl unload;
    protected final Map<String, FridaModelTargetMemoryRegionImpl> memoryRegions = new WeakValueHashMap();

    public FridaModelTargetMemoryContainerImpl(FridaModelTargetProcess process) {
        super(process.getModel(), (TargetObject)process, "Memory", "MemoryContainer");
        this.process = process;
        this.scan = new FridaModelTargetMemoryScanImpl(this, false);
        this.patch = new FridaModelTargetMemoryPatchImpl(this);
        this.prot = new FridaModelTargetMemoryProtectImpl(this, false);
        this.watch = new FridaModelTargetMemoryWatchImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.watch.getName());
        this.changeAttributes(List.of(), List.of(), Map.of(this.scan.getName(), this.scan, this.patch.getName(), this.patch, this.prot.getName(), this.prot, this.watch.getName(), this.watch, this.unload.getName(), this.unload), "Initialized");
        this.getManager().addEventsListener(this);
        this.requestElements(true);
    }

    public FridaModelTargetMemoryContainerImpl(FridaModelTargetProcess process, String name) {
        super(process.getModel(), (TargetObject)process, name, "MemoryContainer");
        this.process = process;
        this.scan = new FridaModelTargetMemoryScanImpl(this, false);
        this.patch = new FridaModelTargetMemoryPatchImpl(this);
        this.prot = new FridaModelTargetMemoryProtectImpl(this, false);
        this.watch = new FridaModelTargetMemoryWatchImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.watch.getName());
        this.changeAttributes(List.of(), List.of(), Map.of(this.scan.getName(), this.scan, this.patch.getName(), this.patch, this.prot.getName(), this.prot, this.watch.getName(), this.watch, this.unload.getName(), this.unload), "Initialized");
        this.requestElements(false);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        if (refresh) {
            ((DebuggerModelListener)this.listeners.fire).invalidateCacheRequested((TargetObject)this);
        }
        return this.getManager().listMemory(this.process.getProcess());
    }

    @Override
    public synchronized FridaModelTargetMemoryRegion getTargetMemory(FridaMemoryRegionInfo region) {
        TargetObject targetObject = this.getMapObject(region);
        if (targetObject != null) {
            FridaModelTargetMemoryRegion targetRegion = (FridaModelTargetMemoryRegion)targetObject;
            targetRegion.setModelObject(region);
            return targetRegion;
        }
        return new FridaModelTargetMemoryRegionImpl(this, region);
    }

    private byte[] readAssist(Address address, ByteBuffer buf, long offset, RangeSet<Long> set) {
        if (set == null) {
            return new byte[0];
        }
        Range range = set.rangeContaining((Comparable)Long.valueOf(offset));
        if (range == null) {
            throw new DebuggerMemoryAccessException("Cannot read at " + address);
        }
        ((DebuggerModelListener)this.listeners.fire).memoryUpdated((TargetObject)this.getProxy(), address, buf.array());
        return Arrays.copyOf(buf.array(), (int)((Long)range.upperEndpoint() - (Long)range.lowerEndpoint()));
    }

    private void writeAssist(Address address, byte[] data) {
        ((DebuggerModelListener)this.listeners.fire).memoryUpdated((TargetObject)this.getProxy(), address, data);
    }

    @Override
    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        return this.model.gateFuture(this.doReadMemory(address, length));
    }

    protected CompletableFuture<byte[]> doReadMemory(Address address, int length) {
        FridaManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command readMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.allocate(length);
        long offset = address.getOffset();
        if (!manager.isKernelMode() || address.getAddressSpace().getName().equals("ram")) {
            return manager.execute(new FridaReadMemoryCommand(manager, address, buf, buf.remaining())).thenApply(set -> this.readAssist(address, buf, offset, (RangeSet<Long>)set));
        }
        return CompletableFuture.completedFuture(new byte[length]);
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        return this.model.gateFuture(this.doWriteMemory(address, data));
    }

    protected CompletableFuture<Void> doWriteMemory(Address address, byte[] data) {
        FridaManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command writeMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (!manager.isKernelMode() || address.getAddressSpace().getName().equals("ram")) {
            return manager.execute(new FridaWriteMemoryCommand(manager, address, buf, buf.remaining())).thenAccept(___ -> this.writeAssist(address, data));
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regionAdded(FridaProcess proc, FridaRegionInfo info, int index, FridaCause cause) {
        FridaModelTargetMemoryRegion targetRegion;
        FridaMemoryRegionInfo region = info.getRegion(index);
        FridaModelTargetMemoryContainerImpl fridaModelTargetMemoryContainerImpl = this;
        synchronized (fridaModelTargetMemoryContainerImpl) {
            targetRegion = this.getTargetMemory(region);
        }
        if (targetRegion == null) {
            Msg.error((Object)this, (Object)("Region " + region.getRangeAddress() + " not found!"));
            return;
        }
        this.changeElements(List.of(), List.of(targetRegion), Map.of(), "Added");
    }

    @Override
    public void regionReplaced(FridaProcess proc, FridaRegionInfo info, int index, FridaCause cause) {
        FridaMemoryRegionInfo region = info.getRegion(index);
        this.changeElements(List.of(), List.of(this.getTargetMemory(region)), Map.of(), "Replaced");
        FridaModelTargetMemoryRegion targetRegion = this.getTargetMemory(region);
        this.changeElements(List.of(), List.of(targetRegion), Map.of(), "Replaced");
    }

    @Override
    public void regionRemoved(FridaProcess proc, FridaRegionInfo info, int index, FridaCause cause) {
        FridaModelTargetMemoryRegion targetRegion = this.getTargetMemory(info.getRegion(index));
        if (targetRegion != null) {
            FridaModelImpl impl = (FridaModelImpl)this.model;
            impl.deleteModelObject(targetRegion.getModelObject());
        }
        this.changeElements(List.of(targetRegion.getName()), List.of(), Map.of(), "Removed");
    }
}

