/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaExport;
import agent.frida.model.iface2.FridaModelTargetExport;
import agent.frida.model.impl.FridaModelTargetExportContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.methods.FridaModelTargetFunctionInterceptorImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Export", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_value", type=Address.class), @TargetAttributeType(name="_size", type=long.class), @TargetAttributeType(name="Address", type=Address.class), @TargetAttributeType(name="Name", type=String.class), @TargetAttributeType(name="Type", type=String.class), @TargetAttributeType(type=Object.class)})
public class FridaModelTargetExportImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetExport {
    protected final boolean constant;
    protected Address value;
    protected String name;
    private FridaModelTargetFunctionInterceptorImpl intercept;
    private FridaModelTargetUnloadScriptImpl unload;

    protected static String indexExport(FridaExport symbol) {
        return symbol.getName();
    }

    protected static String keyExport(FridaExport symbol) {
        return PathUtils.makeKey((String)FridaModelTargetExportImpl.indexExport(symbol));
    }

    public FridaModelTargetExportImpl(FridaModelTargetExportContainerImpl exports, FridaExport export) {
        super(exports.getModel(), (TargetObject)exports, FridaModelTargetExportImpl.keyExport(export), export, "Export");
        this.constant = false;
        try {
            this.value = exports.getModel().getAddressSpace("ram").getAddress(export.getAddress());
        }
        catch (AddressFormatException e) {
            e.printStackTrace();
        }
        this.name = export.getName();
        this.intercept = new FridaModelTargetFunctionInterceptorImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.intercept.getName());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDescription(0), "_value", this.value, "Address", this.value, "Name", export.getName(), "Type", export.getType(), this.intercept.getName(), this.intercept, this.unload.getName(), this.unload), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        FridaExport symbol = (FridaExport)this.getModelObject();
        return symbol.getName();
    }

    @Override
    public Address getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

