/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.frida.FridaThreadInfo;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.evt.AbstractFridaCompletedCommandEvent;
import agent.frida.manager.evt.FridaProcessCreatedEvent;
import agent.frida.manager.evt.FridaStoppedEvent;
import agent.frida.manager.evt.FridaThreadCreatedEvent;
import agent.frida.manager.impl.FridaManagerImpl;
import java.util.LinkedHashSet;
import java.util.Set;

public class FridaAttachCommand
extends AbstractFridaCommand<Set<FridaThread>> {
    private FridaProcessCreatedEvent created = null;
    private boolean completed = false;
    private String key;
    private int keyType = 0;
    private boolean wait = true;
    private boolean async = false;

    public FridaAttachCommand(FridaManagerImpl manager, String key) {
        this(manager, key, true, false);
        this.keyType = 0;
    }

    public FridaAttachCommand(FridaManagerImpl manager, String key, boolean wait) {
        this(manager, key, wait, false);
        this.keyType = 1;
    }

    public FridaAttachCommand(FridaManagerImpl manager, String key, boolean wait, boolean async) {
        super(manager);
        this.key = key;
        this.wait = wait;
        this.async = async;
        this.keyType = 2;
    }

    @Override
    public boolean handle(FridaEvent<?> evt, FridaPendingCommand<?> pending) {
        if (evt instanceof AbstractFridaCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof FridaProcessCreatedEvent) {
            this.created = (FridaProcessCreatedEvent)evt;
        } else if (evt instanceof FridaThreadCreatedEvent) {
            pending.claim(evt);
        } else if (evt instanceof FridaStoppedEvent) {
            pending.claim(evt);
        }
        return this.completed && this.created != null;
    }

    @Override
    public Set<FridaThread> complete(FridaPendingCommand<?> pending) {
        LinkedHashSet<FridaThread> threads = new LinkedHashSet<FridaThread>();
        for (FridaThreadCreatedEvent adds : pending.findAllOf(FridaThreadCreatedEvent.class)) {
            FridaThreadInfo info = (FridaThreadInfo)adds.getInfo();
            threads.add(info.thread);
        }
        return threads;
    }

    @Override
    public void invoke() {
        FridaClient client = this.manager.getClient();
        client.attachProcess(client.getLocalServer(), this.keyType, this.key, this.wait, this.async);
    }
}

