/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import com.google.common.collect.Range;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.MapEntry;
import ghidra.app.services.ModuleMapProposal;
import ghidra.app.services.RegionMapProposal;
import ghidra.app.services.SectionMapProposal;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface DebuggerStaticMappingService {
    public void addMapping(TraceLocation var1, ProgramLocation var2, long var3, boolean var5) throws TraceConflictedMappingException;

    public void addIdentityMapping(Trace var1, Program var2, Range<Long> var3, boolean var4);

    public void addMapping(MapEntry<?, ?> var1, boolean var2) throws TraceConflictedMappingException;

    public void addMappings(Collection<? extends MapEntry<?, ?>> var1, TaskMonitor var2, boolean var3, String var4) throws CancelledException;

    public void addModuleMappings(Collection<ModuleMapProposal.ModuleMapEntry> var1, TaskMonitor var2, boolean var3) throws CancelledException;

    public void addSectionMappings(Collection<SectionMapProposal.SectionMapEntry> var1, TaskMonitor var2, boolean var3) throws CancelledException;

    public void addRegionMappings(Collection<RegionMapProposal.RegionMapEntry> var1, TaskMonitor var2, boolean var3) throws CancelledException;

    public Set<Program> getOpenMappedProgramsAtSnap(Trace var1, long var2);

    public ProgramLocation getOpenMappedLocation(TraceLocation var1);

    public ProgramLocation getStaticLocationFromDynamic(ProgramLocation var1);

    public Set<TraceLocation> getOpenMappedLocations(ProgramLocation var1);

    public TraceLocation getOpenMappedLocation(Trace var1, ProgramLocation var2, long var3);

    public ProgramLocation getDynamicLocationFromStatic(TraceProgramView var1, ProgramLocation var2);

    public Map<Program, Collection<MappedAddressRange>> getOpenMappedViews(Trace var1, AddressSetView var2, long var3);

    public Map<TraceSpan, Collection<MappedAddressRange>> getOpenMappedViews(Program var1, AddressSetView var2);

    public Set<Program> openMappedProgramsInView(Trace var1, AddressSetView var2, long var3, Set<Exception> var5);

    public void addChangeListener(DebuggerStaticMappingChangeListener var1);

    public void removeChangeListener(DebuggerStaticMappingChangeListener var1);

    public CompletableFuture<Void> changesSettled();

    public Set<DomainFile> findProbableModulePrograms(TraceModule var1);

    public ModuleMapProposal proposeModuleMap(TraceModule var1, Program var2);

    public ModuleMapProposal proposeModuleMap(TraceModule var1, Collection<? extends Program> var2);

    public Map<TraceModule, ModuleMapProposal> proposeModuleMaps(Collection<? extends TraceModule> var1, Collection<? extends Program> var2);

    public SectionMapProposal proposeSectionMap(TraceSection var1, Program var2, MemoryBlock var3);

    public SectionMapProposal proposeSectionMap(TraceModule var1, Program var2);

    public SectionMapProposal proposeSectionMap(TraceModule var1, Collection<? extends Program> var2);

    public Map<TraceModule, SectionMapProposal> proposeSectionMaps(Collection<? extends TraceModule> var1, Collection<? extends Program> var2);

    public RegionMapProposal proposeRegionMap(TraceMemoryRegion var1, Program var2, MemoryBlock var3);

    public RegionMapProposal proposeRegionMap(Collection<? extends TraceMemoryRegion> var1, Program var2);

    public Map<Collection<TraceMemoryRegion>, RegionMapProposal> proposeRegionMaps(Collection<? extends TraceMemoryRegion> var1, Collection<? extends Program> var2);

    public static class MappedAddressRange
    implements Comparable<MappedAddressRange> {
        private final AddressRange srcRange;
        private final AddressRange dstRange;
        private final int hashCode;
        private final long shift;

        public MappedAddressRange(AddressRange srcRange, AddressRange dstRange) {
            this.srcRange = srcRange;
            this.dstRange = dstRange;
            this.hashCode = Objects.hash(dstRange, srcRange);
            this.shift = dstRange.getMinAddress().getOffset() - srcRange.getMinAddress().getOffset();
        }

        public String toString() {
            return "<MappedRange " + this.srcRange + "::" + this.dstRange + ">";
        }

        public long getShift() {
            return this.shift;
        }

        public Address mapSourceToDestination(Address saddr) {
            return this.dstRange.getAddressSpace().getAddress(saddr.getOffset() + this.shift);
        }

        public Address mapDestinationToSource(Address daddr) {
            return this.srcRange.getAddressSpace().getAddress(daddr.getOffset() - this.shift);
        }

        public AddressRange mapSourceToDestination(AddressRange srng) {
            try {
                return new AddressRangeImpl(this.mapSourceToDestination(srng.getMinAddress()), srng.getLength());
            }
            catch (AddressOverflowException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public AddressRange mapDestinationToSource(AddressRange drng) {
            try {
                return new AddressRangeImpl(this.mapDestinationToSource(drng.getMinAddress()), drng.getLength());
            }
            catch (AddressOverflowException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public AddressRange getSourceAddressRange() {
            return this.srcRange;
        }

        public AddressRange getDestinationAddressRange() {
            return this.dstRange;
        }

        @Override
        public int compareTo(MappedAddressRange that) {
            int c = this.dstRange.compareTo((Object)that.dstRange);
            if (c != 0) {
                return c;
            }
            c = this.srcRange.compareTo((Object)that.srcRange);
            if (c != 0) {
                return c;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MappedAddressRange)) {
                return false;
            }
            MappedAddressRange that = (MappedAddressRange)obj;
            if (!this.dstRange.equals(that.dstRange)) {
                return false;
            }
            return this.srcRange.equals(that.srcRange);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

