/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.service.model.record.ObjectBasedTraceRecorder;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import utilities.util.IDKeyed;

class ObjectRecorder {
    protected final ObjectBasedTraceRecorder recorder;
    protected final TraceObjectManager objectManager;
    protected final boolean isSupportsFocus;
    private final BidiMap<IDKeyed<TargetObject>, IDKeyed<TraceObject>> objectMap = new DualHashBidiMap();

    protected ObjectRecorder(ObjectBasedTraceRecorder recorder) {
        this.recorder = recorder;
        this.objectManager = recorder.trace.getObjectManager();
        TargetObjectSchema schema = recorder.target.getSchema();
        this.isSupportsFocus = !schema.searchFor(TargetFocusScope.class, false).isEmpty();
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)recorder.trace, (String)"Create root");){
            this.objectManager.createRootObject(schema);
        }
    }

    protected TraceObject toTrace(TargetObject targetObject) {
        IDKeyed traceObject = (IDKeyed)this.objectMap.get((Object)new IDKeyed((Object)targetObject));
        return traceObject == null ? null : (TraceObject)traceObject.obj;
    }

    protected TargetObject toTarget(TraceObject traceObject) {
        IDKeyed targetObject = (IDKeyed)this.objectMap.getKey((Object)new IDKeyed((Object)traceObject));
        return targetObject == null ? null : (TargetObject)targetObject.obj;
    }

    protected String computeExtraInterfaces(TargetObject object) {
        LinkedHashSet result = new LinkedHashSet(object.getInterfaceNames());
        for (Class iface : object.getSchema().getInterfaces()) {
            result.remove(DebuggerObjectModel.requireIfaceName((Class)iface));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.stream().collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordCreated(long snap, TargetObject object) {
        TraceObject traceObject = object.isRoot() ? this.objectManager.getRootObject() : this.objectManager.createObject(TraceObjectKeyPath.of((List)object.getPath()));
        BidiMap<IDKeyed<TargetObject>, IDKeyed<TraceObject>> bidiMap = this.objectMap;
        synchronized (bidiMap) {
            IDKeyed exists = (IDKeyed)this.objectMap.put((Object)new IDKeyed((Object)object), (Object)new IDKeyed((Object)traceObject));
            if (exists != null) {
                Msg.error((Object)this, (Object)("Received created for an object that already exists: " + exists));
            }
        }
        String extras = this.computeExtraInterfaces(object);
        traceObject.setAttribute(Range.atLeast((Comparable)Long.valueOf(snap)), "_extra_ifs", (Object)extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordInvalidated(long snap, TargetObject object) {
        IDKeyed traceObject;
        if (object.isRoot()) {
            return;
        }
        BidiMap<IDKeyed<TargetObject>, IDKeyed<TraceObject>> bidiMap = this.objectMap;
        synchronized (bidiMap) {
            traceObject = (IDKeyed)this.objectMap.remove((Object)new IDKeyed((Object)object));
        }
        if (traceObject == null) {
            Msg.error((Object)this, (Object)("Unknown object was invalidated: " + object));
            return;
        }
        ((TraceObject)traceObject.obj).removeTree(Range.atLeast((Comparable)Long.valueOf(snap)));
    }

    protected String encodeEnum(Enum<?> e) {
        return e.name();
    }

    protected String encodeEnumSet(Set<? extends Enum<?>> s) {
        return s.stream().sorted(Comparator.comparing(Enum::ordinal)).map(Enum::name).collect(Collectors.joining(","));
    }

    protected Object mapAttribute(Object attribute) {
        if (attribute instanceof TargetObject) {
            TraceObject traceObject = this.toTrace((TargetObject)attribute);
            if (traceObject == null) {
                Msg.error((Object)this, (Object)("Unknown object appeared as an attribute: " + attribute));
            }
            return traceObject;
        }
        if (attribute instanceof Address) {
            Address traceAddress = this.recorder.memoryMapper.targetToTrace((Address)attribute);
            if (traceAddress == null) {
                Msg.error((Object)this, (Object)("Unmappable address appeared as an attribute: " + attribute));
            }
            return traceAddress;
        }
        if (attribute instanceof AddressRange) {
            AddressRange traceRange = this.recorder.memoryMapper.targetToTrace((AddressRange)attribute);
            if (traceRange == null) {
                Msg.error((Object)this, (Object)("Unmappable range appeared as an attribute: " + attribute));
            }
            return traceRange;
        }
        if (attribute instanceof TargetAttacher.TargetAttachKind) {
            return this.encodeEnum((Enum<?>)((TargetAttacher.TargetAttachKind)attribute));
        }
        if (attribute instanceof TargetAttacher.TargetAttachKindSet) {
            return this.encodeEnumSet((Set<? extends Enum<?>>)((TargetAttacher.TargetAttachKindSet)attribute));
        }
        if (attribute instanceof TargetBreakpointSpec.TargetBreakpointKind) {
            return this.encodeEnum((Enum<?>)((TargetBreakpointSpec.TargetBreakpointKind)attribute));
        }
        if (attribute instanceof TargetBreakpointSpecContainer.TargetBreakpointKindSet) {
            return this.encodeEnumSet((Set<? extends Enum<?>>)((TargetBreakpointSpecContainer.TargetBreakpointKindSet)attribute));
        }
        if (attribute instanceof TargetExecutionStateful.TargetExecutionState) {
            return this.encodeEnum((Enum<?>)((TargetExecutionStateful.TargetExecutionState)attribute));
        }
        if (attribute instanceof TargetMethod.TargetParameterMap) {
            return "[parameter map not recorded]";
        }
        if (attribute instanceof TargetSteppable.TargetStepKind) {
            return this.encodeEnum((Enum<?>)((TargetSteppable.TargetStepKind)attribute));
        }
        if (attribute instanceof TargetSteppable.TargetStepKindSet) {
            return this.encodeEnumSet((Set<? extends Enum<?>>)((TargetSteppable.TargetStepKindSet)attribute));
        }
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordAttributes(long snap, TargetObject object, Collection<String> removed, Map<String, ?> added) {
        TraceObject traceObject;
        HashMap<String, Object> traceAdded = new HashMap<String, Object>();
        BidiMap<IDKeyed<TargetObject>, IDKeyed<TraceObject>> bidiMap = this.objectMap;
        synchronized (bidiMap) {
            traceObject = this.toTrace(object);
            if (traceObject == null) {
                Msg.error((Object)this, (Object)("Unknown object had attributes changed: " + object));
                return;
            }
            for (Map.Entry<String, ?> entry : added.entrySet()) {
                Object value = this.mapAttribute(entry.getValue());
                if (value == null) continue;
                traceAdded.put(entry.getKey(), value);
            }
        }
        for (Map.Entry entry : traceAdded.entrySet()) {
            traceObject.setAttribute(Range.atLeast((Comparable)Long.valueOf(snap)), (String)entry.getKey(), entry.getValue());
        }
    }

    protected TraceObject mapElement(TargetObject element) {
        TraceObject traceObject = this.toTrace(element);
        if (traceObject == null) {
            Msg.error((Object)this, (Object)("Unknown object appeared as an element: " + element));
            return null;
        }
        return traceObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordElements(long snap, TargetObject object, Collection<String> removed, Map<String, ? extends TargetObject> added) {
        TraceObject traceObject;
        HashMap<String, TraceObject> traceAdded = new HashMap<String, TraceObject>();
        BidiMap<IDKeyed<TargetObject>, IDKeyed<TraceObject>> bidiMap = this.objectMap;
        synchronized (bidiMap) {
            traceObject = this.toTrace(object);
            if (traceObject == null) {
                Msg.error((Object)this, (Object)("Unknown object had attributes changed: " + object));
                return;
            }
            for (Map.Entry<String, ? extends TargetObject> entry : added.entrySet()) {
                TraceObject value = this.mapElement(entry.getValue());
                if (value == null) continue;
                traceAdded.put(entry.getKey(), value);
            }
        }
        for (Map.Entry entry : traceAdded.entrySet()) {
            traceObject.setElement(Range.atLeast((Comparable)Long.valueOf(snap)), (String)entry.getKey(), entry.getValue());
        }
    }

    protected <T extends TargetObject, I extends TraceObjectInterface> T getTargetInterface(TraceUniqueObject traceUnique, Class<I> traceObjectIf, Class<T> targetObjectIf) {
        if (!traceObjectIf.isAssignableFrom(traceUnique.getClass())) {
            return null;
        }
        TraceObject traceObject = ((TraceObjectInterface)traceObjectIf.cast(traceUnique)).getObject();
        return this.getTargetInterface(traceObject, targetObjectIf);
    }

    protected <T extends TargetObject> T getTargetInterface(TraceObject traceObject, Class<T> targetObjectIf) {
        TargetObject targetObject = this.toTarget(traceObject);
        return (T)(targetObject == null ? null : targetObject.as(targetObjectIf));
    }

    protected <I extends TraceObjectInterface> I getTraceInterface(TargetObject targetObject, Class<I> traceObjectIf) {
        TraceObject traceObject = this.toTrace(targetObject);
        return (I)(traceObject == null ? null : traceObject.queryInterface(traceObjectIf));
    }

    protected <T extends TargetObject> T getTargetFrameInterface(TraceThread thread, int frameLevel, Class<T> targetObjectIf) {
        PathPattern applied;
        if (thread == null) {
            return null;
        }
        TraceObject object = ((TraceObjectThread)thread).getObject();
        PathMatcher matcher = object.getTargetSchema().searchFor(targetObjectIf, false);
        PathPattern pattern = matcher.getSingletonPattern();
        if (pattern == null) {
            return null;
        }
        if (pattern.countWildcards() == 0) {
            if (frameLevel != 0) {
                return null;
            }
            applied = pattern;
        } else if (pattern.countWildcards() == 1) {
            applied = pattern.applyIntKeys(new int[]{frameLevel});
        } else {
            return null;
        }
        TraceObjectValPath found = object.getSuccessors(Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), (PathPredicates)applied).findAny().orElse(null);
        if (found == null) {
            return null;
        }
        TraceObject last = found.getDestination(null);
        if (last == null) {
            return null;
        }
        return this.getTargetInterface(last, targetObjectIf);
    }

    protected <T extends TargetObject> List<T> collectTargetSuccessors(TargetObject targetSeed, Class<T> targetIf) {
        TraceObject seed = this.toTrace(targetSeed);
        if (seed == null) {
            return List.of();
        }
        return seed.querySuccessorsTargetInterface(Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), targetIf).map(p -> this.toTarget(p.getDestination(seed)).as(targetIf)).collect(Collectors.toList());
    }
}

