/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.app.services.DebuggerModelService;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.framework.options.SaveState;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

public class DebuggerConnectDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private static final String KEY_FACTORY_CLASSNAME = "factoryClassname";
    private static final String HTML_BOLD_DESCRIPTION = "<html><b>Description:</b> ";
    private DebuggerModelService modelService;
    private DebuggerModelFactory factory;
    private final Map<DebuggerModelFactory, FactoryEntry> factories = new HashMap<DebuggerModelFactory, FactoryEntry>();
    private FactoriesChangedListener listener = new FactoriesChangedListener();
    private JComboBox<FactoryEntry> dropdown;
    protected final DefaultComboBoxModel<FactoryEntry> dropdownModel = new DefaultComboBoxModel();
    private final BidiMap<ConfigurableFactory.Property<?>, PropertyEditor> propertyEditors = new DualLinkedHashBidiMap();
    private final Map<ConfigurableFactory.Property<?>, Component> components = new LinkedHashMap();
    protected JLabel description;
    protected JPanel pairPanel;
    private PairLayout layout;
    protected JButton connectButton;
    protected CompletableFuture<? extends DebuggerObjectModel> futureConnect;
    protected CompletableFuture<DebuggerObjectModel> result;

    public DebuggerConnectDialog() {
        super("Connect", true, true, true, false);
        this.populateComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFactories() {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            this.factories.clear();
            SwingUtilities.invokeLater(() -> this.dropdownModel.removeAllElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFactories() {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            ArrayList<FactoryEntry> toAdd = new ArrayList<FactoryEntry>();
            Set<DebuggerModelFactory> current = this.modelService.getModelFactories();
            for (DebuggerModelFactory element : current) {
                FactoryEntry entry = new FactoryEntry(element);
                this.factories.put(element, entry);
                toAdd.add(entry);
            }
            SwingUtilities.invokeLater(() -> {
                toAdd.sort(Comparator.comparing(FactoryEntry::toString));
                for (FactoryEntry entry : toAdd) {
                    this.dropdownModel.addElement(entry);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactory(DebuggerModelFactory element) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            if (this.factories.containsKey(element)) {
                return;
            }
            FactoryEntry entry = new FactoryEntry(element);
            this.factories.put(element, entry);
            SwingUtilities.invokeLater(() -> this.dropdownModel.addElement(entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFactory(DebuggerModelFactory element) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            FactoryEntry entry = this.factories.remove(element);
            if (entry == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.dropdownModel.removeElement(entry));
        }
    }

    public void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeFactoriesChangedListener(this.listener);
            this.clearFactories();
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addFactoriesChangedListener(this.listener);
            this.loadFactories();
        }
    }

    public void dispose() {
        this.modelService.removeFactoriesChangedListener(this.listener);
        this.clearFactories();
        super.dispose();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Box topBox = Box.createVerticalBox();
        this.dropdown = new JComboBox<FactoryEntry>(this.dropdownModel);
        topBox.add(this.dropdown);
        JPanel inner = new JPanel(new BorderLayout());
        this.description = new JLabel("<html><b>Description:</b> </html>");
        this.description.setBorder(new EmptyBorder(10, 0, 10, 0));
        inner.add(this.description);
        topBox.add(inner);
        panel.add((Component)topBox, "North");
        this.layout = new PairLayout(5, 5);
        this.pairPanel = new JPanel((LayoutManager)this.layout);
        JPanel centering = new JPanel(new FlowLayout(1));
        JScrollPane scrolling = new JScrollPane(centering, 20, 31);
        scrolling.setPreferredSize(new Dimension(100, 130));
        panel.add((Component)scrolling, "Center");
        centering.add(this.pairPanel);
        this.addWorkPanel(panel);
        this.connectButton = new JButton();
        DebuggerResources.AbstractConnectAction.styleButton(this.connectButton);
        this.addButton(this.connectButton);
        this.addCancelButton();
        this.dropdown.addItemListener(this::itemSelected);
        this.connectButton.addActionListener(this::connect);
    }

    private void itemSelected(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            this.pairPanel.removeAll();
        } else if (evt.getStateChange() == 1) {
            FactoryEntry ent = (FactoryEntry)evt.getItem();
            this.factory = ent.factory;
            this.populateOptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(ActionEvent evt) {
        this.connectButton.setEnabled(false);
        for (Map.Entry ent : this.propertyEditors.entrySet()) {
            ConfigurableFactory.Property prop;
            ConfigurableFactory.Property objProp = prop = (ConfigurableFactory.Property)ent.getKey();
            objProp.setValue(((PropertyEditor)ent.getValue()).getValue());
        }
        this.setStatusText("Connecting...");
        DebuggerConnectDialog debuggerConnectDialog = this;
        synchronized (debuggerConnectDialog) {
            this.futureConnect = this.factory.build();
        }
        ((CompletableFuture)((CompletableFuture)this.futureConnect.thenAcceptAsync(m -> {
            this.modelService.addModel((DebuggerObjectModel)m);
            this.setStatusText("");
            this.close();
            this.modelService.activateModel((DebuggerObjectModel)m);
            DebuggerConnectDialog debuggerConnectDialog = this;
            synchronized (debuggerConnectDialog) {
                this.result.completeAsync(() -> m);
                this.result = null;
            }
        }, (Executor)SwingExecutorService.LATER)).exceptionally(e -> {
            if (!((e = AsyncUtils.unwrapThrowable((Throwable)e)) instanceof CancellationException)) {
                Msg.showError((Object)this, (Component)this.getComponent(), (String)"Could not connect", (Object)e);
            }
            this.setStatusText("Could not connect: " + e.getMessage(), MessageType.ERROR);
            return null;
        })).whenComplete((v, e) -> {
            DebuggerConnectDialog debuggerConnectDialog = this;
            synchronized (debuggerConnectDialog) {
                this.futureConnect = null;
            }
            this.connectButton.setEnabled(true);
        });
    }

    protected void cancelCallback() {
        if (this.futureConnect != null) {
            this.futureConnect.cancel(false);
        }
        if (this.result != null) {
            this.result.cancel(false);
        }
        super.cancelCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized CompletableFuture<DebuggerObjectModel> reset(DebuggerModelFactory factory) {
        if (factory != null) {
            Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
            synchronized (map) {
                this.dropdownModel.setSelectedItem(this.factories.get(factory));
            }
            this.dropdown.setEnabled(false);
        } else {
            this.dropdown.setEnabled(true);
        }
        if (this.result != null) {
            this.result.cancel(false);
        }
        this.result = new CompletableFuture();
        this.setStatusText("");
        this.connectButton.setEnabled(true);
        return this.result;
    }

    protected void syncOptionsEnabled() {
        for (Map.Entry<ConfigurableFactory.Property<?>, Component> ent : this.components.entrySet()) {
            ent.getValue().setEnabled(ent.getKey().isEnabled());
        }
    }

    protected void populateOptions() {
        this.description.setText(HTML_BOLD_DESCRIPTION + HTMLUtilities.friendlyEncodeHTML((String)this.factory.getHtmlDetails()));
        this.propertyEditors.clear();
        this.components.clear();
        Map optsMap = this.factory.getOptions();
        this.pairPanel.removeAll();
        for (Map.Entry opt : optsMap.entrySet()) {
            ConfigurableFactory.Property property = (ConfigurableFactory.Property)opt.getValue();
            JLabel label = new JLabel((String)opt.getKey());
            this.pairPanel.add(label);
            Class type = property.getValueClass();
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor == null) {
                throw new RuntimeException("Could not find editor for " + property.getValueClass());
            }
            editor.setValue(property.getValue());
            editor.addPropertyChangeListener(this);
            Component comp = MiscellaneousUtils.getEditorComponent(editor);
            this.pairPanel.add(comp);
            this.propertyEditors.put((Object)property, (Object)editor);
            this.components.put(property, comp);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ConfigurableFactory.Property prop;
        PropertyEditor editor = (PropertyEditor)evt.getSource();
        ConfigurableFactory.Property objProp = prop = (ConfigurableFactory.Property)this.propertyEditors.getKey((Object)editor);
        objProp.setValue(editor.getValue());
        this.syncOptionsEnabled();
    }

    public void writeConfigState(SaveState saveState) {
        if (this.factory != null) {
            saveState.putString(KEY_FACTORY_CLASSNAME, this.factory.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfigState(SaveState saveState) {
        String factoryName = saveState.getString(KEY_FACTORY_CLASSNAME, null);
        if (factoryName == null) {
            return;
        }
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            for (Map.Entry<DebuggerModelFactory, FactoryEntry> ent : this.factories.entrySet()) {
                String name = ent.getKey().getClass().getName();
                if (!factoryName.equals(name)) continue;
                this.factory = ent.getKey();
                this.dropdown.setSelectedItem(ent.getValue());
            }
        }
    }

    protected class FactoriesChangedListener
    implements CollectionChangeListener<DebuggerModelFactory> {
        protected FactoriesChangedListener() {
        }

        public void elementAdded(DebuggerModelFactory element) {
            DebuggerConnectDialog.this.addFactory(element);
        }

        public void elementModified(DebuggerModelFactory element) {
        }

        public void elementRemoved(DebuggerModelFactory element) {
            DebuggerConnectDialog.this.removeFactory(element);
        }
    }

    protected static class FactoryEntry {
        DebuggerModelFactory factory;

        public FactoryEntry(DebuggerModelFactory factory) {
            this.factory = factory;
        }

        public String toString() {
            return this.factory.getBrief();
        }
    }
}

