/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation.data;

import ghidra.app.plugin.core.debug.service.emulation.data.DefaultPcodeDebuggerPropertyAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.InternalPcodeDebuggerDataAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerMemoryAccess;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceMemoryAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DefaultPcodeDebuggerMemoryAccess
extends DefaultPcodeTraceMemoryAccess
implements PcodeDebuggerMemoryAccess,
InternalPcodeDebuggerDataAccess {
    protected final PluginTool tool;
    protected final TraceRecorder recorder;

    protected DefaultPcodeDebuggerMemoryAccess(PluginTool tool, TraceRecorder recorder, TracePlatform platform, long snap, TraceTimeViewport viewport) {
        super(platform, snap, viewport);
        this.tool = Objects.requireNonNull(tool);
        this.recorder = recorder;
    }

    @Override
    public boolean isLive() {
        return InternalPcodeDebuggerDataAccess.super.isLive();
    }

    @Override
    public PluginTool getTool() {
        return this.tool;
    }

    @Override
    public TraceRecorder getRecorder() {
        return this.recorder;
    }

    @Override
    public CompletableFuture<Boolean> readFromTargetMemory(AddressSetView guestView) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        AddressSetView hostView = this.platform.mapGuestToHost(guestView);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.readMemoryBlocks(hostView, TaskMonitor.DUMMY).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.platform.getTrace().flushEvents())).thenApply(__ -> true);
    }

    @Override
    public CompletableFuture<Boolean> writeTargetMemory(Address address, byte[] data) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.writeMemory(address, data).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.platform.getTrace().flushEvents())).thenApply(__ -> true);
    }

    @Override
    public boolean readFromStaticImages(SemisparseByteArray bytes, AddressSetView guestView) {
        boolean result = false;
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return false;
        }
        byte[] data = new byte[4096];
        Trace trace = this.platform.getTrace();
        AddressSetView hostView = this.platform.mapGuestToHost(guestView);
        for (Map.Entry<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> ent : mappingService.getOpenMappedViews(trace, hostView, this.snap).entrySet()) {
            Program program = ent.getKey();
            Memory memory = program.getMemory();
            AddressSetView initialized = memory.getLoadedAndInitializedAddressSet();
            Collection<DebuggerStaticMappingService.MappedAddressRange> mappedSet = ent.getValue();
            for (DebuggerStaticMappingService.MappedAddressRange mappedRng : mappedSet) {
                AddressRange progRng = mappedRng.getDestinationAddressRange();
                AddressSpace progSpace = progRng.getAddressSpace();
                for (AddressRange subProgRng : initialized.intersectRange(progRng.getMinAddress(), progRng.getMaxAddress())) {
                    int len;
                    Msg.debug((Object)this, (Object)("Filling in unknown trace memory in emulator using mapped image: " + program + ": " + subProgRng));
                    long lower = subProgRng.getMinAddress().getOffset();
                    for (long fullLen = subProgRng.getLength(); fullLen > 0L; fullLen -= (long)len) {
                        len = MathUtilities.unsignedMin((int)data.length, (long)fullLen);
                        try {
                            Address progAddr = progSpace.getAddress(lower);
                            int read = memory.getBytes(progAddr, data, 0, len);
                            if (read < len) {
                                Msg.warn((Object)this, (Object)("  Partial read of " + subProgRng + ". Got " + read + " bytes"));
                            }
                            Address hostAddr = mappedRng.mapDestinationToSource(progAddr);
                            Address guestAddr = this.platform.mapHostToGuest(hostAddr);
                            bytes.putData(guestAddr.getOffset(), data, 0, read);
                        }
                        catch (AddressOutOfBoundsException | MemoryAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                        lower += (long)len;
                    }
                    result = true;
                }
            }
        }
        return result;
    }

    public <T> PcodeTracePropertyAccess<T> getPropertyAccess(String name, Class<T> type) {
        return new DefaultPcodeDebuggerPropertyAccess<T>(this, name, type);
    }
}

