/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import com.google.common.collect.Range;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.HorizontalTabPanel;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.table.GTable;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.RangeTableCellRenderer;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.RowWrappedEnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.DebuggerSnapActionContext;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadActionContext;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerTraceFileActionContext;
import ghidra.app.plugin.core.debug.gui.thread.ThreadRow;
import ghidra.app.plugin.core.debug.gui.thread.ThreadTableColumns;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.database.ObjectKey;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import utilities.util.SuppressableCallback;

public class DebuggerThreadsProvider
extends ComponentProviderAdapter {
    private final DebuggerThreadsPlugin plugin;
    private DebuggerModelService modelService;
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerEmulationService emulationService;
    private final AutoService.Wiring autoWiring;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Trace currentTrace;
    private final SuppressableCallback<Void> cbCoordinateActivation = new SuppressableCallback();
    private final ThreadsListener threadsListener = new ThreadsListener();
    private final CollectionChangeListener<TraceRecorder> recordersListener = new RecordersChangeListener();
    private final DebuggerTraceManagerService.BooleanChangeAdapter activatePresentChangeListener = this::changedAutoActivatePresent;
    private final DebuggerTraceManagerService.BooleanChangeAdapter synchronizeFocusChangeListener = this::changedSynchronizeFocus;
    final RangeTableCellRenderer<Long> rangeRenderer = new RangeTableCellRenderer();
    final RangeCursorTableHeaderRenderer<Long> headerRenderer = new RangeCursorTableHeaderRenderer();
    protected final ThreadTableModel threadTableModel = new ThreadTableModel(this);
    private JPanel mainPanel;
    HorizontalTabPanel<Trace> traceTabs;
    GTable threadTable;
    GhidraTableFilterPanel<ThreadRow> threadFilterPanel;
    JPopupMenu traceTabPopupMenu;
    private ActionContext myActionContext;
    DockingAction actionSaveTrace;
    DockingAction actionStepSnapBackward;
    DockingAction actionEmulateTickBackward;
    DockingAction actionEmulateTickForward;
    DockingAction actionEmulateTickSkipForward;
    DockingAction actionStepSnapForward;
    ToggleDockingAction actionSeekTracePresent;
    ToggleDockingAction actionSyncFocus;
    DockingAction actionGoToTime;
    DockingAction actionCloseTrace;
    DockingAction actionCloseOtherTraces;
    DockingAction actionCloseDeadTraces;
    DockingAction actionCloseAllTraces;
    DebuggerResources.ToToggleSelectionListener toToggleSelectionListener;
    RangeCursorTableHeaderRenderer.SeekListener seekListener;

    protected static long orZero(Long l) {
        return l == null ? 0L : l;
    }

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getRecorder(), b.getRecorder())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getTime(), b.getTime());
    }

    public DebuggerThreadsProvider(DebuggerThreadsPlugin plugin) {
        super(plugin.getTool(), "Threads", plugin.getName());
        this.plugin = plugin;
        this.autoWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_THREADS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_THREADS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), this.current.getViewSnap());
        this.createActions();
        this.contextChanged();
        this.setVisible(true);
    }

    @AutoServiceConsumed
    public void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeTraceRecordersChangedListener(this.recordersListener);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addTraceRecordersChangedListener(this.recordersListener);
        }
    }

    @AutoServiceConsumed
    public void setTraceManager(DebuggerTraceManagerService traceManager) {
        if (this.traceManager != null) {
            this.traceManager.removeAutoActivatePresentChangeListener(this.activatePresentChangeListener);
            this.traceManager.removeSynchronizeFocusChangeListener(this.synchronizeFocusChangeListener);
        }
        this.traceManager = traceManager;
        if (traceManager != null) {
            traceManager.addAutoActivatePresentChangeListener(this.activatePresentChangeListener);
            traceManager.addSynchronizeFocusChangeListener(this.synchronizeFocusChangeListener);
            if (this.actionSeekTracePresent != null) {
                this.actionSeekTracePresent.setSelected(traceManager.isAutoActivatePresent());
            }
            if (this.actionSyncFocus != null) {
                this.actionSyncFocus.setSelected(traceManager.isSynchronizeFocus());
            }
        }
        this.contextChanged();
    }

    @AutoServiceConsumed
    public void setEmulationService(DebuggerEmulationService emulationService) {
        this.contextChanged();
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.threadsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.threadsListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
            this.traceTabs.setSelectedItem((Object)trace);
        }
        this.loadThreads();
    }

    private void doSetThread(TraceThread thread) {
        TraceThread curThread;
        ThreadRow row = (ThreadRow)this.threadFilterPanel.getSelectedItem();
        TraceThread traceThread = curThread = row == null ? null : row.getThread();
        if (curThread == thread) {
            return;
        }
        try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
            if (thread != null) {
                this.threadFilterPanel.setSelectedItem((Object)((ThreadRow)this.threadTableModel.getRow(thread)));
            } else {
                this.threadTable.clearSelection();
            }
        }
    }

    private void doSetSnap(long snap) {
        this.headerRenderer.setCursorPosition((Number)snap);
        this.threadTable.getTableHeader().repaint();
    }

    public void traceOpened(Trace trace) {
        this.traceTabs.addItem((Object)trace);
    }

    public void traceClosed(Trace trace) {
        this.traceTabs.removeItem((Object)trace);
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerThreadsProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.doSetTrace(this.current.getTrace());
        this.doSetThread(this.current.getThread());
        this.doSetSnap(this.current.getSnap());
        this.setSubTitle(this.current.getTime().toString());
        this.contextChanged();
    }

    protected void loadThreads() {
        this.threadTableModel.clear();
        Trace curTrace = this.current.getTrace();
        if (curTrace == null) {
            return;
        }
        TraceThreadManager manager = curTrace.getThreadManager();
        this.threadTableModel.addAllItems(manager.getAllThreads());
        this.updateTimelineMax();
    }

    protected void updateTimelineMax() {
        long max = DebuggerThreadsProvider.orZero(this.current.getTrace().getTimeManager().getMaxSnap());
        Range fullRange = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(max + 1L));
        this.rangeRenderer.setFullRange(fullRange);
        this.headerRenderer.setFullRange(fullRange);
        this.threadTable.getTableHeader().repaint();
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    private void rowActivated(ThreadRow row) {
        if (row == null) {
            return;
        }
        TraceThread thread = row.getThread();
        Trace trace = thread.getTrace();
        TraceRecorder recorder = this.modelService.getRecorder(trace);
        if (recorder == null) {
            return;
        }
        TargetThread targetThread = recorder.getTargetThread(thread);
        if (targetThread == null || !targetThread.isValid()) {
            return;
        }
        DebugModelConventions.requestActivation((TargetObject)targetThread);
    }

    protected void buildMainPanel() {
        this.traceTabPopupMenu = new JPopupMenu("Trace");
        this.mainPanel = new JPanel(new BorderLayout());
        this.threadTable = new GhidraTable((TableModel)((Object)this.threadTableModel));
        this.threadTable.setSelectionMode(0);
        this.mainPanel.add(new JScrollPane((Component)this.threadTable));
        this.threadFilterPanel = new GhidraTableFilterPanel((JTable)this.threadTable, (RowObjectTableModel)this.threadTableModel);
        this.mainPanel.add((Component)this.threadFilterPanel, "South");
        this.threadTable.getSelectionModel().addListSelectionListener(this::threadRowSelected);
        this.threadTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DebuggerThreadsProvider.this.setThreadRowActionContext();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int selectedRow = DebuggerThreadsProvider.this.threadTable.getSelectedRow();
                ThreadRow row = (ThreadRow)DebuggerThreadsProvider.this.threadTableModel.getRowObject(selectedRow);
                DebuggerThreadsProvider.this.rowActivated(row);
            }
        });
        this.traceTabs = new HorizontalTabPanel();
        this.traceTabs.getList().setCellRenderer(new HorizontalTabPanel.TabListCellRenderer<Trace>(){

            protected String getText(Trace value) {
                return value.getName();
            }

            protected Icon getIcon(Trace value) {
                if (DebuggerThreadsProvider.this.modelService == null) {
                    return super.getIcon((Object)value);
                }
                TraceRecorder recorder = DebuggerThreadsProvider.this.modelService.getRecorder(value);
                if (recorder == null || !recorder.isRecording()) {
                    return super.getIcon((Object)value);
                }
                return DebuggerResources.ICON_RECORD;
            }
        });
        JList list = this.traceTabs.getList();
        list.getSelectionModel().addListSelectionListener(this::traceTabSelected);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DebuggerThreadsProvider.this.setTraceTabActionContext(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.mainPanel.add((Component)this.traceTabs, "North");
        TableColumnModel columnModel = this.threadTable.getColumnModel();
        TableColumn colName = columnModel.getColumn(ThreadTableColumns.NAME.ordinal());
        colName.setPreferredWidth(100);
        TableColumn colCreated = columnModel.getColumn(ThreadTableColumns.CREATED.ordinal());
        colCreated.setPreferredWidth(10);
        TableColumn colDestroyed = columnModel.getColumn(ThreadTableColumns.DESTROYED.ordinal());
        colDestroyed.setPreferredWidth(10);
        TableColumn colState = columnModel.getColumn(ThreadTableColumns.STATE.ordinal());
        colState.setPreferredWidth(20);
        TableColumn colComment = columnModel.getColumn(ThreadTableColumns.COMMENT.ordinal());
        colComment.setPreferredWidth(100);
        TableColumn colPlot = columnModel.getColumn(ThreadTableColumns.PLOT.ordinal());
        colPlot.setPreferredWidth(200);
        colPlot.setCellRenderer((TableCellRenderer)this.rangeRenderer);
        colPlot.setHeaderRenderer((TableCellRenderer)this.headerRenderer);
        this.seekListener = pos -> {
            long snap = Math.round(pos);
            if (this.current.getTrace() == null || snap < 0L) {
                snap = 0L;
            }
            this.traceManager.activateSnap(snap);
            this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), snap);
            this.contextChanged();
        };
        this.headerRenderer.addSeekListener(this.seekListener);
    }

    protected void createActions() {
        this.actionStepSnapBackward = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.StepSnapBackwardAction.builder(this.plugin).enabledWhen(this::isStepSnapBackwardEnabled)).enabled(false)).onAction(this::activatedStepSnapBackward)).buildAndInstallLocal((ComponentProvider)this);
        this.actionEmulateTickBackward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulateTickBackwardAction.builder(this.plugin).enabledWhen(this::isEmulateTickBackwardEnabled)).onAction(this::activatedEmulateTickBackward)).buildAndInstallLocal((ComponentProvider)this);
        this.actionEmulateTickForward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulateTickForwardAction.builder(this.plugin).enabledWhen(this::isEmulateTickForwardEnabled)).onAction(this::activatedEmulateTickForward)).buildAndInstallLocal((ComponentProvider)this);
        this.actionEmulateTickSkipForward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulateSkipTickForwardAction.builder(this.plugin).enabledWhen(this::isEmulateSkipTickForwardEnabled)).onAction(this::activatedEmulateSkipTickForward)).buildAndInstallLocal((ComponentProvider)this);
        this.actionStepSnapForward = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.StepSnapForwardAction.builder(this.plugin).enabledWhen(this::isStepSnapForwardEnabled)).enabled(false)).onAction(this::activatedStepSnapForward)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSeekTracePresent = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.SeekTracePresentAction.builder(this.plugin).enabledWhen(this::isSeekTracePresentEnabled)).onAction(this::toggledSeekTracePresent)).selected(this.traceManager == null ? false : this.traceManager.isAutoActivatePresent()).buildAndInstallLocal((ComponentProvider)this);
        this.actionSyncFocus = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.SynchronizeFocusAction.builder(this.plugin).selected(this.traceManager != null && this.traceManager.isSynchronizeFocus()).enabledWhen(c -> this.traceManager != null)).onAction(c -> this.toggleSyncFocus(this.actionSyncFocus.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.actionGoToTime = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.GoToTimeAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> this.activatedGoToTime())).buildAndInstallLocal((ComponentProvider)this);
        this.toToggleSelectionListener = new DebuggerResources.ToToggleSelectionListener(this.actionSyncFocus);
        this.traceManager.addSynchronizeFocusChangeListener(this.toToggleSelectionListener);
        this.actionCloseTrace = (DockingAction)DebuggerResources.CloseTraceAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> c.getTrace() != null).onAction(c -> this.traceManager.closeTrace(c.getTrace())).buildAndInstallLocal((ComponentProvider)this);
        this.actionCloseAllTraces = (DockingAction)DebuggerResources.CloseAllTracesAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> !this.traceManager.getOpenTraces().isEmpty()).onAction(c -> this.traceManager.closeAllTraces()).buildAndInstallLocal((ComponentProvider)this);
        this.actionCloseOtherTraces = (DockingAction)DebuggerResources.CloseOtherTracesAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> this.traceManager.getOpenTraces().size() > 1 && c.getTrace() != null).onAction(c -> this.traceManager.closeOtherTraces(c.getTrace())).buildAndInstallLocal((ComponentProvider)this);
        this.actionCloseDeadTraces = (DockingAction)DebuggerResources.CloseDeadTracesAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> !this.traceManager.getOpenTraces().isEmpty() && this.modelService != null).onAction(c -> this.traceManager.closeDeadTraces()).buildAndInstallLocal((ComponentProvider)this);
    }

    private boolean isStepSnapBackwardEnabled(ActionContext context) {
        if (this.current.getTrace() == null) {
            return false;
        }
        if (!this.current.getTime().isSnapOnly()) {
            return true;
        }
        return this.current.getSnap() > 0L;
    }

    private void activatedStepSnapBackward(ActionContext context) {
        if (this.current.getTime().isSnapOnly()) {
            this.traceManager.activateSnap(this.current.getSnap() - 1L);
        } else {
            this.traceManager.activateSnap(this.current.getSnap());
        }
    }

    private boolean isEmulateTickBackwardEnabled(ActionContext context) {
        if (this.emulationService == null) {
            return false;
        }
        if (this.current.getTrace() == null) {
            return false;
        }
        return this.current.getTime().steppedBackward(this.current.getTrace(), 1L) != null;
    }

    private void activatedEmulateTickBackward(ActionContext context) {
        if (this.current.getTrace() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().steppedBackward(this.current.getTrace(), 1L);
        if (time == null) {
            return;
        }
        this.traceManager.activateTime(time);
    }

    private boolean isEmulateTickForwardEnabled(ActionContext context) {
        if (this.emulationService == null) {
            return false;
        }
        return this.current.getThread() != null;
    }

    private void activatedEmulateTickForward(ActionContext context) {
        if (this.current.getThread() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().steppedForward(this.current.getThread(), 1L);
        this.traceManager.activateTime(time);
    }

    private boolean isEmulateSkipTickForwardEnabled(ActionContext context) {
        if (this.emulationService == null) {
            return false;
        }
        return this.current.getThread() != null;
    }

    private void activatedEmulateSkipTickForward(ActionContext context) {
        if (this.current.getThread() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().skippedForward(this.current.getThread(), 1L);
        this.traceManager.activateTime(time);
    }

    private boolean isStepSnapForwardEnabled(ActionContext context) {
        Trace curTrace = this.current.getTrace();
        if (curTrace == null) {
            return false;
        }
        Long maxSnap = curTrace.getTimeManager().getMaxSnap();
        return maxSnap != null && this.current.getSnap() < maxSnap;
    }

    private void activatedStepSnapForward(ActionContext contetxt) {
        this.traceManager.activateSnap(this.current.getSnap() + 1L);
    }

    private boolean isSeekTracePresentEnabled(ActionContext context) {
        return this.traceManager != null;
    }

    private void toggledSeekTracePresent(ActionContext context) {
        if (this.traceManager == null) {
            return;
        }
        this.traceManager.setAutoActivatePresent(this.actionSeekTracePresent.isSelected());
    }

    private void changedAutoActivatePresent(boolean value) {
        if (this.actionSeekTracePresent == null || this.actionSeekTracePresent.isSelected()) {
            return;
        }
        this.actionSeekTracePresent.setSelected(value);
    }

    private void changedSynchronizeFocus(boolean value) {
        if (this.actionSyncFocus == null || this.actionSyncFocus.isSelected()) {
            return;
        }
        this.actionSyncFocus.setSelected(value);
    }

    private void toggleSyncFocus(boolean enabled) {
        if (this.traceManager == null) {
            return;
        }
        this.traceManager.setSynchronizeFocus(enabled);
    }

    private void activatedGoToTime() {
        InputDialog dialog = new InputDialog("Go To Time", "Schedule:", this.current.getTime().toString());
        this.tool.showDialog((DialogComponentProvider)dialog);
        if (dialog.isCanceled()) {
            return;
        }
        try {
            TraceSchedule time = TraceSchedule.parse((String)dialog.getValue());
            this.traceManager.activateTime(time);
        }
        catch (IllegalArgumentException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Go To Time", (Object)"Could not parse schedule");
        }
    }

    private Trace computeClickedTraceTab(MouseEvent e) {
        JList list = this.traceTabs.getList();
        int i = list.locationToIndex(e.getPoint());
        if (i < 0) {
            return null;
        }
        Rectangle cell = list.getCellBounds(i, i);
        if (!cell.contains(e.getPoint())) {
            return null;
        }
        return (Trace)this.traceTabs.getItem(i);
    }

    private Trace setTraceTabActionContext(MouseEvent e) {
        Trace newTrace = e == null ? (Trace)this.traceTabs.getSelectedItem() : this.computeClickedTraceTab(e);
        this.actionCloseTrace.getPopupMenuData().setMenuItemName("Close " + (newTrace == null ? "..." : newTrace.getName()));
        this.myActionContext = new DebuggerTraceFileActionContext(newTrace);
        this.contextChanged();
        return newTrace;
    }

    private void traceTabSelected(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Trace newTrace = this.setTraceTabActionContext(null);
        this.cbCoordinateActivation.invoke(() -> this.traceManager.activateTrace(newTrace));
    }

    private ThreadRow setThreadRowActionContext() {
        ThreadRow row = (ThreadRow)this.threadFilterPanel.getSelectedItem();
        this.myActionContext = new DebuggerThreadActionContext(this.current.getTrace(), row == null ? null : row.getThread());
        this.contextChanged();
        return row;
    }

    private void threadRowSelected(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ThreadRow row = this.setThreadRowActionContext();
        if (row != null && this.traceManager != null) {
            this.cbCoordinateActivation.invoke(() -> this.traceManager.activateThread(row.getThread()));
        }
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private class ThreadsListener
    extends TraceDomainObjectListener {
        public ThreadsListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.ADDED, this::threadAdded);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.CHANGED, this::threadChanged);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.LIFESPAN_CHANGED, this::threadChanged);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.DELETED, this::threadDeleted);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.ADDED, this::snapAdded);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.DELETED, this::snapDeleted);
        }

        private void objectRestored() {
            DebuggerThreadsProvider.this.loadThreads();
        }

        private void threadAdded(TraceThread thread) {
            DebuggerThreadsProvider.this.threadTableModel.addItem(thread);
        }

        private void threadChanged(TraceThread thread) {
            DebuggerThreadsProvider.this.threadTableModel.updateItem(thread);
        }

        private void threadDeleted(TraceThread thread) {
            DebuggerThreadsProvider.this.threadTableModel.deleteItem(thread);
        }

        private void snapAdded(TraceSnapshot snapshot) {
            DebuggerThreadsProvider.this.updateTimelineMax();
            DebuggerThreadsProvider.this.contextChanged();
        }

        private void snapDeleted() {
            DebuggerThreadsProvider.this.updateTimelineMax();
        }
    }

    private class RecordersChangeListener
    implements CollectionChangeListener<TraceRecorder> {
        private RecordersChangeListener() {
        }

        public void elementAdded(TraceRecorder element) {
            Swing.runIfSwingOrRunLater(() -> DebuggerThreadsProvider.this.traceTabs.repaint());
        }

        public void elementModified(TraceRecorder element) {
            Swing.runIfSwingOrRunLater(() -> DebuggerThreadsProvider.this.traceTabs.repaint());
        }

        public void elementRemoved(TraceRecorder element) {
            Swing.runIfSwingOrRunLater(() -> DebuggerThreadsProvider.this.traceTabs.repaint());
        }
    }

    protected static class ThreadTableModel
    extends RowWrappedEnumeratedColumnTableModel<ThreadTableColumns, ObjectKey, ThreadRow, TraceThread> {
        public ThreadTableModel(DebuggerThreadsProvider provider) {
            super(provider.getTool(), "Threads", ThreadTableColumns.class, TraceUniqueObject::getObjectKey, t -> new ThreadRow(provider.modelService, (TraceThread)t));
        }
    }
}

