/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.dbg.target.TargetObject;
import java.util.Map;

public class ObjectAttributeRow {
    private final TargetObject to;

    public ObjectAttributeRow(TargetObject to, DebuggerObjectsProvider provider) {
        this.to = to;
    }

    public TargetObject getTargetObject() {
        return this.to;
    }

    public String getName() {
        return this.to.getName();
    }

    public String getKind() {
        Map attributes = this.to.getCachedAttributes();
        Object object = attributes.get("_kind");
        if (object != null) {
            return (String)object;
        }
        return this.to.getTypeHint();
    }

    public String getValue() {
        Map attributes = this.to.getCachedAttributes();
        Object object = attributes.get("_value");
        if (object != null) {
            return (String)object;
        }
        return this.to.getDisplay();
    }

    public String getDisplay() {
        String value = this.to.getDisplay();
        if (value.indexOf(":") > 0) {
            value = value.substring(0, value.indexOf(":"));
        }
        return value;
    }

    public String getType() {
        Map attributes = this.to.getCachedAttributes();
        Object object = attributes.get("_type");
        if (object != null) {
            return (String)object;
        }
        return "";
    }
}

