/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import com.google.common.collect.Range;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTableModel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.columns.TracePathLastKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TracePathLastLifespanColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TracePathLastLifespanPlotColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TracePathStringColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TracePathValueColumn;
import ghidra.framework.plugintool.Plugin;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.awt.Color;
import java.util.HashSet;
import java.util.stream.Stream;

public class PathTableModel
extends AbstractQueryTableModel<PathRow> {
    private TracePathValueColumn valueColumn;
    private TracePathLastLifespanPlotColumn lifespanPlotColumn;

    protected static Stream<? extends TraceObjectValPath> distinctKeyPath(Stream<? extends TraceObjectValPath> stream) {
        HashSet seen = new HashSet();
        return stream.filter(path -> seen.add(path.getKeyList()));
    }

    public PathTableModel(Plugin plugin) {
        super("Attribute Model", plugin);
    }

    protected void updateTimelineMax() {
        Long max = this.getTrace() == null ? null : this.getTrace().getTimeManager().getMaxSnap();
        Range fullRange = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(max == null ? 1L : max + 1L));
        this.lifespanPlotColumn.setFullRange((Range<Long>)fullRange);
    }

    @Override
    protected void traceChanged() {
        this.updateTimelineMax();
        super.traceChanged();
    }

    @Override
    protected void showHiddenChanged() {
        this.reload();
        super.showHiddenChanged();
    }

    @Override
    protected void maxSnapChanged() {
        this.updateTimelineMax();
        this.refresh();
    }

    protected static boolean isAnyHidden(TraceObjectValPath path) {
        return path.getEntryList().stream().anyMatch(v -> v.isHidden());
    }

    @Override
    protected Stream<PathRow> streamRows(Trace trace, ModelQuery query, Range<Long> span) {
        return PathTableModel.distinctKeyPath(query.streamPaths(trace, span).filter(p -> this.isShowHidden() || !PathTableModel.isAnyHidden(p))).map(x$0 -> new PathRow((TraceObjectValPath)x$0));
    }

    protected TableColumnDescriptor<PathRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addHiddenColumn((DynamicTableColumn)new TracePathStringColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new TracePathLastKeyColumn());
        this.valueColumn = new TracePathValueColumn();
        descriptor.addVisibleColumn((DynamicTableColumn)this.valueColumn);
        descriptor.addVisibleColumn((DynamicTableColumn)new TracePathLastLifespanColumn());
        this.lifespanPlotColumn = new TracePathLastLifespanPlotColumn();
        descriptor.addHiddenColumn((DynamicTableColumn)this.lifespanPlotColumn);
        return descriptor;
    }

    @Override
    public PathRow findTraceObject(TraceObject object) {
        for (PathRow row : this.getModelData()) {
            if (row.getValue() != object || !row.isLastCanonical()) continue;
            return row;
        }
        return null;
    }

    @Override
    public void setDiffColor(Color diffColor) {
        this.valueColumn.setDiffColor(diffColor);
    }

    @Override
    public void setDiffColorSel(Color diffColorSel) {
        this.valueColumn.setDiffColorSel(diffColorSel);
    }

    @Override
    public void snapChanged() {
        super.snapChanged();
        this.lifespanPlotColumn.setSnap(this.getSnap());
    }

    @Override
    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        this.lifespanPlotColumn.addSeekListener(listener);
    }

    public class PathRow {
        private final TraceObjectValPath path;
        private final Object value;

        public PathRow(TraceObjectValPath path) {
            this.path = path;
            this.value = this.computeValue();
        }

        public TraceObjectValPath getPath() {
            return this.path;
        }

        public Object computeValue() {
            if (this.path.getLastEntry() == null) {
                return PathTableModel.this.getTrace().getObjectManager().getRootObject();
            }
            return this.path.getDestinationValue(null);
        }

        public Object getValue() {
            return this.value;
        }

        public String getDisplay() {
            return PathTableModel.this.display.getEdgeDisplay(this.path.getLastEntry());
        }

        public String getHtmlDisplay() {
            return PathTableModel.this.display.getEdgeHtmlDisplay(this.path.getLastEntry());
        }

        public String getToolTip() {
            return PathTableModel.this.display.getEdgeToolTip(this.path.getLastEntry());
        }

        public boolean isModified() {
            return PathTableModel.this.isValueModified(this.path.getLastEntry());
        }

        public boolean isLastCanonical() {
            TraceObjectValue last = this.path.getLastEntry();
            return last == null || last.isCanonical();
        }
    }
}

