/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import com.google.common.collect.Range;
import ghidra.dbg.util.PathPredicates;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.List;
import java.util.Objects;

public interface DisplaysModified {
    public Trace getTrace();

    public long getSnap();

    public Trace getDiffTrace();

    public long getDiffSnap();

    default public boolean isObjectsDiffer(TraceObject newObject, TraceObject oldObject) {
        if (newObject == oldObject) {
            return false;
        }
        return !Objects.equals(newObject.getCanonicalPath(), oldObject.getCanonicalPath());
    }

    default public boolean isValuesDiffer(Object newValue, Object oldValue) {
        if (newValue instanceof TraceObject && oldValue instanceof TraceObject) {
            return this.isObjectsDiffer((TraceObject)newValue, (TraceObject)oldValue);
        }
        return !Objects.equals(newValue, oldValue);
    }

    default public boolean isEdgesDiffer(TraceObjectValue newEdge, TraceObjectValue oldEdge) {
        if (newEdge == oldEdge) {
            return false;
        }
        if (newEdge == null || oldEdge == null) {
            return true;
        }
        return this.isValuesDiffer(newEdge.getValue(), oldEdge.getValue());
    }

    default public boolean isValueModified(TraceObjectValue value) {
        if (value == null || value.getParent() == null) {
            return false;
        }
        Trace diffTrace = this.getDiffTrace();
        if (diffTrace == null) {
            return false;
        }
        Trace trace = this.getTrace();
        long snap = this.getSnap();
        long diffSnap = this.getDiffSnap();
        if (diffTrace == trace && diffSnap == snap) {
            return false;
        }
        if (diffTrace == trace) {
            boolean oldContains;
            boolean newContains = value.getLifespan().contains((Comparable)Long.valueOf(snap));
            if (newContains == (oldContains = value.getLifespan().contains((Comparable)Long.valueOf(diffSnap)))) {
                return newContains ? this.isEdgesDiffer(value, value) : true;
            }
            TraceObjectValue diffEdge = value.getParent().getValue(diffSnap, value.getEntryKey());
            return this.isEdgesDiffer((TraceObjectValue)(newContains ? value : null), diffEdge);
        }
        TraceObjectValue diffEdge = diffTrace.getObjectManager().getValuePaths(Range.singleton((Comparable)Long.valueOf(diffSnap)), PathPredicates.pattern((List)value.getCanonicalPath().getKeyList())).findAny().map(p -> p.getLastEntry()).orElse(null);
        return this.isEdgesDiffer(value, diffEdge);
    }
}

