/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import com.google.common.collect.Range;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTableModel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.framework.plugintool.Plugin;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractQueryTablePanel<T>
extends JPanel {
    protected final AbstractQueryTableModel<T> tableModel;
    protected final GhidraTable table;
    protected final GhidraTableFilterPanel<T> filterPanel;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected boolean limitToSnap = false;
    protected boolean showHidden = false;

    public AbstractQueryTablePanel(Plugin plugin) {
        super(new BorderLayout());
        this.tableModel = this.createModel(plugin);
        this.table = new GhidraTable(this.tableModel);
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, this.tableModel);
        this.add((Component)new JScrollPane((Component)this.table), "Center");
        this.add((Component)this.filterPanel, "South");
    }

    protected abstract AbstractQueryTableModel<T> createModel(Plugin var1);

    public void goToCoordinates(DebuggerCoordinates coords) {
        if (DebuggerCoordinates.equalsIgnoreRecorderAndView(this.current, coords)) {
            return;
        }
        DebuggerCoordinates previous = this.current;
        this.current = coords;
        if (previous.getSnap() == this.current.getSnap() && previous.getTrace() == this.current.getTrace()) {
            return;
        }
        this.tableModel.setDiffTrace(previous.getTrace());
        this.tableModel.setTrace(this.current.getTrace());
        this.tableModel.setDiffSnap(previous.getSnap());
        this.tableModel.setSnap(this.current.getSnap());
        if (this.limitToSnap) {
            this.tableModel.setSpan((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.current.getSnap())));
        }
    }

    public void reload() {
        this.tableModel.reload();
    }

    public void setQuery(ModelQuery query) {
        this.tableModel.setQuery(query);
    }

    public ModelQuery getQuery() {
        return this.tableModel.getQuery();
    }

    public void setLimitToSnap(boolean limitToSnap) {
        if (this.limitToSnap == limitToSnap) {
            return;
        }
        this.limitToSnap = limitToSnap;
        this.tableModel.setSpan((Range<Long>)(limitToSnap ? Range.singleton((Comparable)Long.valueOf(this.current.getSnap())) : Range.all()));
    }

    public boolean isLimitToSnap() {
        return this.limitToSnap;
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.showHidden = showHidden;
        this.tableModel.setShowHidden(showHidden);
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().removeListSelectionListener(listener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.table.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.table.removeMouseListener(l);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.table.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.table.removeKeyListener(l);
    }

    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        this.tableModel.addSeekListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        this.table.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    public void setSelectedItem(T item) {
        this.filterPanel.setSelectedItem(item);
    }

    public boolean trySelect(TraceObject object) {
        T t = this.tableModel.findTraceObject(object);
        if (t == null) {
            return false;
        }
        this.setSelectedItem(t);
        return true;
    }

    public List<T> getSelectedItems() {
        return this.filterPanel.getSelectedItems();
    }

    public T getSelectedItem() {
        return (T)this.filterPanel.getSelectedItem();
    }

    public void setDiffColor(Color diffColor) {
        this.tableModel.setDiffColor(diffColor);
    }

    public void setDiffColorSel(Color diffColorSel) {
        this.tableModel.setDiffColorSel(diffColorSel);
    }
}

