/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.editing;

import docking.Tool;
import docking.action.builder.MultiStateActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.DebuggerStateEditingService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Trace;

@PluginInfo(shortDescription="Debugger machine-state Editing GUI", description="GUI to edit target, trace, and/or emulation machine state", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerStateEditingService.class})
public class DebuggerStateEditingPlugin
extends AbstractDebuggerPlugin {
    private final DebuggerStateEditingService.StateEditingModeChangeListener listenerForModeChanges = this::modeChanged;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected MultiStateDockingAction<DebuggerStateEditingService.StateEditingMode> actionEditMode;
    private DebuggerStateEditingService editingService;

    public DebuggerStateEditingPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    protected void createActions() {
        this.actionEditMode = (MultiStateDockingAction)((MultiStateActionBuilder)((MultiStateActionBuilder)DebuggerResources.EditModeAction.builder(this).enabled(false)).enabledWhen(c -> this.current.getTrace() != null)).onActionStateChanged(this::activateEditMode).buildAndInstall((Tool)this.tool);
    }

    protected void activateEditMode(ActionState<DebuggerStateEditingService.StateEditingMode> state, EventTrigger trigger) {
        if (this.current.getTrace() == null) {
            return;
        }
        if (this.editingService == null) {
            return;
        }
        this.editingService.setCurrentMode(this.current.getTrace(), (DebuggerStateEditingService.StateEditingMode)((Object)state.getUserData()));
    }

    private void modeChanged(Trace trace, DebuggerStateEditingService.StateEditingMode mode) {
        if (this.current.getTrace() == trace) {
            this.refreshActionMode();
        }
    }

    protected void coordinatesActivated(DebuggerCoordinates coords) {
        this.current = coords;
        this.refreshActionMode();
    }

    private DebuggerStateEditingService.StateEditingMode computeCurrentEditingMode() {
        if (this.editingService == null) {
            return DebuggerStateEditingService.StateEditingMode.READ_ONLY;
        }
        if (this.current.getTrace() == null) {
            return DebuggerStateEditingService.StateEditingMode.READ_ONLY;
        }
        return this.editingService.getCurrentMode(this.current.getTrace());
    }

    private void refreshActionMode() {
        this.actionEditMode.setCurrentActionStateByUserData((Object)this.computeCurrentEditingMode());
    }

    protected void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.current = DebuggerCoordinates.NOWHERE;
        }
        this.refreshActionMode();
    }

    @AutoServiceConsumed
    protected void setEditingService(DebuggerStateEditingService editingService) {
        if (this.editingService != null) {
            this.editingService.removeModeChangeListener(this.listenerForModeChanges);
        }
        this.editingService = editingService;
        if (this.editingService != null) {
            this.editingService.addModeChangeListener(this.listenerForModeChanges);
        }
        this.refreshActionMode();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
    }
}

