/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import docking.DialogComponentProvider;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.EnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceSection;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DebuggerBlockChooserDialog
extends DialogComponentProvider {
    final EnumeratedColumnTableModel<MemoryBlockRow> tableModel;
    GTable table;
    GhidraTableFilterPanel<MemoryBlockRow> filterPanel;
    private Map.Entry<Program, MemoryBlock> chosen;

    public DebuggerBlockChooserDialog(PluginTool tool) {
        super("Memory Blocks", true, true, true, false);
        this.tableModel = new DefaultEnumeratedColumnTableModel(tool, "Blocks", MemoryBlockTableColumns.class);
        this.populateComponents();
    }

    public EnumeratedColumnTableModel<MemoryBlockRow> getTableModel() {
        return this.tableModel;
    }

    public GhidraTableFilterPanel<MemoryBlockRow> getTableFilterPanel() {
        return this.filterPanel;
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.table = new GTable(this.tableModel);
        this.table.setSelectionMode(0);
        panel.add(new JScrollPane((Component)this.table));
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, this.tableModel);
        panel.add((Component)this.filterPanel, "South");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.table.getSelectionModel().addListSelectionListener(evt -> this.okButton.setEnabled(this.filterPanel.getSelectedItems().size() == 1));
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn startCol = columnModel.getColumn(MemoryBlockTableColumns.START.ordinal());
        startCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn endCol = columnModel.getColumn(MemoryBlockTableColumns.END.ordinal());
        endCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lenCol = columnModel.getColumn(MemoryBlockTableColumns.LENGTH.ordinal());
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    public Map.Entry<Program, MemoryBlock> chooseBlock(PluginTool tool, TraceSection section, Collection<Program> programs) {
        DebuggerStaticMappingService service = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
        return this.chooseBlock(tool, programs, (MemoryBlockRow rec) -> rec.score(section, service));
    }

    public Map.Entry<Program, MemoryBlock> chooseBlock(PluginTool tool, TraceMemoryRegion region, Collection<Program> programs) {
        DebuggerStaticMappingService service = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
        return this.chooseBlock(tool, programs, (MemoryBlockRow rec) -> rec.score(region, service));
    }

    protected Map.Entry<Program, MemoryBlock> chooseBlock(PluginTool tool, Collection<Program> programs, Function<MemoryBlockRow, Double> scorer) {
        this.setBlocksFromPrograms(programs);
        this.computeScores(scorer);
        this.selectHighestScoringBlock();
        tool.showDialog((DialogComponentProvider)this);
        return this.getChosen();
    }

    protected void computeScores(Function<MemoryBlockRow, Double> scorer) {
        for (MemoryBlockRow rec : this.tableModel.getModelData()) {
            scorer.apply(rec);
        }
    }

    protected void setBlocksFromPrograms(Collection<Program> programs) {
        this.tableModel.clear();
        ArrayList<MemoryBlockRow> rows = new ArrayList<MemoryBlockRow>();
        for (Program program : programs) {
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                rows.add(new MemoryBlockRow(program, block));
            }
        }
        this.tableModel.addAll(rows);
    }

    protected void selectHighestScoringBlock() {
        MemoryBlockRow best = null;
        for (MemoryBlockRow rec : this.tableModel.getModelData()) {
            if (best != null && !(rec.getScore() > best.getScore())) continue;
            best = rec;
        }
        if (best != null) {
            this.filterPanel.setSelectedItem(best);
        }
    }

    protected void okCallback() {
        MemoryBlockRow sel = (MemoryBlockRow)this.filterPanel.getSelectedItem();
        this.chosen = sel == null ? null : Map.entry(sel.program, sel.block);
        this.close();
    }

    protected void cancelCallback() {
        this.chosen = null;
        this.close();
    }

    public Map.Entry<Program, MemoryBlock> getChosen() {
        return this.chosen;
    }

    static enum MemoryBlockTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<MemoryBlockTableColumns, MemoryBlockRow>
    {
        SCORE("Score", Double.class, MemoryBlockRow::getScore, ColumnSortState.SortDirection.DESCENDING),
        PROGRAM("Program", String.class, MemoryBlockRow::getProgramName, ColumnSortState.SortDirection.ASCENDING),
        BLOCK("Block", String.class, MemoryBlockRow::getBlockName, ColumnSortState.SortDirection.ASCENDING),
        START("Start Address", Address.class, MemoryBlockRow::getMinAddress, ColumnSortState.SortDirection.ASCENDING),
        END("End Address", Address.class, MemoryBlockRow::getMaxAddress, ColumnSortState.SortDirection.ASCENDING),
        LENGTH("Length", Long.class, MemoryBlockRow::getLength, ColumnSortState.SortDirection.ASCENDING);

        private final String header;
        private final Function<MemoryBlockRow, ?> getter;
        private final Class<?> cls;
        private final ColumnSortState.SortDirection dir;

        private <T> MemoryBlockTableColumns(String header, Class<T> cls, Function<MemoryBlockRow, T> getter, ColumnSortState.SortDirection dir) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.dir = dir;
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(MemoryBlockRow row) {
            return this.getter.apply(row);
        }

        public ColumnSortState.SortDirection defaultSortDirection() {
            return this.dir;
        }
    }

    public static class MemoryBlockRow {
        private final Program program;
        private final MemoryBlock block;
        private double score;

        protected MemoryBlockRow(Program program, MemoryBlock block) {
            this.program = program;
            this.block = block;
        }

        public Program getProgram() {
            return this.program;
        }

        public MemoryBlock getBlock() {
            return this.block;
        }

        public String getProgramName() {
            return this.program.getName();
        }

        public String getBlockName() {
            return this.block.getName();
        }

        public Address getMinAddress() {
            return this.block.getStart();
        }

        public Address getMaxAddress() {
            return this.block.getEnd();
        }

        public long getLength() {
            return this.block.getSize();
        }

        public double getScore() {
            return this.score;
        }

        public double score(TraceSection section, DebuggerStaticMappingService service) {
            if (section == null) {
                this.score = 0.0;
                return 0.0;
            }
            this.score = service.proposeSectionMap(section, this.program, this.block).computeScore();
            return this.score;
        }

        public double score(TraceMemoryRegion region, DebuggerStaticMappingService service) {
            if (region == null) {
                this.score = 0.0;
                return 0.0;
            }
            this.score = service.proposeRegionMap(region, this.program, this.block).computeScore();
            return this.score;
        }

        public ProgramLocation getProgramLocation() {
            return new ProgramLocation(this.program, this.block.getStart());
        }
    }
}

