/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import docking.DialogComponentProvider;
import docking.widgets.table.EnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public abstract class AbstractDebuggerMapProposalDialog<R>
extends DialogComponentProvider {
    protected final EnumeratedColumnTableModel<R> tableModel;
    protected GTable table;
    protected GhidraTableFilterPanel<R> filterPanel;
    private Collection<R> adjusted;

    protected AbstractDebuggerMapProposalDialog(PluginTool tool, String title) {
        super(title, true, true, true, false);
        this.tableModel = this.createTableModel(tool);
        this.populateComponents();
    }

    protected abstract EnumeratedColumnTableModel<R> createTableModel(PluginTool var1);

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.table = new GTable(this.tableModel);
        this.table.setSelectionMode(0);
        panel.add(new JScrollPane((Component)this.table));
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, this.tableModel);
        panel.add((Component)this.filterPanel, "South");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.createActions();
    }

    public GTable getTable() {
        return this.table;
    }

    public EnumeratedColumnTableModel<R> getTableModel() {
        return this.tableModel;
    }

    protected void removeEntry(R entry) {
        this.tableModel.delete(entry);
    }

    protected void createActions() {
    }

    protected void okCallback() {
        this.adjusted = this.tableModel.getModelData();
        this.close();
    }

    protected void cancelCallback() {
        this.adjusted = null;
        this.close();
    }

    public Collection<R> getAdjusted() {
        return this.adjusted;
    }

    public Collection<R> adjustCollection(PluginTool tool, Collection<R> collection) {
        this.tableModel.clear();
        this.tableModel.addAll(collection);
        tool.showDialog((DialogComponentProvider)this);
        return this.getAdjusted();
    }
}

