/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.filter.MultitermEvaluationMode;
import docking.widgets.filter.TextFilter;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.FilterTransformer;
import java.util.List;

public class MultiTextFilterTreeFilter
implements GTreeFilter {
    private final List<TextFilter> filters;
    private final FilterTransformer<GTreeNode> transformer;
    private final MultitermEvaluationMode evalMode;

    public MultiTextFilterTreeFilter(List<TextFilter> filters, FilterTransformer<GTreeNode> transformer, MultitermEvaluationMode evalMode) {
        this.filters = filters;
        this.transformer = transformer;
        this.evalMode = evalMode;
    }

    @Override
    public boolean acceptsNode(GTreeNode node) {
        if (this.filters.isEmpty()) {
            return true;
        }
        List nodeData = this.transformer.transform((Object)node);
        if (this.evalMode == MultitermEvaluationMode.AND) {
            return this.filters.parallelStream().map(f -> MultiTextFilterTreeFilter.matches(f, nodeData)).allMatch(m -> m == true);
        }
        return this.filters.parallelStream().map(f -> MultiTextFilterTreeFilter.matches(f, nodeData)).anyMatch(m -> m == true);
    }

    @Override
    public boolean showFilterMatches() {
        return true;
    }

    private static boolean matches(TextFilter filter, List<String> nodeData) {
        return nodeData.parallelStream().map(data -> filter.matches((String)data)).anyMatch(r -> r == true);
    }
}

