/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.action.ToolBarData;
import docking.menu.DockingToolBarUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ToolBarItemManager
implements PropertyChangeListener,
ActionListener,
MouseListener {
    private DockingActionIf toolBarAction;
    private JButton toolBarButton;
    private final DockingWindowManager windowManager;

    public ToolBarItemManager(DockingActionIf action, DockingWindowManager windowManager) {
        this.toolBarAction = action;
        this.windowManager = windowManager;
        action.addPropertyChangeListener(this);
    }

    String getGroup() {
        return this.toolBarAction.getToolBarData().getToolBarGroup();
    }

    public JButton getButton() {
        if (this.toolBarButton == null) {
            this.toolBarButton = this.createButton(this.toolBarAction);
            this.toolBarButton.setEnabled(this.toolBarAction.isEnabled());
        }
        return this.toolBarButton;
    }

    public JButton createButton(DockingActionIf action) {
        JButton button = action.createButton();
        button.addActionListener(this);
        button.addMouseListener(this);
        button.setName(action.getName());
        DockingToolBarUtils.setToolTipText(button, action);
        return button;
    }

    public DockingActionIf getAction() {
        return this.toolBarAction;
    }

    void dispose() {
        this.toolBarAction.removePropertyChangeListener(this);
        if (this.toolBarButton != null) {
            this.toolBarButton.removeActionListener(this);
            this.toolBarButton = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.toolBarButton == null) {
            return;
        }
        String name = e.getPropertyName();
        if (name.equals("enabled")) {
            this.toolBarButton.setEnabled((Boolean)e.getNewValue());
        } else if (name.equals("description")) {
            DockingToolBarUtils.setToolTipText(this.toolBarButton, this.toolBarAction);
        } else if (name.equals("ToolBar")) {
            ToolBarData toolBarData = (ToolBarData)e.getNewValue();
            this.toolBarButton.setIcon(toolBarData == null ? null : toolBarData.getIcon());
        } else if (name.equals("selectState")) {
            this.toolBarButton.setSelected((Boolean)e.getNewValue());
        } else if (name.equals("KeyBindings")) {
            DockingToolBarUtils.setToolTipText(this.toolBarButton, this.toolBarAction);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DockingWindowManager.clearMouseOverHelp();
        ActionContext context = this.getActionContext();
        context.setSourceObject(event.getSource());
        context.setEventClickModifiers(event.getModifiers());
        SwingUtilities.invokeLater(() -> {
            if (this.toolBarAction.isValidContext(context) && this.toolBarAction.isEnabledForContext(context)) {
                if (this.toolBarAction instanceof ToggleDockingActionIf) {
                    ToggleDockingActionIf toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)this.toolBarAction).isSelected());
                }
                this.toolBarAction.actionPerformed(context);
            }
        });
    }

    private ActionContext getActionContext() {
        if (this.windowManager != null) {
            return this.windowManager.getActionContext(this.toolBarAction);
        }
        ComponentProvider provider = this.getComponentProvider();
        ActionContext context = provider == null ? null : provider.getActionContext(null);
        ActionContext actionContext = context == null ? new ActionContext(provider, null) : context;
        return actionContext;
    }

    public String toString() {
        return this.toolBarAction.getName();
    }

    private ComponentProvider getComponentProvider() {
        DockingWindowManager manager = this.windowManager;
        if (manager == null) {
            manager = DockingWindowManager.getActiveInstance();
        }
        return manager.getActiveComponentProvider();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        DockingWindowManager.setMouseOverAction(this.toolBarAction);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        DockingWindowManager.clearMouseOverHelp();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

