/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbInferiorThreadGroup;
import agent.gdb.manager.GdbManager;
import agent.gdb.manager.GdbModule;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbMemoryMapping;
import agent.gdb.manager.impl.GdbModuleImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.GdbAttachCommand;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import agent.gdb.manager.impl.cmd.GdbContinueCommand;
import agent.gdb.manager.impl.cmd.GdbDetachCommand;
import agent.gdb.manager.impl.cmd.GdbEvaluateCommand;
import agent.gdb.manager.impl.cmd.GdbFileExecAndSymbolsCommand;
import agent.gdb.manager.impl.cmd.GdbGetVarCommand;
import agent.gdb.manager.impl.cmd.GdbKillCommand;
import agent.gdb.manager.impl.cmd.GdbListThreadsCommand;
import agent.gdb.manager.impl.cmd.GdbReadMemoryCommand;
import agent.gdb.manager.impl.cmd.GdbRunCommand;
import agent.gdb.manager.impl.cmd.GdbSetInferiorTtyCommand;
import agent.gdb.manager.impl.cmd.GdbSetVarCommand;
import agent.gdb.manager.impl.cmd.GdbStartCommand;
import agent.gdb.manager.impl.cmd.GdbStartInstructionCommand;
import agent.gdb.manager.impl.cmd.GdbStepCommand;
import agent.gdb.manager.impl.cmd.GdbWriteMemoryCommand;
import com.google.common.collect.RangeSet;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GdbInferiorImpl
implements GdbInferior {
    protected static final Pattern MEMORY_MAPPING_WOUT_FLAGS_LINE_PATTERN = Pattern.compile("\\s*0x(?<start>[0-9,A-F,a-f]+)\\s+0x(?<end>[0-9,A-F,a-f]+)\\s+0x(?<size>[0-9,A-F,a-f]+)\\s+0x(?<offset>[0-9,A-F,a-f]+)\\s+(?<file>\\S*)\\s*");
    protected static final Pattern MEMORY_MAPPING_LINE_PATTERN = Pattern.compile("\\s*0x(?<start>[0-9,A-F,a-f]+)\\s+0x(?<end>[0-9,A-F,a-f]+)\\s+0x(?<size>[0-9,A-F,a-f]+)\\s+0x(?<offset>[0-9,A-F,a-f]+)\\s+(?<flags>[rwsxp\\-]+)\\s+(?<file>\\S*)\\s*");
    protected final GdbManagerImpl manager;
    private final int id;
    private Long pid;
    private Long exitCode;
    private String executable;
    private ByteOrder endianness;
    private final Map<Integer, GdbThreadImpl> threads = new LinkedHashMap<Integer, GdbThreadImpl>();
    private final Map<Integer, GdbThread> unmodifiableThreads = Collections.unmodifiableMap(this.threads);
    private final Map<String, GdbModuleImpl> modules = new LinkedHashMap<String, GdbModuleImpl>();
    private final Map<String, GdbModule> unmodifiableModules = Collections.unmodifiableMap(this.modules);
    private final NavigableMap<BigInteger, GdbMemoryMapping> mappings = new TreeMap<BigInteger, GdbMemoryMapping>();
    private final NavigableMap<BigInteger, GdbMemoryMapping> unmodifiableMappings = Collections.unmodifiableNavigableMap(this.mappings);

    public GdbInferiorImpl(GdbManagerImpl manager, int id) {
        this.manager = manager;
        this.id = id;
    }

    public GdbInferiorImpl(GdbManagerImpl manager, GdbInferiorThreadGroup g) {
        this(manager, g.getInferiorId());
        this.update(g);
    }

    public void update(GdbInferiorThreadGroup g) {
        Long oldPid = this.pid;
        this.pid = g.getPid();
        this.exitCode = g.getExitCode();
        this.executable = g.getExecutable();
        if (oldPid == null && this.pid != null) {
            this.manager.fireInferiorStarted(this, GdbCause.Causes.UNCLAIMED, "resyncInferiorStarted");
        }
    }

    public String toString() {
        return "<GdbInferior id=" + this.id + ",pid=" + this.pid + ",exitCode=" + this.exitCode + ",executable=" + this.executable + ">";
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    @Override
    public Long getPid() {
        return this.pid;
    }

    public void setExitCode(Long exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public Long getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    public void add(GdbCause cause) {
        this.manager.addInferior(this, cause);
    }

    public void remove(GdbCause cause) {
        this.manager.removeInferior(this.id, cause);
    }

    public void addThread(GdbThreadImpl thread) {
        GdbThreadImpl exists = this.threads.get(thread.getId());
        if (exists != null) {
            throw new IllegalArgumentException("There is already thread " + exists);
        }
        this.threads.put(thread.getId(), thread);
    }

    @Override
    public GdbThreadImpl getThread(int tid) {
        GdbThreadImpl result = this.threads.get(tid);
        if (result == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
        return result;
    }

    public void removeThread(int tid) {
        if (this.threads.remove(tid) == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
    }

    @Override
    public Map<Integer, GdbThread> getKnownThreads() {
        return this.unmodifiableThreads;
    }

    public Map<Integer, GdbThreadImpl> getKnownThreadsImpl() {
        return this.threads;
    }

    protected <T> CompletableFuture<T> execute(GdbCommand<? extends T> cmd) {
        return this.setActive(true).thenCombine(this.manager.execute(cmd), (s, e) -> e);
    }

    @Override
    public CompletableFuture<Map<Integer, GdbThread>> listThreads() {
        return this.execute(new GdbListThreadsCommand(this.manager, this));
    }

    @Override
    public Map<String, GdbModule> getKnownModules() {
        return this.unmodifiableModules;
    }

    @Override
    public CompletableFuture<Map<String, GdbModule>> listModules() {
        return this.manager.execMaintInfoSectionsAllObjects(this).thenApply(lines -> this.parseModuleNames((String[])lines));
    }

    protected CompletableFuture<Void> doLoadSections() {
        return this.manager.execMaintInfoSectionsAllObjects(this).thenAccept(lines -> this.parseAndUpdateAllModuleSections((String[])lines));
    }

    protected GdbModuleImpl resyncCreateModule(String name) {
        Msg.warn((Object)this, (Object)("Resync: Missed loaded module/library: " + name));
        return this.createModule(name);
    }

    protected GdbModuleImpl createModule(String name) {
        return new GdbModuleImpl(this, name);
    }

    protected void libraryLoaded(String name) {
        this.modules.computeIfAbsent(name, this::createModule);
    }

    protected void libraryUnloaded(String name) {
        this.modules.remove(name);
    }

    protected void resyncRetainModules(Set<String> names) {
        for (Map.Entry<String, GdbModuleImpl> ent : this.modules.entrySet()) {
            if (names.contains(ent.getKey())) continue;
            Msg.warn((Object)this, (Object)("Resync: Missed unloaded module/library: " + ent));
        }
    }

    protected String nameFromLine(String line) {
        Matcher nameMatcher = this.manager.matchFileLine(line);
        if (nameMatcher == null) {
            return null;
        }
        String name = nameMatcher.group("name");
        if (name.startsWith(".gnu_debugdata for ")) {
            return null;
        }
        return name;
    }

    protected void parseAndUpdateAllModuleSections(String[] lines) {
        HashSet<String> namesSeen = new HashSet<String>();
        GdbModuleImpl curModule = null;
        for (String line : lines) {
            String name = this.nameFromLine(line);
            if (name != null) {
                if (curModule != null) {
                    curModule.loadSections.provide().complete(null);
                }
                namesSeen.add(name);
                curModule = this.modules.computeIfAbsent(name, this::resyncCreateModule);
                if (!curModule.loadSections.isDone()) continue;
                curModule = null;
                continue;
            }
            if (curModule == null) continue;
            curModule.processSectionLine(line);
        }
        if (curModule != null) {
            curModule.loadSections.provide().complete(null);
        }
        this.resyncRetainModules(namesSeen);
    }

    protected Map<String, GdbModule> parseModuleNames(String[] lines) {
        HashSet<String> namesSeen = new HashSet<String>();
        for (String line : lines) {
            String name = this.nameFromLine(line);
            if (name == null) continue;
            namesSeen.add(name);
            this.modules.computeIfAbsent(name, this::resyncCreateModule);
        }
        this.resyncRetainModules(namesSeen);
        return this.unmodifiableModules;
    }

    @Override
    public Map<BigInteger, GdbMemoryMapping> getKnownMappings() {
        return this.unmodifiableMappings;
    }

    @Override
    public CompletableFuture<Map<BigInteger, GdbMemoryMapping>> listMappings() {
        return this.consoleCapture("info proc mappings", GdbConsoleExecCommand.CompletesWithRunning.CANNOT).thenApply(this::parseMappings);
    }

    protected GdbMemoryMapping parseMappingLine(String line) throws NumberFormatException {
        Matcher mappingMatcher = MEMORY_MAPPING_LINE_PATTERN.matcher(line);
        if (!mappingMatcher.matches()) {
            return null;
        }
        BigInteger start = new BigInteger(mappingMatcher.group("start"), 16);
        BigInteger end = new BigInteger(mappingMatcher.group("end"), 16);
        BigInteger size = new BigInteger(mappingMatcher.group("size"), 16);
        BigInteger offset = new BigInteger(mappingMatcher.group("offset"), 16);
        String flags = mappingMatcher.group("flags");
        String objfile = mappingMatcher.group("file");
        return new GdbMemoryMapping(start, end, size, offset, flags, objfile);
    }

    protected GdbMemoryMapping parseMappingsLineWOutFlags(String line) throws NumberFormatException {
        Matcher mappingMatcher = MEMORY_MAPPING_WOUT_FLAGS_LINE_PATTERN.matcher(line);
        if (!mappingMatcher.matches()) {
            return null;
        }
        BigInteger start = new BigInteger(mappingMatcher.group("start"), 16);
        BigInteger end = new BigInteger(mappingMatcher.group("end"), 16);
        BigInteger size = new BigInteger(mappingMatcher.group("size"), 16);
        BigInteger offset = new BigInteger(mappingMatcher.group("offset"), 16);
        String objfile = mappingMatcher.group("file");
        return new GdbMemoryMapping(start, end, size, offset, "rwx", objfile);
    }

    protected Map<BigInteger, GdbMemoryMapping> parseMappings(String out) {
        TreeSet<BigInteger> startsSeen = new TreeSet<BigInteger>();
        for (String line : out.split("\n")) {
            try {
                GdbMemoryMapping mapping = this.parseMappingLine(line);
                if (mapping == null) {
                    mapping = this.parseMappingsLineWOutFlags(line);
                }
                if (mapping == null) continue;
                startsSeen.add(mapping.getStart());
                this.mappings.put(mapping.getStart(), mapping);
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Could not parse mapping entry: " + line), (Throwable)e);
            }
        }
        this.mappings.keySet().retainAll(startsSeen);
        return this.unmodifiableMappings;
    }

    @Override
    public CompletableFuture<Void> setActive(boolean internal) {
        return this.manager.setActiveInferior(this, internal);
    }

    @Override
    public CompletableFuture<Void> fileExecAndSymbols(String file) {
        return this.execute(new GdbFileExecAndSymbolsCommand(this.manager, file));
    }

    @Override
    public CompletableFuture<GdbThread> run() {
        return this.execute(new GdbRunCommand(this.manager));
    }

    @Override
    public CompletableFuture<GdbThread> start() {
        return this.execute(new GdbStartCommand(this.manager));
    }

    @Override
    public CompletableFuture<GdbThread> starti() {
        return this.execute(new GdbStartInstructionCommand(this.manager));
    }

    @Override
    public CompletableFuture<Set<GdbThread>> attach(long toPid) {
        return this.execute(new GdbAttachCommand(this.manager, toPid));
    }

    @Override
    public CompletableFuture<Void> console(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.execute(new GdbConsoleExecCommand(this.manager, null, null, command, GdbConsoleExecCommand.Output.CONSOLE, cwr)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.execute(new GdbConsoleExecCommand(this.manager, null, null, command, GdbConsoleExecCommand.Output.CAPTURE, cwr));
    }

    @Override
    public CompletableFuture<Void> cont() {
        return this.execute(new GdbContinueCommand(this.manager, null));
    }

    @Override
    public CompletableFuture<Void> step(GdbManager.StepCmd suffix) {
        return this.execute(new GdbStepCommand(this.manager, null, suffix));
    }

    @Override
    public CompletableFuture<String> evaluate(String expression) {
        return this.execute(new GdbEvaluateCommand(this.manager, null, null, expression));
    }

    @Override
    public CompletableFuture<Void> setTty(String tty) {
        return this.execute(new GdbSetInferiorTtyCommand(this.manager, tty));
    }

    @Override
    public CompletableFuture<String> getVar(String varName) {
        return this.execute(new GdbGetVarCommand(this.manager, varName));
    }

    @Override
    public CompletableFuture<Void> setVar(String varName, String val) {
        return this.execute(new GdbSetVarCommand(this.manager, null, varName, val));
    }

    @Override
    public CompletableFuture<Void> detach() {
        return this.execute(new GdbDetachCommand(this.manager, this, null));
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.execute(new GdbKillCommand(this.manager, null));
    }

    @Override
    public CompletableFuture<RangeSet<Long>> readMemory(long addr, ByteBuffer buf, int len) {
        return this.execute(new GdbReadMemoryCommand(this.manager, null, addr, buf, len));
    }

    @Override
    public CompletableFuture<Void> writeMemory(long addr, ByteBuffer buf, int len) {
        return this.execute(new GdbWriteMemoryCommand(this.manager, null, addr, buf, len));
    }

    @Override
    public CompletableFuture<Void> remove() {
        return this.manager.removeInferior(this);
    }

    @Override
    public String getDescriptor() {
        if (this.pid != null) {
            return "process " + this.pid;
        }
        return "<null>";
    }

    @Internal
    public CompletableFuture<Void> syncEndianness() {
        return this.consoleCapture("show endian", GdbConsoleExecCommand.CompletesWithRunning.CANNOT).thenAccept(out -> {
            this.endianness = out.toLowerCase().contains("little endian") ? ByteOrder.LITTLE_ENDIAN : (out.toLowerCase().contains("big endian") ? ByteOrder.BIG_ENDIAN : null);
        });
    }

    @Internal
    public ByteOrder getEndianness() {
        if (this.endianness == null) {
            throw new AssertionError((Object)"Could not determine target endianness");
        }
        return this.endianness;
    }
}

