/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.ByteArray;
import SWIG.SBError;
import SWIG.SBProcess;
import SWIG.SBStream;
import SWIG.SWIGTYPE_p_void;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class LldbReadMemoryCommand
extends AbstractLldbCommand<RangeSet<Long>> {
    private final SBProcess process;
    private final Address addr;
    private final ByteBuffer buf;
    private final int len;

    public LldbReadMemoryCommand(LldbManagerImpl manager, SBProcess process, Address addr, ByteBuffer buf, int len) {
        super(manager);
        this.process = process;
        this.addr = addr;
        this.buf = buf;
        this.len = len;
    }

    @Override
    public RangeSet<Long> complete(LldbPendingCommand<?> pending) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Long.valueOf(this.addr.getOffset()), (Comparable)Long.valueOf(this.addr.getOffset() + (long)this.len)));
        return rangeSet;
    }

    @Override
    public void invoke() {
        BigInteger offset = this.addr.getOffsetAsBigInteger();
        SBError error = new SBError();
        ByteArray buffer = new ByteArray(this.len);
        long read = this.process.ReadMemory(offset, (SWIGTYPE_p_void)buffer, (long)this.len, error);
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)(error.GetType() + ":" + stream.GetData()));
            return;
        }
        int i = 0;
        while ((long)i < read) {
            this.buf.put(i, buffer.getitem(i));
            ++i;
        }
        buffer.delete();
    }
}

