/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBBreakpoint;
import SWIG.SBBreakpointLocation;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.HashMap;
import java.util.Map;

public class LldbListBreakpointLocationsCommand
extends AbstractLldbCommand<Map<String, SBBreakpointLocation>> {
    private Map<String, SBBreakpointLocation> updatedLocations = new HashMap<String, SBBreakpointLocation>();
    protected final SBBreakpoint spec;

    public LldbListBreakpointLocationsCommand(LldbManagerImpl manager, SBBreakpoint spec) {
        super(manager);
        this.spec = spec;
    }

    @Override
    public Map<String, SBBreakpointLocation> complete(LldbPendingCommand<?> pending) {
        return this.updatedLocations;
    }

    @Override
    public void invoke() {
        this.updatedLocations.clear();
        long n = this.spec.GetNumResolvedLocations();
        int i = 0;
        while ((long)i < n) {
            SBBreakpointLocation loc = this.spec.GetLocationAtIndex((long)i);
            this.updatedLocations.put(DebugClient.getId(loc), loc);
            ++i;
        }
    }
}

