/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.program.database.data.PointerTypedefInspector;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicode32DataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Unicode32DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.PartialUnion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class PcodeDataTypeManager {
    private Program program;
    private DataTypeManager progDataTypes;
    private DataTypeManager builtInDataTypes = BuiltInDataTypeManager.getDataTypeManager();
    private DataOrganization dataOrganization;
    private DecompilerLanguage displayLanguage;
    private boolean voidInputIsVarargs;
    private TypeMap[] coreBuiltin;
    private VoidDataType voidDt;
    private int pointerWordSize;

    public PcodeDataTypeManager(Program prog) {
        this.program = prog;
        this.progDataTypes = prog.getDataTypeManager();
        this.dataOrganization = this.progDataTypes.getDataOrganization();
        this.voidInputIsVarargs = true;
        this.displayLanguage = prog.getCompilerSpec().getDecompilerOutputLanguage();
        if (this.displayLanguage != DecompilerLanguage.C_LANGUAGE) {
            this.voidInputIsVarargs = false;
        }
        this.generateCoreTypes();
        this.sortCoreTypes();
        this.pointerWordSize = ((SleighLanguage)prog.getLanguage()).getDefaultPointerWordSize();
    }

    public Program getProgram() {
        return this.program;
    }

    public DataType findBaseType(String nm, long id) {
        if (id != 0L) {
            if (id > 0L) {
                DataType dt = this.progDataTypes.getDataType(id);
                if (dt != null) {
                    return dt;
                }
            } else {
                int index = this.findTypeById(id);
                if (index >= 0) {
                    return this.coreBuiltin[index].dt;
                }
            }
        }
        ArrayList<DataType> datatypes = new ArrayList<DataType>();
        this.builtInDataTypes.findDataTypes(nm, datatypes);
        if (datatypes.size() != 0) {
            return datatypes.get(0).clone(this.progDataTypes);
        }
        if (nm.equals("code")) {
            return DataType.DEFAULT;
        }
        return null;
    }

    public DataType decodeDataType(Decoder decoder) throws DecoderException {
        int attribId;
        int el = decoder.openElement();
        if (el == ElementId.ELEM_VOID.id()) {
            decoder.closeElement(el);
            return this.voidDt;
        }
        String name = "";
        long id = 0L;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_NAME.id()) {
                name = decoder.readString();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_ID.id()) continue;
            id = decoder.readUnsignedInteger();
        }
        if (el == ElementId.ELEM_TYPEREF.id()) {
            decoder.closeElement(el);
            return this.findBaseType(name, id);
        }
        if (el == ElementId.ELEM_DEF.id()) {
            decoder.closeElementSkipping(el);
            return this.findBaseType(name, id);
        }
        if (el != ElementId.ELEM_TYPE.id()) {
            throw new DecoderException("Expecting <type> element");
        }
        if (name.length() != 0) {
            decoder.closeElementSkipping(el);
            return this.findBaseType(name, id);
        }
        String meta = decoder.readString(AttributeId.ATTRIB_METATYPE);
        DataTypeImpl restype = null;
        if (meta.equals("ptr")) {
            int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
            if (decoder.peekElement() != 0) {
                DataType dt = this.decodeDataType(decoder);
                boolean useDefaultSize = size == this.dataOrganization.getPointerSize() || size > 8;
                restype = new PointerDataType(dt, useDefaultSize ? -1 : size, this.progDataTypes);
            }
        } else if (meta.equals("array")) {
            int arrsize = (int)decoder.readSignedInteger(AttributeId.ATTRIB_ARRAYSIZE);
            if (decoder.peekElement() != 0) {
                DataType dt = this.decodeDataType(decoder);
                if (dt == null || dt.getLength() == 0) {
                    dt = DataType.DEFAULT;
                }
                restype = new ArrayDataType(dt, arrsize, dt.getLength(), this.progDataTypes);
            }
        } else {
            if (meta.equals("spacebase")) {
                decoder.closeElementSkipping(el);
                return this.voidDt;
            }
            if (meta.equals("struct")) {
                int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                decoder.closeElementSkipping(el);
                return Undefined.getUndefinedDataType(size);
            }
            if (meta.equals("int")) {
                int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                decoder.closeElement(el);
                return AbstractIntegerDataType.getSignedDataType(size, this.progDataTypes);
            }
            if (meta.equals("uint")) {
                int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                decoder.closeElement(el);
                return AbstractIntegerDataType.getUnsignedDataType(size, this.progDataTypes);
            }
            if (meta.equals("float")) {
                int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                decoder.closeElement(el);
                return AbstractFloatDataType.getFloatDataType(size, this.progDataTypes);
            }
            if (meta.equals("partunion")) {
                int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                int offset = (int)decoder.readSignedInteger(AttributeId.ATTRIB_OFFSET);
                DataType dt = this.decodeDataType(decoder);
                decoder.closeElement(el);
                return new PartialUnion(this.progDataTypes, dt, offset, size);
            }
            int size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
            decoder.closeElementSkipping(el);
            return Undefined.getUndefinedDataType(size).clone(this.progDataTypes);
        }
        if (restype == null) {
            throw new DecoderException("Unable to resolve DataType");
        }
        decoder.closeElementSkipping(el);
        return restype;
    }

    public static DataType findPointerRelativeInner(DataType base, int offset) {
        DataTypeComponent component;
        if (base instanceof TypeDef) {
            base = ((TypeDef)base).getBaseDataType();
        }
        while (base instanceof Structure && (component = ((Structure)base).getComponentContaining(offset)) != null) {
            base = component.getDataType();
            if ((offset -= component.getOffset()) != 0) continue;
            return base;
        }
        return Undefined1DataType.dataType;
    }

    private void encodeVoid(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_VOID);
        encoder.closeElement(ElementId.ELEM_VOID);
    }

    private void encodePointer(Encoder encoder, Pointer type, AddressSpace spc, TypeDef typeDef, int size) throws IOException {
        DataType ptrto;
        encoder.openElement(ElementId.ELEM_TYPE);
        if (typeDef == null) {
            encoder.writeString(AttributeId.ATTRIB_NAME, "");
        } else {
            this.encodeNameIdAttributes(encoder, typeDef);
        }
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "ptr");
        int ptrLen = type.getLength();
        if (ptrLen <= 0) {
            ptrLen = size;
        }
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, ptrLen);
        if (this.pointerWordSize != 1) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_WORDSIZE, this.pointerWordSize);
        }
        if (spc != null) {
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, spc);
        }
        if ((ptrto = type.getDataType()) != null && ptrto.getDataTypeManager() != this.progDataTypes) {
            ptrto = ptrto.clone(this.progDataTypes);
        }
        if (ptrto == null) {
            this.encodeTypeRef(encoder, DefaultDataType.dataType, 1);
        } else if (ptrto instanceof AbstractStringDataType) {
            if (ptrto instanceof StringDataType || type instanceof TerminatedStringDataType) {
                this.encodeCharTypeRef(encoder, this.dataOrganization.getCharSize());
            } else if (ptrto instanceof StringUTF8DataType) {
                this.encodeCharTypeRef(encoder, 1);
            } else if (ptrto instanceof UnicodeDataType || ptrto instanceof TerminatedUnicodeDataType) {
                this.encodeCharTypeRef(encoder, 2);
            } else if (ptrto instanceof Unicode32DataType || ptrto instanceof TerminatedUnicode32DataType) {
                this.encodeCharTypeRef(encoder, 4);
            } else {
                this.encodeOpaqueString(encoder, ptrto, 16384);
            }
        } else if (ptrto instanceof FunctionDefinition) {
            this.encodeTypeRef(encoder, ptrto, ptrto.getLength());
        } else if (ptrto.getLength() < 0 && !(ptrto instanceof FunctionDefinition)) {
            this.encodeTypeRef(encoder, Undefined1DataType.dataType, 1);
        } else {
            this.encodeTypeRef(encoder, ptrto, ptrto.getLength());
        }
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodePointerRelative(Encoder encoder, TypeDef type, long offset, AddressSpace space) throws IOException {
        Pointer pointer = (Pointer)type.getBaseDataType();
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "ptrrel");
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, pointer.getLength());
        if (this.pointerWordSize != 1) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_WORDSIZE, this.pointerWordSize);
        }
        if (space != null) {
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
        }
        DataType parent = pointer.getDataType();
        DataType ptrto = PcodeDataTypeManager.findPointerRelativeInner(parent, (int)offset);
        this.encodeTypeRef(encoder, ptrto, 1);
        this.encodeTypeRef(encoder, parent, 1);
        encoder.openElement(ElementId.ELEM_OFF);
        encoder.writeSignedInteger(AttributeId.ATTRIB_CONTENT, offset);
        encoder.closeElement(ElementId.ELEM_OFF);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeArray(Encoder encoder, Array type, int size) throws IOException {
        if (type.isZeroLength()) {
            this.encodeOpaqueDataType(encoder, type, size);
            return;
        }
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, "");
        int sz = type.getLength();
        if (sz == 0) {
            sz = size;
        }
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "array");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, sz);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ARRAYSIZE, type.getNumElements());
        this.encodeTypeRef(encoder, type.getDataType(), type.getElementLength());
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeStructure(Encoder encoder, Structure type, int size) throws IOException {
        DataTypeComponent[] comps;
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        int sz = type.getLength();
        if (sz == 0) {
            type = new StructureDataType(type.getCategoryPath(), type.getName(), 1);
            sz = type.getLength();
        }
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "struct");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, sz);
        for (DataTypeComponent comp : comps = type.getDefinedComponents()) {
            if (comp.isBitFieldComponent() || comp.getLength() == 0) continue;
            encoder.openElement(ElementId.ELEM_FIELD);
            String field_name = comp.getFieldName();
            if (field_name == null || field_name.length() == 0) {
                field_name = comp.getDefaultFieldName();
            }
            encoder.writeString(AttributeId.ATTRIB_NAME, field_name);
            encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, comp.getOffset());
            DataType fieldtype = comp.getDataType();
            this.encodeTypeRef(encoder, fieldtype, comp.getLength());
            encoder.closeElement(ElementId.ELEM_FIELD);
        }
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    public void encodeUnion(Encoder encoder, Union unionType) throws IOException {
        DataTypeComponent[] comps;
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, unionType);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "union");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, unionType.getLength());
        for (DataTypeComponent comp : comps = unionType.getDefinedComponents()) {
            if (comp.getLength() == 0) continue;
            encoder.openElement(ElementId.ELEM_FIELD);
            String field_name = comp.getFieldName();
            if (field_name == null || field_name.length() == 0) {
                field_name = comp.getDefaultFieldName();
            }
            encoder.writeString(AttributeId.ATTRIB_NAME, field_name);
            encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, comp.getOffset());
            encoder.writeSignedInteger(AttributeId.ATTRIB_ID, comp.getOrdinal());
            DataType fieldtype = comp.getDataType();
            this.encodeTypeRef(encoder, fieldtype, comp.getLength());
            encoder.closeElement(ElementId.ELEM_FIELD);
        }
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeEnum(Encoder encoder, Enum type, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        long[] keys = type.getValues();
        String metatype = "uint";
        for (long key : keys) {
            if (key >= 0L) continue;
            metatype = "int";
            break;
        }
        encoder.writeString(AttributeId.ATTRIB_METATYPE, metatype);
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, type.getLength());
        encoder.writeBool(AttributeId.ATTRIB_ENUM, true);
        for (long key : keys) {
            encoder.openElement(ElementId.ELEM_VAL);
            encoder.writeString(AttributeId.ATTRIB_NAME, type.getName(key));
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, key);
            encoder.closeElement(ElementId.ELEM_VAL);
        }
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeCharDataType(Encoder encoder, CharDataType type, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        boolean signed = type.isSigned();
        int sz = type.getLength();
        if (sz <= 0) {
            sz = size;
        }
        encoder.writeString(AttributeId.ATTRIB_METATYPE, signed ? "int" : "uint");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, sz);
        if (sz == 1) {
            encoder.writeBool(AttributeId.ATTRIB_CHAR, true);
        } else {
            encoder.writeBool(AttributeId.ATTRIB_UTF, true);
        }
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeWideCharDataType(Encoder encoder, DataType type) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "int");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, type.getLength());
        encoder.writeBool(AttributeId.ATTRIB_UTF, true);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeStringDataType(Encoder encoder, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, "");
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "array");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ARRAYSIZE, size);
        this.encodeCharTypeRef(encoder, this.dataOrganization.getCharSize());
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeStringUTF8DataType(Encoder encoder, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, "");
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "array");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ARRAYSIZE, size);
        this.encodeCharTypeRef(encoder, 1);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeUnicodeDataType(Encoder encoder, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, "");
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "array");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ARRAYSIZE, size / 2);
        this.encodeCharTypeRef(encoder, 2);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeUnicode32DataType(Encoder encoder, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, "");
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "array");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ARRAYSIZE, size / 4);
        this.encodeCharTypeRef(encoder, 4);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeFunctionDefinition(Encoder encoder, FunctionDefinition type) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "code");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, 1L);
        CompilerSpec cspec = this.program.getCompilerSpec();
        FunctionPrototype fproto = new FunctionPrototype(type, cspec, this.voidInputIsVarargs);
        fproto.encodePrototype(encoder, this);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeBooleanDataType(Encoder encoder, DataType type) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "bool");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, type.getLength());
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeAbstractIntegerDataType(Encoder encoder, AbstractIntegerDataType type, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        boolean signed = type.isSigned();
        int sz = type.getLength();
        if (sz <= 0) {
            sz = size;
        }
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, signed ? "int" : "uint");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, sz);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeAbstractFloatDataType(Encoder encoder, DataType type) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "float");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, type.getLength());
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeOpaqueDataType(Encoder encoder, DataType type, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        int sz = type.getLength();
        boolean isVarLength = false;
        if (sz <= 0) {
            sz = size;
            isVarLength = true;
        }
        this.encodeNameIdAttributes(encoder, type);
        if (sz < 16) {
            encoder.writeString(AttributeId.ATTRIB_METATYPE, "unknown");
        } else {
            encoder.writeString(AttributeId.ATTRIB_METATYPE, "struct");
        }
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, sz);
        if (isVarLength) {
            encoder.writeBool(AttributeId.ATTRIB_VARLENGTH, true);
        }
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeOpaqueString(Encoder encoder, DataType type, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_TYPE);
        this.encodeNameIdAttributes(encoder, type);
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "struct");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        encoder.writeBool(AttributeId.ATTRIB_OPAQUESTRING, true);
        encoder.writeBool(AttributeId.ATTRIB_VARLENGTH, true);
        encoder.openElement(ElementId.ELEM_FIELD);
        encoder.writeString(AttributeId.ATTRIB_NAME, "unknown_data1");
        encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, 0L);
        encoder.openElement(ElementId.ELEM_TYPEREF);
        encoder.writeString(AttributeId.ATTRIB_NAME, "byte");
        encoder.closeElement(ElementId.ELEM_TYPEREF);
        encoder.closeElement(ElementId.ELEM_FIELD);
        --size;
        encoder.openElement(ElementId.ELEM_FIELD);
        encoder.writeString(AttributeId.ATTRIB_NAME, "opaque_data");
        encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, 1L);
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, "");
        encoder.writeString(AttributeId.ATTRIB_METATYPE, "array");
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ARRAYSIZE, size);
        encoder.openElement(ElementId.ELEM_TYPEREF);
        encoder.writeString(AttributeId.ATTRIB_NAME, "byte");
        encoder.closeElement(ElementId.ELEM_TYPEREF);
        encoder.closeElement(ElementId.ELEM_TYPE);
        encoder.closeElement(ElementId.ELEM_FIELD);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    public void encodeCompositeZeroSizePlaceholder(Encoder encoder, DataType type) throws IOException {
        String metaString;
        if (type instanceof Structure) {
            metaString = "struct";
        } else if (type instanceof Union) {
            metaString = "union";
        } else {
            return;
        }
        encoder.openElement(ElementId.ELEM_TYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, type.getDisplayName());
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, this.progDataTypes.getID(type));
        encoder.writeString(AttributeId.ATTRIB_METATYPE, metaString);
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, 0L);
        encoder.closeElement(ElementId.ELEM_TYPE);
    }

    private void encodeTypeDef(Encoder encoder, TypeDef type, int size) throws IOException {
        DataType refType = type.getDataType();
        String format = null;
        int sz = refType.getLength();
        if (sz <= 0) {
            sz = size;
        }
        if (type.isPointer()) {
            if (PcodeDataTypeManager.hasUnsupportedTypedefSettings(type)) {
                refType = Undefined.getUndefinedDataType(sz);
            } else {
                AddressSpace space = PointerTypedefInspector.getPointerAddressSpace(type, this.program.getAddressFactory());
                long offset = PointerTypedefInspector.getPointerComponentOffset(type);
                if (offset != 0L) {
                    this.encodePointerRelative(encoder, type, offset, space);
                    return;
                }
                if (space != null) {
                    refType = type.getBaseDataType();
                    this.encodePointer(encoder, (Pointer)refType, space, type, size);
                    return;
                }
            }
        } else if (FormatSettingsDefinition.DEF.hasValue(type.getDefaultSettings()) && (format = FormatSettingsDefinition.DEF.getValueString(type.getDefaultSettings())).length() > 4) {
            format = format.substring(0, 3);
        }
        encoder.openElement(ElementId.ELEM_DEF);
        this.encodeNameIdAttributes(encoder, type);
        if (format != null) {
            encoder.writeString(AttributeId.ATTRIB_FORMAT, format);
        }
        this.encodeTypeRef(encoder, refType, sz);
        encoder.closeElement(ElementId.ELEM_DEF);
    }

    public void encodeTypeRef(Encoder encoder, DataType type, int size) throws IOException {
        long id;
        if (type != null && type.getDataTypeManager() != this.progDataTypes) {
            type = type.clone(this.progDataTypes);
        }
        if (type instanceof VoidDataType || type == null) {
            this.encodeType(encoder, type, size);
            return;
        }
        if (type instanceof AbstractIntegerDataType) {
            this.encodeType(encoder, type, size);
            return;
        }
        if (type instanceof Pointer) {
            this.encodeType(encoder, type, size);
            return;
        }
        if (type instanceof Array) {
            this.encodeType(encoder, type, size);
            return;
        }
        if (type instanceof FunctionDefinition) {
            id = this.progDataTypes.getID(type);
            if (id <= 0L) {
                this.encodeType(encoder, type, size);
                return;
            }
            size = 1;
        } else if (type.getLength() <= 0) {
            this.encodeType(encoder, type, size);
            return;
        }
        encoder.openElement(ElementId.ELEM_TYPEREF);
        if (type instanceof BuiltIn) {
            encoder.writeString(AttributeId.ATTRIB_NAME, ((BuiltIn)type).getDecompilerDisplayName(this.displayLanguage));
        } else {
            encoder.writeString(AttributeId.ATTRIB_NAME, type.getName());
            id = this.progDataTypes.getID(type);
            if (id > 0L) {
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, id);
            }
            if (type.getLength() <= 0 && size > 0) {
                encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
            }
        }
        encoder.closeElement(ElementId.ELEM_TYPEREF);
    }

    private static boolean hasUnsupportedTypedefSettings(TypeDef type) {
        return PointerTypedefInspector.getPointerType(type) != PointerType.DEFAULT || PointerTypedefInspector.hasPointerBitShift(type) || PointerTypedefInspector.hasPointerBitMask(type);
    }

    private void encodeNameIdAttributes(Encoder encoder, DataType type) throws IOException {
        if (type instanceof BuiltIn) {
            encoder.writeString(AttributeId.ATTRIB_NAME, ((BuiltIn)type).getDecompilerDisplayName(this.displayLanguage));
        } else {
            encoder.writeString(AttributeId.ATTRIB_NAME, type.getName());
            long id = this.progDataTypes.getID(type);
            if (id > 0L) {
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, id);
            }
        }
    }

    private void encodeCharTypeRef(Encoder encoder, int size) throws IOException {
        if (size == this.dataOrganization.getCharSize()) {
            encoder.openElement(ElementId.ELEM_TYPEREF);
            encoder.writeString(AttributeId.ATTRIB_NAME, "char");
            encoder.closeElement(ElementId.ELEM_TYPEREF);
            return;
        }
        if (size == this.dataOrganization.getWideCharSize()) {
            encoder.openElement(ElementId.ELEM_TYPEREF);
            encoder.writeString(AttributeId.ATTRIB_NAME, "wchar_t");
            encoder.closeElement(ElementId.ELEM_TYPEREF);
            return;
        }
        if (size == 2) {
            encoder.openElement(ElementId.ELEM_TYPEREF);
            encoder.writeString(AttributeId.ATTRIB_NAME, "wchar16");
            encoder.closeElement(ElementId.ELEM_TYPEREF);
            return;
        }
        if (size == 4) {
            encoder.openElement(ElementId.ELEM_TYPEREF);
            encoder.writeString(AttributeId.ATTRIB_NAME, "wchar32");
            encoder.closeElement(ElementId.ELEM_TYPEREF);
            return;
        }
        if (size == 1) {
            encoder.openElement(ElementId.ELEM_TYPEREF);
            encoder.writeString(AttributeId.ATTRIB_NAME, "byte");
            encoder.closeElement(ElementId.ELEM_TYPEREF);
            return;
        }
        throw new IllegalArgumentException("Unsupported character size");
    }

    public void encodeType(Encoder encoder, DataType type, int size) throws IOException {
        if (type != null && type.getDataTypeManager() != this.progDataTypes) {
            type = type.clone(this.progDataTypes);
        }
        if (type instanceof VoidDataType || type == null) {
            this.encodeVoid(encoder);
        } else if (type instanceof TypeDef) {
            this.encodeTypeDef(encoder, (TypeDef)type, size);
        } else if (type instanceof Pointer) {
            this.encodePointer(encoder, (Pointer)type, null, null, size);
        } else if (type instanceof Array) {
            this.encodeArray(encoder, (Array)type, size);
        } else if (type instanceof Structure) {
            this.encodeStructure(encoder, (Structure)type, size);
        } else if (type instanceof Union) {
            this.encodeUnion(encoder, (Union)type);
        } else if (type instanceof Enum) {
            this.encodeEnum(encoder, (Enum)type, size);
        } else if (type instanceof CharDataType) {
            this.encodeCharDataType(encoder, (CharDataType)type, size);
        } else if (type instanceof WideCharDataType || type instanceof WideChar16DataType || type instanceof WideChar32DataType) {
            this.encodeWideCharDataType(encoder, type);
        } else if (type instanceof AbstractStringDataType) {
            if (type instanceof StringDataType || type instanceof TerminatedStringDataType) {
                this.encodeStringDataType(encoder, size);
            } else if (type instanceof StringUTF8DataType) {
                this.encodeStringUTF8DataType(encoder, size);
            } else if (type instanceof UnicodeDataType || type instanceof TerminatedUnicodeDataType) {
                this.encodeUnicodeDataType(encoder, size);
            } else if (type instanceof Unicode32DataType || type instanceof TerminatedUnicode32DataType) {
                this.encodeUnicode32DataType(encoder, size);
            } else {
                this.encodeOpaqueString(encoder, type, size);
            }
        } else if (type instanceof FunctionDefinition) {
            this.encodeFunctionDefinition(encoder, (FunctionDefinition)type);
        } else if (type instanceof BooleanDataType) {
            this.encodeBooleanDataType(encoder, type);
        } else if (type instanceof AbstractIntegerDataType) {
            this.encodeAbstractIntegerDataType(encoder, (AbstractIntegerDataType)type, size);
        } else if (type instanceof AbstractFloatDataType) {
            this.encodeAbstractFloatDataType(encoder, type);
        } else {
            this.encodeOpaqueDataType(encoder, type, size);
        }
    }

    private void generateCoreTypes() {
        boolean bl;
        this.voidDt = new VoidDataType(this.progDataTypes);
        ArrayList<TypeMap> typeList = new ArrayList<TypeMap>();
        typeList.add(new TypeMap(DataType.DEFAULT, "undefined", "unknown", false, false));
        for (Undefined undefined : Undefined.getUndefinedDataTypes()) {
            typeList.add(new TypeMap(this.displayLanguage, undefined, "unknown", false, false));
        }
        for (BuiltIn builtIn : AbstractIntegerDataType.getSignedDataTypes(this.progDataTypes)) {
            typeList.add(new TypeMap(this.displayLanguage, builtIn.clone(this.progDataTypes), "int", false, false));
        }
        for (BuiltIn builtIn : AbstractIntegerDataType.getUnsignedDataTypes(this.progDataTypes)) {
            typeList.add(new TypeMap(this.displayLanguage, builtIn.clone(this.progDataTypes), "uint", false, false));
        }
        for (BuiltIn builtIn : AbstractFloatDataType.getFloatDataTypes(this.progDataTypes)) {
            typeList.add(new TypeMap(this.displayLanguage, builtIn, "float", false, false));
        }
        typeList.add(new TypeMap(DataType.DEFAULT, "code", "code", false, false));
        CharDataType charDataType = new CharDataType(this.progDataTypes);
        String charMetatype = null;
        boolean isChar = false;
        boolean bl2 = false;
        charMetatype = charDataType instanceof CharDataType && charDataType.isSigned() ? "int" : "uint";
        if (charDataType.getLength() == 1) {
            isChar = true;
        } else {
            bl = true;
        }
        typeList.add(new TypeMap(this.displayLanguage, charDataType, charMetatype, isChar, bl));
        WideCharDataType wideDataType = new WideCharDataType(this.progDataTypes);
        typeList.add(new TypeMap(this.displayLanguage, wideDataType, "int", false, true));
        if (wideDataType.getLength() != 2) {
            typeList.add(new TypeMap(this.displayLanguage, new WideChar16DataType(this.progDataTypes), "int", false, true));
        }
        if (wideDataType.getLength() != 4) {
            typeList.add(new TypeMap(this.displayLanguage, new WideChar32DataType(this.progDataTypes), "int", false, true));
        }
        BooleanDataType boolDataType = new BooleanDataType(this.progDataTypes);
        typeList.add(new TypeMap(this.displayLanguage, boolDataType, "bool", false, false));
        this.coreBuiltin = new TypeMap[typeList.size()];
        typeList.toArray(this.coreBuiltin);
    }

    private void sortCoreTypes() {
        Arrays.sort(this.coreBuiltin, (o1, o2) -> Long.compare(o1.id, o2.id));
    }

    private int findTypeById(long id) {
        int min = 0;
        int max = this.coreBuiltin.length - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            TypeMap typeMap = this.coreBuiltin[mid];
            if (id == typeMap.id) {
                return mid;
            }
            if (id < typeMap.id) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return -1;
    }

    public void encodeCoreTypes(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CORETYPES);
        encoder.openElement(ElementId.ELEM_VOID);
        encoder.closeElement(ElementId.ELEM_VOID);
        for (TypeMap typeMap : this.coreBuiltin) {
            encoder.openElement(ElementId.ELEM_TYPE);
            encoder.writeString(AttributeId.ATTRIB_NAME, typeMap.name);
            encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, typeMap.dt.getLength());
            encoder.writeString(AttributeId.ATTRIB_METATYPE, typeMap.metatype);
            if (typeMap.isChar) {
                encoder.writeBool(AttributeId.ATTRIB_CHAR, true);
            }
            if (typeMap.isUtf) {
                encoder.writeBool(AttributeId.ATTRIB_UTF, true);
            }
            encoder.writeSignedInteger(AttributeId.ATTRIB_ID, typeMap.id);
            encoder.closeElement(ElementId.ELEM_TYPE);
        }
        encoder.closeElement(ElementId.ELEM_CORETYPES);
    }

    private static class TypeMap {
        public DataType dt;
        public String name;
        public String metatype;
        public boolean isChar;
        public boolean isUtf;
        public long id;

        public TypeMap(DecompilerLanguage lang, DataType d, String meta, boolean isChar, boolean isUtf) {
            this.dt = d;
            this.name = d instanceof BuiltIn ? ((BuiltIn)d).getDecompilerDisplayName(lang) : d.getName();
            this.metatype = meta;
            this.isChar = isChar;
            this.isUtf = isUtf;
            this.id = TypeMap.hashName(this.name);
        }

        public TypeMap(DataType d, String nm, String meta, boolean isChar, boolean isUtf) {
            this.dt = d;
            this.name = nm;
            this.metatype = meta;
            this.isChar = isChar;
            this.isUtf = isUtf;
            this.id = TypeMap.hashName(this.name);
        }

        public static long hashName(String name) {
            long res = 123L;
            for (int i = 0; i < name.length(); ++i) {
                res = res << 8 | res >>> 56;
                if (((res += (long)name.charAt(i)) & 1L) != 0L) continue;
                res ^= 0xFEABFEABL;
            }
            return res |= Long.MIN_VALUE;
        }
    }
}

