/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.GhidraDataConverter;
import java.math.BigInteger;

public class ByteMemBufferImpl
implements MemBuffer {
    private final GhidraDataConverter converter;
    private byte[] bytes;
    private Address addr;

    public ByteMemBufferImpl(Address addr, byte[] bytes, boolean isBigEndian) {
        this.addr = addr;
        this.bytes = bytes;
        this.converter = GhidraDataConverter.getInstance(isBigEndian);
    }

    public int getLength() {
        return this.bytes.length;
    }

    @Override
    public Address getAddress() {
        return this.addr;
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        if (offset < 0 || offset >= this.bytes.length) {
            throw new MemoryAccessException("Offset " + offset + " is not in range");
        }
        return this.bytes[offset];
    }

    @Override
    public Memory getMemory() {
        return null;
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        if (offset < 0 || offset >= this.bytes.length) {
            return 0;
        }
        int len = Math.min(b.length, this.bytes.length - offset);
        System.arraycopy(this.bytes, offset, b, 0, len);
        return len;
    }

    @Override
    public boolean isBigEndian() {
        return this.converter.isBigEndian();
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        return this.converter.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        return this.converter.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        return this.converter.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        return this.converter.getBigInteger(this, offset, size, signed);
    }
}

