/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public interface InjectPayload {
    public static final int CALLFIXUP_TYPE = 1;
    public static final int CALLOTHERFIXUP_TYPE = 2;
    public static final int CALLMECHANISM_TYPE = 3;
    public static final int EXECUTABLEPCODE_TYPE = 4;

    public String getName();

    public int getType();

    public String getSource();

    public int getParamShift();

    public InjectParameter[] getInput();

    public InjectParameter[] getOutput();

    public boolean isErrorPlaceholder();

    public void inject(InjectContext var1, PcodeEmit var2);

    public PcodeOp[] getPcode(Program var1, InjectContext var2);

    public boolean isFallThru();

    public boolean isIncidentalCopy();

    public void encode(Encoder var1) throws IOException;

    public void restoreXml(XmlPullParser var1, SleighLanguage var2) throws XmlParseException;

    public boolean isEquivalent(InjectPayload var1);

    public static class InjectParameter {
        private String name;
        private int index;
        private int size;

        public InjectParameter(String nm, int sz) {
            this.name = nm;
            this.index = 0;
            this.size = sz;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public int getSize() {
            return this.size;
        }

        void setIndex(int i) {
            this.index = i;
        }

        public boolean isEquivalent(InjectParameter obj) {
            if (!this.name.equals(obj.name)) {
                return false;
            }
            return this.index == obj.index && this.size == obj.size;
        }
    }
}

