/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotYetImplementedException;

public abstract class CompositeDataTypeImpl
extends GenericDataType
implements CompositeInternal {
    private String description = "";
    protected int minimumAlignment = 0;
    protected int packing = -1;

    CompositeDataTypeImpl(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path != null ? path : CategoryPath.ROOT, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
    }

    CompositeDataTypeImpl(CategoryPath path, String name, DataTypeManager dtm) {
        super(path != null ? path : CategoryPath.ROOT, name, dtm);
    }

    @Override
    public int getStoredPackingValue() {
        return this.packing;
    }

    @Override
    public int getStoredMinimumAlignment() {
        return this.minimumAlignment;
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    protected int getPreferredComponentLength(DataType dataType, int length) {
        if (DataTypeComponent.usesZeroLengthComponent(dataType)) {
            return 0;
        }
        if ((this.isPackingEnabled() || this instanceof Union) && !(dataType instanceof Dynamic)) {
            length = -1;
        }
        int dtLength = dataType.getLength();
        if (length <= 0) {
            length = dtLength;
        } else if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Positive length must be specified for " + dataType.getDisplayName() + " component");
        }
        return length;
    }

    @Override
    public abstract boolean hasLanguageDependantLength();

    @Override
    public final boolean isNotYetDefined() {
        return this.getNumComponents() == 0 && !this.isPackingEnabled();
    }

    @Override
    public boolean isPartOf(DataType dataTypeOfInterest) {
        return DataTypeUtilities.isSecondPartOfFirst(this, dataTypeOfInterest);
    }

    protected void checkAncestry(DataType dataType) throws IllegalArgumentException {
        if (this.equals(dataType)) {
            throw new IllegalArgumentException("Data type " + this.getDisplayName() + " can't contain itself.");
        }
        if (DataTypeUtilities.isSecondPartOfFirst(dataType, this)) {
            throw new IllegalArgumentException("Data type " + dataType.getDisplayName() + " has " + this.getDisplayName() + " within it.");
        }
    }

    protected DataType validateDataType(DataType dataType) {
        Dynamic dynamicDataType;
        if (dataType == DataType.DEFAULT) {
            if (this.isPackingEnabled() || this instanceof Union) {
                return Undefined1DataType.dataType;
            }
            return dataType;
        }
        if (dataType instanceof Dynamic ? !(dynamicDataType = (Dynamic)dataType).canSpecifyLength() : dataType instanceof FactoryDataType || dataType.getLength() <= 0) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
        return dataType;
    }

    protected boolean updateBitFieldDataType(DataTypeComponentImpl bitfieldComponent, DataType oldDt, DataType newDt) throws InvalidDataTypeException {
        if (!bitfieldComponent.isBitFieldComponent()) {
            throw new AssertException("expected bitfield component");
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)bitfieldComponent.getDataType();
        if (bitfieldDt.getBaseDataType() != oldDt) {
            return false;
        }
        if (newDt != null) {
            BitFieldDataType.checkBaseDataType(newDt);
            int maxBitSize = 8 * newDt.getLength();
            if (bitfieldDt.getBitSize() > maxBitSize) {
                throw new InvalidDataTypeException("Replacement datatype too small for bitfield");
            }
        }
        try {
            BitFieldDataType newBitfieldDt = new BitFieldDataType(newDt, bitfieldDt.getDeclaredBitSize(), bitfieldDt.getBitOffset());
            bitfieldComponent.setDataType(newBitfieldDt);
            oldDt.removeParent(this);
            newDt.addParent(this);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException("unexpected");
        }
        return true;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc == null ? "" : desc;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public void setValue(MemBuffer buf, Settings settings, int length, Object value) {
        throw new NotYetImplementedException("setValue() not implemented");
    }

    @Override
    public final DataTypeComponent add(DataType dataType) {
        return this.add(dataType, -1, null, null);
    }

    @Override
    public final DataTypeComponent add(DataType dataType, int length) {
        return this.add(dataType, length, null, null);
    }

    @Override
    public final DataTypeComponent add(DataType dataType, String fieldName, String comment) {
        return this.add(dataType, -1, fieldName, comment);
    }

    @Override
    public final DataTypeComponent insert(int ordinal, DataType dataType, int length) {
        return this.insert(ordinal, dataType, length, null, null);
    }

    @Override
    public final DataTypeComponent insert(int ordinal, DataType dataType) {
        return this.insert(ordinal, dataType, -1, null, null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        this.checkValidName(name);
        this.name = name;
    }

    @Override
    public final void repack() {
        this.repack(true);
    }

    public abstract boolean repack(boolean var1);

    @Override
    public void setPackingEnabled(boolean enabled) {
        if (enabled == this.isPackingEnabled()) {
            return;
        }
        this.setStoredPackingValue(enabled ? 0 : -1);
    }

    @Override
    public PackingType getPackingType() {
        if (this.packing < 0) {
            return PackingType.DISABLED;
        }
        if (this.packing == 0) {
            return PackingType.DEFAULT;
        }
        return PackingType.EXPLICIT;
    }

    @Override
    public void setToDefaultPacking() {
        this.setStoredPackingValue(0);
    }

    @Override
    public int getExplicitPackingValue() {
        return this.packing;
    }

    @Override
    public void setExplicitPackingValue(int packingValue) {
        if (packingValue <= 0) {
            throw new IllegalArgumentException("explicit packing value must be positive: " + packingValue);
        }
        this.setStoredPackingValue(packingValue);
    }

    private void setStoredPackingValue(int packingValue) {
        if (packingValue < -1) {
            throw new IllegalArgumentException("invalid packing value: " + packingValue);
        }
        if (packingValue == this.packing) {
            return;
        }
        if (this.packing == -1 || packingValue == -1) {
            this.minimumAlignment = 0;
        }
        this.packing = packingValue;
        this.repack(true);
    }

    @Override
    public AlignmentType getAlignmentType() {
        if (this.minimumAlignment < 0) {
            return AlignmentType.MACHINE;
        }
        if (this.minimumAlignment == 0) {
            return AlignmentType.DEFAULT;
        }
        return AlignmentType.EXPLICIT;
    }

    @Override
    public void setToDefaultAligned() {
        this.setStoredMinimumAlignment(0);
    }

    @Override
    public void setToMachineAligned() {
        this.setStoredMinimumAlignment(-1);
    }

    @Override
    public int getExplicitMinimumAlignment() {
        return this.minimumAlignment;
    }

    @Override
    public void setExplicitMinimumAlignment(int minimumAlignment) {
        if (minimumAlignment <= 0) {
            throw new IllegalArgumentException("explicit minimum alignment must be positive: " + minimumAlignment);
        }
        this.setStoredMinimumAlignment(minimumAlignment);
    }

    private void setStoredMinimumAlignment(int minimumAlignment) {
        if (minimumAlignment < -1) {
            throw new IllegalArgumentException("invalid minimum alignment value: " + minimumAlignment);
        }
        if (this.minimumAlignment == minimumAlignment) {
            return;
        }
        this.minimumAlignment = minimumAlignment;
        this.repack(true);
    }

    protected final int getNonPackedAlignment() {
        int alignment = this.minimumAlignment == 0 ? 1 : (this.minimumAlignment == -1 ? this.getDataOrganization().getMachineAlignment() : this.minimumAlignment);
        return alignment;
    }

    @Override
    public abstract int getAlignment();

    @Override
    public String toString() {
        return CompositeInternal.toString(this);
    }
}

