/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class BitFieldPackingImpl
implements BitFieldPacking {
    private boolean useMSConvention = false;
    private boolean typeAlignmentEnabled = true;
    private int zeroLengthBoundary = 0;

    @Override
    public boolean useMSConvention() {
        return this.useMSConvention;
    }

    @Override
    public boolean isTypeAlignmentEnabled() {
        return this.useMSConvention || this.typeAlignmentEnabled;
    }

    @Override
    public int getZeroLengthBoundary() {
        return this.useMSConvention ? 0 : this.zeroLengthBoundary;
    }

    public void setUseMSConvention(boolean useMSConvention) {
        this.useMSConvention = useMSConvention;
    }

    public void setTypeAlignmentEnabled(boolean typeAlignmentEnabled) {
        this.typeAlignmentEnabled = typeAlignmentEnabled;
    }

    public void setZeroLengthBoundary(int zeroLengthBoundary) {
        this.zeroLengthBoundary = zeroLengthBoundary;
    }

    public void encode(Encoder encoder) throws IOException {
        if (!this.useMSConvention && this.typeAlignmentEnabled && this.zeroLengthBoundary == 0) {
            return;
        }
        encoder.openElement(ElementId.ELEM_BITFIELD_PACKING);
        if (this.useMSConvention) {
            encoder.openElement(ElementId.ELEM_USE_MS_CONVENTION);
            encoder.writeBool(AttributeId.ATTRIB_VALUE, true);
            encoder.closeElement(ElementId.ELEM_USE_MS_CONVENTION);
        }
        if (!this.typeAlignmentEnabled) {
            encoder.openElement(ElementId.ELEM_TYPE_ALIGNMENT_ENABLED);
            encoder.writeBool(AttributeId.ATTRIB_VALUE, false);
            encoder.closeElement(ElementId.ELEM_TYPE_ALIGNMENT_ENABLED);
        }
        if (this.zeroLengthBoundary != 0) {
            encoder.openElement(ElementId.ELEM_ZERO_LENGTH_BOUNDARY);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.zeroLengthBoundary);
            encoder.closeElement(ElementId.ELEM_ZERO_LENGTH_BOUNDARY);
        }
        encoder.closeElement(ElementId.ELEM_BITFIELD_PACKING);
    }

    protected void restoreXml(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            String value = subel.getAttribute("value");
            if (name.equals("use_MS_convention")) {
                this.useMSConvention = SpecXmlUtils.decodeBoolean((String)value);
            } else if (name.equals("type_alignment_enabled")) {
                this.typeAlignmentEnabled = SpecXmlUtils.decodeBoolean((String)value);
            } else if (name.equals("zero_length_boundary")) {
                this.zeroLengthBoundary = SpecXmlUtils.decodeInt((String)value);
            }
            parser.end(subel);
        }
        parser.end();
    }
}

