/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.disassemble;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.ProgramContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisassemblerContextImpl
implements DisassemblerContext {
    private ProgramContext programContext;
    private Address startAddr;
    private Address contextChangePoint;
    private Address currentAddress;
    private Register contextRegister;
    private RegisterValue contextRegisterValue;
    private RegisterValue delayedContextRegisterValue;
    private RegisterValue repeatedNoflowValue;
    private Map<Register, RegisterValue> registerStateMap;
    private Map<Address, Map<Register, RegisterValue>> noAddressFutureRegisterStateMap;
    private Map<Address, Map<Address, Map<Register, RegisterValue>>> futureFlowRegisterStateMaps;

    public DisassemblerContextImpl(ProgramContext programContext) {
        this.programContext = programContext;
        this.contextRegister = programContext.getBaseContextRegister();
        this.contextRegisterValue = new RegisterValue(this.contextRegister);
        this.registerStateMap = new HashMap<Register, RegisterValue>();
        this.futureFlowRegisterStateMaps = new HashMap<Address, Map<Address, Map<Register, RegisterValue>>>();
        this.noAddressFutureRegisterStateMap = new HashMap<Address, Map<Register, RegisterValue>>();
        this.futureFlowRegisterStateMaps.put(Address.NO_ADDRESS, this.noAddressFutureRegisterStateMap);
    }

    public ProgramContext getProgramContext() {
        return this.programContext;
    }

    @Override
    public Register getBaseContextRegister() {
        return this.contextRegister;
    }

    public RegisterValue copyToFutureFlowState(Address address) {
        return this.copyToFutureFlowState(Address.NO_ADDRESS, address);
    }

    public RegisterValue copyToFutureFlowState(Address fromAddr, Address destAddr) {
        if (destAddr.equals(this.currentAddress)) {
            return this.contextRegisterValue;
        }
        RegisterValue flowValue = this.programContext.getFlowValue(this.delayedContextRegisterValue != null ? this.delayedContextRegisterValue : this.contextRegisterValue);
        this.setRegisterValue(fromAddr, destAddr, flowValue, false);
        for (Register reg : this.registerStateMap.keySet()) {
            RegisterValue value = this.registerStateMap.get(reg);
            this.setRegisterValue(fromAddr, destAddr, value, false);
        }
        return flowValue;
    }

    public ArrayList<RegisterValue> mergeToFutureFlowState(Address address) {
        return this.mergeToFutureFlowState(Address.NO_ADDRESS, address);
    }

    public ArrayList<RegisterValue> mergeToFutureFlowState(Address fromAddr, Address destAddr) {
        ArrayList<RegisterValue> collisionList = new ArrayList<RegisterValue>();
        if (destAddr.equals(this.currentAddress)) {
            return collisionList;
        }
        this.setRegisterValue(fromAddr, destAddr, this.programContext.getFlowValue(this.contextRegisterValue), false);
        for (Register reg : this.registerStateMap.keySet()) {
            RegisterValue value = this.registerStateMap.get(reg);
            RegisterValue curValue = this.getRegisterValue(reg, fromAddr, destAddr);
            if (curValue != null && !value.equals(curValue)) {
                collisionList.add(value);
            }
            this.setRegisterValue(fromAddr, destAddr, value, false);
        }
        return collisionList;
    }

    public void flowAbort() {
        if (!this.isFlowActive()) {
            throw new IllegalStateException("Attempted to abort a flow that was not started.");
        }
        this.startAddr = null;
        this.currentAddress = null;
    }

    public void flowStart(Address address) {
        this.flowStart(Address.NO_ADDRESS, address);
    }

    public void flowStart(Address fromAddr, Address toAddr) {
        if (this.isFlowActive()) {
            throw new IllegalStateException("Previous flow was not ended.");
        }
        this.startAddr = toAddr;
        this.currentAddress = toAddr;
        this.registerStateMap.clear();
        this.contextRegisterValue = null;
        this.delayedContextRegisterValue = null;
        this.contextChangePoint = toAddr;
        Map<Register, RegisterValue> futureStateMap = this.getFutureRegisterStateMap(fromAddr, toAddr, true);
        if (futureStateMap != null) {
            this.registerStateMap = futureStateMap;
        } else {
            this.registerStateMap.clear();
        }
        this.contextRegisterValue = this.getNextContextInFlow(toAddr, futureStateMap, true);
        this.setNextContextChangePoint(toAddr);
    }

    public RegisterValue getFlowContextValue(Address destAddr, boolean isFallThrough) {
        return this.getFlowContextValue(Address.NO_ADDRESS, destAddr, isFallThrough);
    }

    public RegisterValue getFlowContextValue(Address fromAddr, Address destAddr, boolean isFallThrough) {
        if (this.isFlowActive() && this.currentAddress.equals(destAddr)) {
            return this.contextRegisterValue;
        }
        RegisterValue nextContextRegisterValue = this.programContext.getFlowValue(this.contextRegisterValue);
        RegisterValue futureContextRegisterValue = null;
        Map<Register, RegisterValue> futureStateMap = this.getFutureRegisterStateMap(fromAddr, destAddr, false);
        if (futureStateMap != null) {
            futureContextRegisterValue = futureStateMap.get(this.contextRegister);
            nextContextRegisterValue = this.combineRegisterValues(nextContextRegisterValue, futureContextRegisterValue, true);
        }
        RegisterValue preExistingContextRegisterValue = this.programContext.getDisassemblyContext(destAddr);
        if (isFallThrough) {
            preExistingContextRegisterValue = this.programContext.getNonFlowValue(preExistingContextRegisterValue);
        }
        nextContextRegisterValue = this.combineRegisterValues(preExistingContextRegisterValue, nextContextRegisterValue, true);
        RegisterValue defaultValue = this.programContext.getDefaultValue(this.contextRegister, destAddr);
        nextContextRegisterValue = this.combineRegisterValues(defaultValue, nextContextRegisterValue, true);
        if (nextContextRegisterValue == null) {
            nextContextRegisterValue = new RegisterValue(this.contextRegister);
        }
        return nextContextRegisterValue;
    }

    public void flowToAddress(Address address) {
        this.flowToAddress(Address.NO_ADDRESS, address);
    }

    public void flowToAddress(Address fromAddr, Address destAddr) {
        if (!this.isFlowActive()) {
            throw new IllegalStateException("Attempted to continue a flow that was not started.");
        }
        if (this.currentAddress.compareTo(destAddr) > 0) {
            throw new IllegalArgumentException("address must not be less than current address");
        }
        if (this.currentAddress.equals(destAddr)) {
            return;
        }
        this.currentAddress = destAddr;
        if (this.delayedContextRegisterValue != null && !this.delayedContextRegisterValue.equals(this.contextRegisterValue)) {
            if (!this.startAddr.equals(this.currentAddress)) {
                this.saveProgramContext(this.startAddr, this.currentAddress.previous());
            }
            this.contextRegisterValue = this.delayedContextRegisterValue;
            this.startAddr = this.currentAddress;
        }
        Map<Register, RegisterValue> futureStateMap = this.getFutureRegisterStateMap(fromAddr, destAddr, true);
        RegisterValue nextContextRegisterValue = this.getNextContextInFlow(destAddr, futureStateMap, false);
        this.delayedContextRegisterValue = null;
        if (futureStateMap == null && nextContextRegisterValue.equals(this.contextRegisterValue)) {
            return;
        }
        if (!this.startAddr.equals(this.currentAddress)) {
            this.saveProgramContext(this.startAddr, this.currentAddress.previous());
        }
        this.startAddr = destAddr;
        this.contextRegisterValue = nextContextRegisterValue;
        if (futureStateMap != null) {
            for (Register register : futureStateMap.keySet()) {
                RegisterValue futureValue = futureStateMap.get(register);
                RegisterValue currentValue = this.registerStateMap.get(register);
                if (currentValue != null) {
                    futureValue = currentValue.combineValues(futureValue);
                }
                this.registerStateMap.put(register, futureValue);
            }
        }
    }

    private Map<Register, RegisterValue> getFutureRegisterStateMap(Address fromAddr, Address destAddr, boolean remove) {
        if (fromAddr == Address.NO_ADDRESS) {
            Map<Address, Map<Register, RegisterValue>> futureRegisterStateMap = this.noAddressFutureRegisterStateMap;
            Map<Register, RegisterValue> futureStateMap = null;
            futureStateMap = remove ? futureRegisterStateMap.remove(destAddr) : futureRegisterStateMap.get(destAddr);
            return futureStateMap;
        }
        Map<Address, Map<Register, RegisterValue>> futureRegisterStateMap = this.futureFlowRegisterStateMaps.get(destAddr);
        Map<Register, RegisterValue> futureStateMap = null;
        if (futureRegisterStateMap != null) {
            if (remove) {
                futureStateMap = futureRegisterStateMap.remove(fromAddr);
                if (futureStateMap != null && futureStateMap.isEmpty()) {
                    this.futureFlowRegisterStateMaps.remove(destAddr);
                }
            } else {
                futureStateMap = futureRegisterStateMap.get(fromAddr);
            }
        }
        return futureStateMap;
    }

    private Map<Register, RegisterValue> findFutureFlowStateMap(Address fromAddr, Address destAddr) {
        Map<Register, RegisterValue> stateMap = null;
        Map<Address, Map<Register, RegisterValue>> futureRegisterStateMap = this.noAddressFutureRegisterStateMap;
        if (fromAddr == Address.NO_ADDRESS) {
            stateMap = futureRegisterStateMap.get(destAddr);
            if (stateMap == null) {
                stateMap = new HashMap<Register, RegisterValue>();
                futureRegisterStateMap.put(destAddr, stateMap);
            }
        } else {
            futureRegisterStateMap = this.futureFlowRegisterStateMaps.get(destAddr);
            if (futureRegisterStateMap == null) {
                futureRegisterStateMap = new HashMap<Address, Map<Register, RegisterValue>>();
                this.futureFlowRegisterStateMaps.put(destAddr, futureRegisterStateMap);
            } else {
                stateMap = futureRegisterStateMap.get(fromAddr);
            }
            if (stateMap == null) {
                stateMap = new HashMap<Register, RegisterValue>();
                futureRegisterStateMap.put(fromAddr, stateMap);
            }
        }
        return stateMap;
    }

    private RegisterValue getNextContextInFlow(Address address, Map<Register, RegisterValue> futureStateMap, boolean startOfFlow) {
        RegisterValue contextValue = this.contextRegisterValue;
        if (this.delayedContextRegisterValue != null) {
            contextValue = this.combineRegisterValues(contextValue, this.delayedContextRegisterValue, true);
        }
        RegisterValue nextContextRegisterValue = this.programContext.getFlowValue(contextValue);
        RegisterValue futureContextRegisterValue = null;
        if (futureStateMap != null) {
            futureContextRegisterValue = futureStateMap.remove(this.contextRegister);
            nextContextRegisterValue = this.combineRegisterValues(nextContextRegisterValue, futureContextRegisterValue, true);
        }
        if (this.contextChangePoint != null && address.compareTo(this.contextChangePoint) >= 0) {
            RegisterValue preExistingContextRegisterValue = this.programContext.getDisassemblyContext(address);
            this.repeatedNoflowValue = this.programContext.getNonFlowValue(preExistingContextRegisterValue);
            if (!startOfFlow) {
                preExistingContextRegisterValue = this.repeatedNoflowValue;
            }
            nextContextRegisterValue = this.combineRegisterValues(preExistingContextRegisterValue, nextContextRegisterValue, true);
            this.setNextContextChangePoint(address);
        } else if (this.repeatedNoflowValue != null && this.repeatedNoflowValue.hasAnyValue()) {
            nextContextRegisterValue = this.combineRegisterValues(this.repeatedNoflowValue, nextContextRegisterValue, true);
        }
        RegisterValue defaultValue = this.programContext.getDefaultValue(this.contextRegister, address);
        nextContextRegisterValue = this.combineRegisterValues(defaultValue, nextContextRegisterValue, true);
        if (nextContextRegisterValue == null) {
            nextContextRegisterValue = new RegisterValue(this.contextRegister);
        }
        return nextContextRegisterValue;
    }

    private void setNextContextChangePoint(Address currentAddress) {
        AddressRange range = this.programContext.getRegisterValueRangeContaining(this.contextRegister, currentAddress);
        this.contextChangePoint = null;
        try {
            this.contextChangePoint = range.getMaxAddress().addNoWrap(1L);
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
    }

    public void flowEnd(Address maxAddress) {
        if (!this.isFlowActive()) {
            throw new IllegalStateException("Attempted to end a flow that was not started.");
        }
        if (maxAddress != null && maxAddress.compareTo(this.startAddr) >= 0) {
            this.saveProgramContext(this.startAddr, maxAddress);
        }
        this.startAddr = null;
        this.currentAddress = null;
    }

    @Override
    public List<Register> getRegisters() {
        return this.programContext.getRegisters();
    }

    @Override
    public Register getRegister(String name) {
        return this.programContext.getRegister(name);
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        if (register == null) {
            return null;
        }
        if (register.isProcessorContext()) {
            RegisterValue registerValue = null;
            if (this.contextRegister != null) {
                registerValue = this.contextRegisterValue.getRegisterValue(register);
            }
            return registerValue;
        }
        Register baseRegister = register.getBaseRegister();
        RegisterValue value = this.registerStateMap.get(baseRegister);
        if (value != null) {
            value = value.getRegisterValue(register);
        }
        if (value != null && value.hasValue()) {
            return value;
        }
        RegisterValue programValue = this.programContext.getRegisterValue(baseRegister, this.currentAddress);
        if (programValue == null) {
            return value;
        }
        programValue = programValue.getRegisterValue(register);
        return programValue.combineValues(value);
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        RegisterValue value = this.getRegisterValue(register);
        if (value != null) {
            return signed ? value.getSignedValue() : value.getUnsignedValue();
        }
        return null;
    }

    public void setValue(Register register, Address address, BigInteger newValue) {
        this.setRegisterValue(Address.NO_ADDRESS, address, new RegisterValue(register, newValue), true);
    }

    public void setValue(Register register, Address fromAddr, Address toAddr, BigInteger newValue) {
        this.setRegisterValue(fromAddr, toAddr, new RegisterValue(register, newValue), true);
    }

    @Override
    public void setFutureRegisterValue(Address address, RegisterValue value) {
        this.setFutureRegisterValue(Address.NO_ADDRESS, address, value);
    }

    @Override
    public void setFutureRegisterValue(Address fromAddr, Address toAddr, RegisterValue value) {
        this.setRegisterValue(fromAddr, toAddr, value, true);
    }

    private void setRegisterValue(Address fromAddr, Address destAddr, RegisterValue newValue, boolean newValuePrecedence) {
        if (newValue == null) {
            return;
        }
        if (this.isFlowActive() && this.currentAddress.equals(destAddr)) {
            this.setRegisterValue(newValue);
            return;
        }
        Register register = newValue.getRegister();
        Register baseRegister = register.getBaseRegister();
        Map<Register, RegisterValue> stateMap = this.findFutureFlowStateMap(fromAddr, destAddr);
        RegisterValue value = stateMap.get(baseRegister);
        if (value == null) {
            value = this.programContext.getNonDefaultValue(baseRegister, destAddr);
            newValuePrecedence = true;
        }
        value = this.combineRegisterValues(value, newValue, newValuePrecedence);
        stateMap.put(baseRegister, value);
    }

    private RegisterValue combineRegisterValues(RegisterValue currentValue, RegisterValue newValue, boolean newValuePrecedence) {
        if (currentValue == null || !currentValue.hasAnyValue()) {
            return newValue;
        }
        if (newValue == null || !newValue.hasAnyValue()) {
            return currentValue;
        }
        if (newValuePrecedence) {
            return currentValue.combineValues(newValue);
        }
        return newValue.combineValues(currentValue);
    }

    public Address getAddress() {
        return this.currentAddress;
    }

    private void saveProgramContext(Address start, Address end) {
        if (end == null || start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Invalid context range: (" + start + "," + end + ")");
        }
        for (Register reg : this.registerStateMap.keySet()) {
            if (reg.isProcessorContext()) continue;
            RegisterValue value = this.registerStateMap.get(reg);
            try {
                this.programContext.setRegisterValue(start, end, value);
            }
            catch (ContextChangeException contextChangeException) {}
        }
    }

    @Override
    public boolean hasValue(Register register) {
        BigInteger value = this.getValue(register, true);
        return value != null;
    }

    @Override
    public void setValue(Register register, BigInteger value) {
        this.setRegisterValue(new RegisterValue(register, value));
    }

    @Override
    public void clearRegister(Register register) {
        if (!this.isFlowActive()) {
            throw new IllegalStateException("Context flow has not be started");
        }
        if (!this.startAddr.equals(this.currentAddress)) {
            this.saveProgramContext(this.startAddr, this.currentAddress.previous());
            this.startAddr = this.currentAddress;
        }
        if (register.isProcessorContext()) {
            if (this.contextRegisterValue != null) {
                this.contextRegisterValue = this.contextRegisterValue.clearBitValues(register.getBaseMask());
            }
        } else {
            Register baseRegister = register.getBaseRegister();
            RegisterValue currentValue = this.registerStateMap.remove(baseRegister);
            if (currentValue != null && !register.isBaseRegister() && (currentValue = currentValue.clearBitValues(register.getBaseMask())).hasAnyValue()) {
                this.registerStateMap.put(baseRegister, currentValue);
            }
        }
    }

    public void setContextRegisterValue(RegisterValue value, Address address) {
        this.setContextRegisterValue(value, Address.NO_ADDRESS, address);
    }

    public void setContextRegisterValue(RegisterValue value, Address fromAddr, Address toAddr) {
        if (value == null) {
            return;
        }
        Register baseReg = value.getRegister().getBaseRegister();
        if (!baseReg.isProcessorContext() || baseReg != this.contextRegister) {
            throw new IllegalArgumentException("Invalid processor context register value");
        }
        if (this.isFlowActive() && this.currentAddress.equals(toAddr)) {
            this.contextRegisterValue = this.contextRegisterValue.combineValues(value);
            return;
        }
        this.setRegisterValue(fromAddr, toAddr, value, true);
    }

    @Override
    public void setRegisterValue(RegisterValue value) {
        if (value == null) {
            return;
        }
        if (!this.isFlowActive()) {
            throw new IllegalStateException("Context flow has not been started");
        }
        Register register = value.getRegister();
        if (register.isProcessorContext()) {
            if (this.delayedContextRegisterValue == null) {
                this.delayedContextRegisterValue = this.contextRegisterValue;
            }
            this.delayedContextRegisterValue = this.combineRegisterValues(this.delayedContextRegisterValue, value, true);
            return;
        }
        if (!this.startAddr.equals(this.currentAddress)) {
            this.saveProgramContext(this.startAddr, this.currentAddress.previous());
            this.startAddr = this.currentAddress;
        }
        Register baseRegister = register.getBaseRegister();
        RegisterValue currentValue = this.registerStateMap.remove(baseRegister);
        RegisterValue newValue = this.combineRegisterValues(currentValue, value, true);
        this.registerStateMap.put(baseRegister, newValue);
    }

    public BigInteger getValue(Register register, Address address, boolean signed) {
        return this.getValue(register, Address.NO_ADDRESS, address, signed);
    }

    public BigInteger getValue(Register register, Address fromAddr, Address toAddr, boolean signed) {
        RegisterValue value = this.getRegisterValue(register, fromAddr, toAddr);
        if (value == null) {
            return null;
        }
        return signed ? value.getSignedValue() : value.getUnsignedValue();
    }

    public RegisterValue getRegisterValue(Register register, Address address) {
        return this.getRegisterValue(register, Address.NO_ADDRESS, address);
    }

    public RegisterValue getRegisterValue(Register register, Address fromAddr, Address destAddr) {
        RegisterValue value;
        if (this.isFlowActive() && destAddr.compareTo(this.startAddr) >= 0 && destAddr.compareTo(this.currentAddress) <= 0) {
            return this.getRegisterValue(register);
        }
        Map<Address, Map<Register, RegisterValue>> futureRegisterStateMap = this.noAddressFutureRegisterStateMap;
        if (destAddr != Address.NO_ADDRESS) {
            futureRegisterStateMap = this.futureFlowRegisterStateMaps.get(destAddr);
        }
        Map<Register, RegisterValue> map = null;
        if (futureRegisterStateMap != null) {
            map = futureRegisterStateMap.get(fromAddr);
        }
        if (map != null && (value = map.get(register.getBaseRegister())) != null) {
            return value.getRegisterValue(register);
        }
        return this.programContext.getRegisterValue(register, destAddr);
    }

    public Address[] getKnownFlowToAddresses(Address toAddr) {
        Map<Address, Map<Register, RegisterValue>> futureRegisterStateMap;
        Map<Register, RegisterValue> map = this.noAddressFutureRegisterStateMap.get(toAddr);
        boolean has_NO_ADDRESS_flow = map != null;
        int extraForNoAddr = has_NO_ADDRESS_flow ? 1 : 0;
        Address[] flowsTo = new Address[0 + extraForNoAddr];
        if (toAddr != null && toAddr != Address.NO_ADDRESS && (futureRegisterStateMap = this.futureFlowRegisterStateMaps.get(toAddr)) != null) {
            Set<Address> keySet = futureRegisterStateMap.keySet();
            flowsTo = keySet.toArray(new Address[keySet.size() + extraForNoAddr]);
        }
        if (has_NO_ADDRESS_flow) {
            flowsTo[flowsTo.length - 1] = Address.NO_ADDRESS;
        }
        return flowsTo;
    }

    public boolean isFlowActive() {
        return this.startAddr != null;
    }
}

