/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class TypedefDBAdapterV1
extends TypedefDBAdapter
implements RecordTranslator {
    static final int VERSION = 1;
    static final int V1_TYPEDEF_DT_ID_COL = 0;
    static final int V1_TYPEDEF_NAME_COL = 1;
    static final int V1_TYPEDEF_CAT_COL = 2;
    static final int V1_TYPEDEF_SOURCE_ARCHIVE_ID_COL = 3;
    static final int V1_TYPEDEF_UNIVERSAL_DT_ID_COL = 4;
    static final int V1_TYPEDEF_SOURCE_SYNC_TIME_COL = 5;
    static final int V1_TYPEDEF_LAST_CHANGE_TIME_COL = 6;
    private Table table;

    public TypedefDBAdapterV1(DBHandle handle) throws VersionException {
        this.table = handle.getTable("Typedefs");
        if (this.table == null) {
            throw new VersionException("Missing Table: Typedefs");
        }
        int version = this.table.getSchema().getVersion();
        if (version != 1) {
            String msg = "Expected version 1 for table Typedefs but got " + this.table.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Typedefs");
    }

    @Override
    public DBRecord createRecord(long dataTypeID, String name, short flags, long categoryID, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBRecord getRecord(long typedefID) throws IOException {
        return this.translateRecord(this.table.getRecord(typedefID));
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }

    @Override
    public void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.table.findRecords((Field)new LongField(archiveID), 3);
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        Field[] keys = this.table.findRecords((Field)new LongField(datatypeID.getValue()), 4);
        for (int i = 0; i < keys.length; ++i) {
            DBRecord record = this.table.getRecord(keys[i]);
            if (record.getLongValue(3) != sourceID.getValue()) continue;
            return this.translateRecord(record);
        }
        return null;
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = TypedefDBAdapter.SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setString(2, oldRec.getString(1));
        rec.setLongValue(3, oldRec.getLongValue(2));
        rec.setLongValue(4, oldRec.getLongValue(3));
        rec.setLongValue(5, oldRec.getLongValue(4));
        rec.setLongValue(6, oldRec.getLongValue(5));
        rec.setLongValue(7, oldRec.getLongValue(6));
        return rec;
    }
}

