/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class SettingsDBAdapterV1
extends SettingsDBAdapter {
    private final short MIN_NAME_INDEX = 1;
    static final int V1_SETTINGS_ASSOCIATION_ID_COL = 0;
    static final int V1_SETTINGS_NAME_INDEX_COL = 1;
    static final int V1_SETTINGS_LONG_VALUE_COL = 2;
    static final int V1_SETTINGS_STRING_VALUE_COL = 3;
    private static int V1_SCHEMA_VERSION = 1;
    private static int V1_NAMES_SCHEMA_VERSION = 1;
    static final Schema V1_SETTINGS_SCHEMA = new Schema(V1_SCHEMA_VERSION, "SettingsID", new Field[]{LongField.INSTANCE, ShortField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE}, new String[]{"AssociationID", "Settings Name Index", "Long Value", "String Value"});
    static final Schema V1_NAME_TABLE_SCHEMA = new Schema(V1_NAMES_SCHEMA_VERSION, "NameIndex", new Field[]{StringField.INSTANCE}, new String[]{"Settings Name"});
    static final int V1_NAME_COL = 0;
    private Table settingsTable;
    private Table settingsNameTable;
    private HashMap<Short, String> nameIndexMap;
    private HashMap<String, Short> nameStringMap;

    SettingsDBAdapterV1(String tableName, DBHandle handle, boolean create) throws VersionException, IOException {
        String nameTableName = tableName + " Names";
        if (create) {
            this.settingsTable = handle.createTable(tableName, V1_SETTINGS_SCHEMA, new int[]{0});
            this.settingsNameTable = handle.createTable(nameTableName, V1_NAME_TABLE_SCHEMA);
        } else {
            this.settingsTable = handle.getTable(tableName);
            if (this.settingsTable == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int ver = this.settingsTable.getSchema().getVersion();
            if (ver != V1_SCHEMA_VERSION) {
                throw new VersionException(ver < V1_SCHEMA_VERSION);
            }
            this.settingsNameTable = handle.getTable(nameTableName);
            if (this.settingsNameTable == null || this.settingsNameTable.getSchema().getVersion() != V1_NAMES_SCHEMA_VERSION) {
                throw new VersionException("Missing expected table: " + nameTableName);
            }
        }
    }

    @Override
    String getTableName() {
        return this.settingsTable.getName();
    }

    @Override
    DBRecord createSettingsRecord(long associationId, String name, String strValue, long longValue) throws IOException {
        DBRecord record = V1_SETTINGS_SCHEMA.createRecord(this.settingsTable.getKey());
        record.setLongValue(0, associationId);
        record.setShortValue(1, this.assignNameIndexValue(name));
        record.setString(3, strValue);
        record.setLongValue(2, longValue);
        this.settingsTable.putRecord(record);
        return record;
    }

    @Override
    public Field[] getSettingsKeys(long associationId) throws IOException {
        return this.settingsTable.findRecords((Field)new LongField(associationId), 0);
    }

    @Override
    void removeAllSettingsRecords(long associationId) throws IOException {
        for (Field key : this.getSettingsKeys(associationId)) {
            this.removeSettingsRecord(key.getLongValue());
        }
    }

    @Override
    boolean removeSettingsRecord(long settingsID) throws IOException {
        return this.settingsTable.deleteRecord(settingsID);
    }

    @Override
    boolean removeSettingsRecord(long associationId, String name) throws IOException {
        short nameIndex = this.getNameIndex(name);
        if (nameIndex < 1) {
            return false;
        }
        for (Field key : this.getSettingsKeys(associationId)) {
            DBRecord rec = this.settingsTable.getRecord(key);
            if (nameIndex != rec.getShortValue(1)) continue;
            this.settingsTable.deleteRecord(key);
            return true;
        }
        return false;
    }

    @Override
    String[] getSettingsNames(long associationId) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (Field key : this.getSettingsKeys(associationId)) {
            DBRecord rec = this.settingsTable.getRecord(key);
            list.add(this.getSettingName(rec));
        }
        String[] names = new String[list.size()];
        return list.toArray(names);
    }

    @Override
    void addAllValues(String name, Set<String> set) throws IOException {
        short nameIndex = this.getNameIndex(name);
        if (nameIndex < 1) {
            return;
        }
        for (DBRecord rec : this.settingsTable) {
            String s;
            if (nameIndex != rec.getShortValue(1) || StringUtils.isBlank((CharSequence)(s = rec.getString(3)))) continue;
            set.add(s);
        }
    }

    private void initNameMaps() throws IOException {
        if (this.nameIndexMap != null) {
            return;
        }
        this.nameIndexMap = new HashMap();
        this.nameStringMap = new HashMap();
        for (DBRecord nameRec : this.settingsNameTable) {
            short nameIndex = (short)nameRec.getKey();
            String name = nameRec.getString(0);
            this.nameIndexMap.put(nameIndex, name);
            this.nameStringMap.put(name, nameIndex);
        }
    }

    private short assignNameIndexValue(String name) throws IOException {
        this.initNameMaps();
        Short nameIndex = this.nameStringMap.get(name);
        if (nameIndex != null) {
            return nameIndex;
        }
        long key = Math.max(1L, this.settingsNameTable.getKey());
        if (key == 32767L) {
            throw new IOException("Too many settings names defined");
        }
        nameIndex = (short)key;
        DBRecord nameRec = V1_NAME_TABLE_SCHEMA.createRecord(key);
        nameRec.setString(0, name);
        this.settingsNameTable.putRecord(nameRec);
        this.nameIndexMap.put(nameIndex, name);
        this.nameStringMap.put(name, nameIndex);
        return nameIndex;
    }

    @Override
    String getSettingName(DBRecord normalizedRecord) throws IOException {
        this.initNameMaps();
        short nameIndex = normalizedRecord.getShortValue(1);
        return this.nameIndexMap.get(nameIndex);
    }

    @Override
    void invalidateNameCache() {
        this.nameIndexMap = null;
        this.nameStringMap = null;
    }

    private short getNameIndex(String name) throws IOException {
        this.initNameMaps();
        Short index = this.nameStringMap.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    DBRecord getSettingsRecord(long settingsID) throws IOException {
        return this.settingsTable.getRecord(settingsID);
    }

    @Override
    DBRecord getSettingsRecord(long associationId, String name) throws IOException {
        short nameIndex = this.getNameIndex(name);
        if (nameIndex < 1) {
            return null;
        }
        for (Field key : this.getSettingsKeys(associationId)) {
            DBRecord rec = this.settingsTable.getRecord(key);
            if (rec.getShortValue(1) != nameIndex) continue;
            return rec;
        }
        return null;
    }

    @Override
    void updateSettingsRecord(DBRecord record) throws IOException {
        if (this.getSettingName(record) == null) {
            throw new IOException("Record refers to invalid setting name index value");
        }
        this.settingsTable.putRecord(record);
    }

    @Override
    DBRecord updateSettingsRecord(long associationId, String name, String strValue, long longValue) throws IOException {
        strValue = StringUtils.isBlank((CharSequence)strValue) ? null : strValue.trim();
        DBRecord record = this.getSettingsRecord(associationId, name);
        if (record == null) {
            return this.createSettingsRecord(associationId, name, strValue, longValue);
        }
        String recStrValue = record.getString(3);
        long recLongValue = record.getLongValue(2);
        if (recLongValue != longValue || !Objects.equals(recStrValue, strValue)) {
            record.setString(3, strValue);
            record.setLongValue(2, longValue);
            this.settingsTable.putRecord(record);
            return record;
        }
        return null;
    }

    @Override
    int getRecordCount() {
        return this.settingsTable.getRecordCount();
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.settingsTable.iterator();
    }

    @Override
    RecordIterator getRecords(long minAssociationId, long maxAssociationId) throws IOException {
        return this.settingsTable.indexIterator(0, (Field)new LongField(minAssociationId), (Field)new LongField(maxAssociationId), true);
    }

    @Override
    void delete(long minAssociationId, long maxAssociationId, TaskMonitor monitor) throws CancelledException, IOException {
        DBFieldIterator it = this.settingsTable.indexKeyIterator(0, (Field)new LongField(minAssociationId), (Field)new LongField(maxAssociationId), true);
        while (it.hasNext()) {
            monitor.checkCanceled();
            this.settingsTable.deleteRecord(it.next());
        }
    }
}

