/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeSettingsDB;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotYetImplementedException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;

abstract class DataTypeDB
extends DatabaseObject
implements DataType {
    protected DBRecord record;
    protected final DataTypeManagerDB dataMgr;
    protected volatile Settings defaultSettings;
    private static final SettingsDefinition[] EMPTY_DEFINITIONS = new SettingsDefinition[0];
    private static final TypeDefSettingsDefinition[] EMPTY_TYPEDEF_DEFINITIONS = new TypeDefSettingsDefinition[0];
    protected boolean resolving;
    protected boolean pointerPostResolveRequired;
    protected Lock lock;
    private volatile String name;
    private volatile Category category;

    protected DataTypeDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, DBRecord record) {
        super(cache, record.getKey());
        this.dataMgr = dataMgr;
        this.record = record;
        this.lock = dataMgr.lock;
        this.refreshName();
    }

    protected void refreshName() {
        this.name = this.doGetName();
    }

    protected abstract String doGetName();

    protected abstract long doGetCategoryID();

    protected abstract void doSetCategoryPathRecord(long var1) throws IOException;

    protected abstract void doSetNameRecord(String var1) throws IOException, InvalidNameException;

    protected abstract UniversalID getSourceArchiveID();

    protected abstract void setSourceArchiveID(UniversalID var1);

    @Override
    public final DataOrganization getDataOrganization() {
        return this.dataMgr.getDataOrganization();
    }

    @Override
    protected void setDeleted() {
        this.defaultSettings = null;
        super.setDeleted();
    }

    @Override
    protected boolean refresh() {
        this.category = null;
        this.defaultSettings = null;
        this.refreshName();
        return true;
    }

    @Override
    public boolean isNotYetDefined() {
        return false;
    }

    @Override
    public boolean isZeroLength() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final String getName() {
        this.validate(this.lock);
        return this.name;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return null;
    }

    protected final String getOldName() {
        return this.name;
    }

    protected Settings doGetDefaultSettings() {
        return new DataTypeSettingsDB(this.dataMgr, this, this.key);
    }

    @Override
    public Settings getDefaultSettings() {
        Settings localDefaultSettings = this.defaultSettings;
        if (localDefaultSettings != null && !this.isInvalid()) {
            return localDefaultSettings;
        }
        this.lock.acquire();
        try {
            this.defaultSettings = this.checkIsValid() ? this.doGetDefaultSettings() : SettingsImpl.NO_SETTINGS;
            Settings settings = this.defaultSettings;
            return settings;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public URL getDocs() {
        return null;
    }

    public void setValue(MemBuffer buf, Settings settings, int length, Object value) {
        throw new NotYetImplementedException("setValue() not implemented");
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return EMPTY_DEFINITIONS;
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return EMPTY_TYPEDEF_DEFINITIONS;
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted(this.lock);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.dataMgr;
    }

    @Override
    public int getAlignment() {
        int length = this.getLength();
        if (length < 0) {
            return 1;
        }
        DataOrganization dataOrganization = this.dataMgr.getDataOrganization();
        return dataOrganization.getAlignment(this);
    }

    @Override
    public String getPathName() {
        return this.getDataTypePath().getPath();
    }

    protected void checkValidName(String newName) throws InvalidNameException {
        if (!DataUtilities.isValidDataTypeName(newName)) {
            throw new InvalidNameException();
        }
    }

    protected DataType resolve(DataType dt) {
        this.resolving = true;
        try {
            dt = this.dataMgr.resolve(dt, this.dataMgr.getDependencyConflictHandler());
        }
        finally {
            this.resolving = false;
        }
        return dt;
    }

    protected void postPointerResolve(DataType definitionDt, DataTypeConflictHandler handler) {
        throw new UnsupportedOperationException("post-resolve of pointers not implemented");
    }

    @Override
    public CategoryPath getCategoryPath() {
        Category cat = this.category;
        if (cat != null && !this.isInvalid()) {
            return cat.getCategoryPath();
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.category == null) {
                this.category = this.dataMgr.getCategory(this.doGetCategoryID());
            }
            if (this.category == null) {
                this.category = this.dataMgr.getRootCategory();
            }
            CategoryPath categoryPath = this.category.getCategoryPath();
            return categoryPath;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypePath getDataTypePath() {
        return new DataTypePath(this.getCategoryPath(), this.getName());
    }

    @Override
    public void setName(String newName) throws InvalidNameException, DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.getName().equals(newName)) {
                return;
            }
            CategoryPath categoryPath = this.getCategoryPath();
            if (this.dataMgr.getDataType(categoryPath, newName) != null) {
                throw new DuplicateNameException("DataType named " + newName + " already exists in category " + categoryPath.getPath());
            }
            this.doSetName(newName);
        }
        finally {
            this.lock.release();
        }
    }

    private final void doSetName(String newName) throws InvalidNameException {
        String oldName = this.getName();
        if (newName.equals(oldName)) {
            return;
        }
        this.checkValidName(newName);
        try {
            this.doSetNameRecord(newName);
            this.name = newName;
            this.notifyNameChanged(oldName);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.getCategoryPath().equals(path)) {
                return;
            }
            String currentName = this.getName();
            if (this.dataMgr.getDataType(path, currentName) != null) {
                throw new DuplicateNameException("DataType named " + currentName + " already exists in category " + path.getPath());
            }
            this.doSetCategoryPath(path);
        }
        finally {
            this.lock.release();
        }
    }

    private void doSetCategoryPath(CategoryPath path) {
        CategoryPath myPath = this.getCategoryPath();
        if (path.equals(myPath)) {
            return;
        }
        long oldCatId = this.doGetCategoryID();
        Category cat = this.dataMgr.createCategory(path);
        try {
            this.doSetCategoryPathRecord(cat.getID());
            this.category = cat;
            this.dataMgr.dataTypeCategoryPathChanged(this, myPath, oldCatId);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataType dt = this.dataMgr.getDataType(path, name);
            if (dt != null) {
                if (dt == this) {
                    return;
                }
                throw new DuplicateNameException("DataType named " + name + " already exists in category " + path.getPath());
            }
            String uniqueName = this.dataMgr.getUniqueName(path, this.getCategoryPath(), name);
            this.doSetName(uniqueName);
            this.doSetCategoryPath(path);
            if (!uniqueName.equals(name)) {
                this.doSetName(name);
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void updatePath(DataTypeDB dt) {
    }

    @Override
    public void addParent(DataType dt) {
        if (dt instanceof DataTypeDB && dt.getDataTypeManager() == this.dataMgr) {
            this.dataMgr.addParentChildRecord(((DataTypeDB)dt).key, this.key);
        }
    }

    @Override
    public void removeParent(DataType dt) {
        if (dt instanceof DataTypeDB && dt.getDataTypeManager() == this.dataMgr) {
            this.dataMgr.removeParentChildRecord(((DataTypeDB)dt).key, this.key);
        }
    }

    protected void notifySizeChanged(boolean isAutoChange) {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeSizeChanged(this);
        }
        this.dataMgr.dataTypeChanged(this, isAutoChange);
    }

    protected void notifyAlignmentChanged(boolean isAutoChange) {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeAlignmentChanged(this);
        }
        this.dataMgr.dataTypeChanged(this, isAutoChange);
    }

    protected void notifyNameChanged(String oldName) {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeNameChanged(this, oldName);
        }
        this.dataMgr.dataTypeNameChanged(this, oldName);
    }

    protected void notifyDeleted() {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeDeleted(this);
        }
    }

    @Override
    public Collection<DataType> getParents() {
        return this.dataMgr.getParentDataTypes(this.key);
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return null;
    }

    @Override
    public String getDefaultAbbreviatedLabelPrefix() {
        return this.getDefaultLabelPrefix();
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return this.getDefaultLabelPrefix();
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        return this.getDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public void setSourceArchive(SourceArchive archive) {
        UniversalID id;
        archive = this.getDataTypeManager().resolveSourceArchive(archive);
        UniversalID universalID = id = archive == null ? DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID : archive.getSourceArchiveID();
        if (id.equals((Object)this.getDataTypeManager().getUniversalID())) {
            id = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
        }
        this.setSourceArchiveID(id);
    }

    @Override
    public SourceArchive getSourceArchive() {
        if (this.dataMgr == null) {
            return null;
        }
        return this.dataMgr.getSourceArchive(this.getSourceArchiveID());
    }

    @Override
    public void replaceWith(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescription(String description) {
    }

    abstract void setUniversalID(UniversalID var1);

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType otherDt = (DataType)obj;
        return otherDt.getDataTypeManager() == this.getDataTypeManager() && this.getCategoryPath().equals(otherDt.getCategoryPath()) && this.getName().equals(otherDt.getName()) && this.isEquivalent(otherDt);
    }

    @Override
    public boolean isEncodable() {
        return false;
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        throw new DataTypeEncodeException("Encoding not supported", value, this);
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        throw new DataTypeEncodeException("Encoding not supported", repr, this);
    }
}

